/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\f\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkIHDR;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "bitspc", "", "colormodel", "cols", "getCols", "()I", "setCols", "(I)V", "compmeth", "filmeth", "interlaced", "getInterlaced", "setInterlaced", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "rows", "getRows", "setRows", "check", "", "createImageInfo", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "fillFromInfo", "isInterlaced", "", "parseFromRaw", "chunk", "Companion", "plot-api"})
public final class PngChunkIHDR
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;
    @NotNull
    public static final String ID = "IHDR";

    public PngChunkIHDR(@Nullable ImageInfo info) {
        super(ID, info);
        if (info != null) {
            this.fillFromInfo(info);
        }
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int n) {
        this.cols = n;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int n) {
        this.rows = n;
    }

    public final int getInterlaced() {
        return this.interlaced;
    }

    public final void setInterlaced(int n) {
        this.interlaced = n;
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = new ChunkRaw(13, ChunkHelper.INSTANCE.getB_IHDR(), true);
        int offset = 0;
        PngHelperInternal.INSTANCE.writeInt4tobytes(this.cols, c.getData(), offset);
        PngHelperInternal.INSTANCE.writeInt4tobytes(this.rows, c.getData(), offset += 4);
        offset += 4;
        byte[] byArray = c.getData();
        Intrinsics.checkNotNull((Object)byArray);
        byArray[offset++] = (byte)this.bitspc;
        byte[] byArray2 = c.getData();
        Intrinsics.checkNotNull((Object)byArray2);
        byArray2[offset++] = (byte)this.colormodel;
        byte[] byArray3 = c.getData();
        Intrinsics.checkNotNull((Object)byArray3);
        byArray3[offset++] = (byte)this.compmeth;
        byte[] byArray4 = c.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        byArray4[offset++] = (byte)this.filmeth;
        byte[] byArray5 = c.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        byArray5[offset] = (byte)this.interlaced;
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 13) {
            throw new PngjException("Bad IDHR len " + chunk.getLen());
        }
        InputPngStream st = chunk.getAsByteStream();
        this.cols = PngHelperInternal.INSTANCE.readInt4(st);
        this.rows = PngHelperInternal.INSTANCE.readInt4(st);
        this.bitspc = PngHelperInternal.INSTANCE.readByte(st);
        this.colormodel = PngHelperInternal.INSTANCE.readByte(st);
        this.compmeth = PngHelperInternal.INSTANCE.readByte(st);
        this.filmeth = PngHelperInternal.INSTANCE.readByte(st);
        this.interlaced = PngHelperInternal.INSTANCE.readByte(st);
    }

    public final boolean isInterlaced() {
        return this.interlaced == 1;
    }

    private final void fillFromInfo(ImageInfo info) {
        this.cols = info.getCols();
        this.rows = info.getRows();
        this.bitspc = this.getImgInfo().getBitDepth();
        int colormodel = 0;
        if (info.getAlpha()) {
            colormodel += 4;
        }
        if (info.getIndexed()) {
            ++colormodel;
        }
        if (!info.getGreyscale()) {
            colormodel += 2;
        }
        this.colormodel = colormodel;
        this.compmeth = 0;
        this.filmeth = 0;
        this.interlaced = 0;
    }

    @NotNull
    public final ImageInfo createImageInfo() {
        this.check();
        boolean alpha = (this.colormodel & 4) != 0;
        boolean palette = (this.colormodel & 1) != 0;
        boolean grayscale = this.colormodel == 0 || this.colormodel == 4;
        return new ImageInfo(this.cols, this.rows, this.bitspc, alpha, grayscale, palette);
    }

    public final void check() {
        if (this.cols < 1 || this.rows < 1 || this.compmeth != 0 || this.filmeth != 0) {
            throw new PngjInputException("bad IHDR: col/row/compmethod/filmethod invalid");
        }
        if (this.bitspc != 1 && this.bitspc != 2 && this.bitspc != 4 && this.bitspc != 8 && this.bitspc != 16) {
            throw new PngjInputException("bad IHDR: bitdepth invalid");
        }
        if (this.interlaced < 0 || this.interlaced > 1) {
            throw new PngjInputException("bad IHDR: interlace invalid");
        }
        switch (this.colormodel) {
            case 0: {
                break;
            }
            case 3: {
                if (this.bitspc != 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            case 2: 
            case 4: 
            case 6: {
                if (this.bitspc == 8 || this.bitspc == 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            default: {
                throw new PngjInputException("bad IHDR: invalid colormodel");
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkIHDR$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

