/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.Checksum;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjBadCrcException;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.Zip;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0007J\b\u0010)\u001a\u00020&H\u0002J\u0013\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020\nH\u0016J\u001e\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00105\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "", "len", "", "idbytes", "", "alloc", "", "(I[BZ)V", "id", "", "(ILjava/lang/String;Z)V", "asByteStream", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "getAsByteStream", "()Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "crcengine", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "crcval", "getCrcval", "()[B", "setCrcval", "([B)V", "data", "getData", "setData", "getId", "()Ljava/lang/String;", "getIdbytes", "getLen", "()I", "offset", "", "getOffset", "()J", "setOffset", "(J)V", "allocData", "", "checkCrc", "throwExcep", "computeCrcForWriting", "equals", "other", "hashCode", "toString", "updateCrc", "buf", "off", "writeChunk", "os", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "writeChunkCrc", "writeChunkHeader", "plot-api"})
public final class ChunkRaw {
    private final int len;
    @NotNull
    private final byte[] idbytes;
    @NotNull
    private final String id;
    @Nullable
    private byte[] data;
    private long offset;
    @NotNull
    private byte[] crcval;
    @Nullable
    private Checksum crcengine;

    public ChunkRaw(int len, @NotNull String id, boolean alloc) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.len = len;
        this.crcval = new byte[4];
        this.id = id;
        this.idbytes = ChunkHelper.INSTANCE.toBytesLatin1(id);
        for (int i = 0; i < 4; ++i) {
            if (this.idbytes[i] >= 65 && this.idbytes[i] <= 122) {
                byte by = this.idbytes[i];
                boolean bl = 91 <= by ? by < 97 : false;
                if (!bl) continue;
            }
            throw new PngjException("Bad id chunk: must be ascii letters " + id);
        }
        if (alloc) {
            this.allocData();
        }
    }

    public final int getLen() {
        return this.len;
    }

    @NotNull
    public final byte[] getIdbytes() {
        return this.idbytes;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final byte[] getData() {
        return this.data;
    }

    public final void setData(@Nullable byte[] byArray) {
        this.data = byArray;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long l) {
        this.offset = l;
    }

    @NotNull
    public final byte[] getCrcval() {
        return this.crcval;
    }

    public final void setCrcval(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.crcval = byArray;
    }

    public ChunkRaw(int len, @NotNull byte[] idbytes, boolean alloc) {
        Intrinsics.checkNotNullParameter((Object)idbytes, (String)"idbytes");
        this(len, ChunkHelper.INSTANCE.toStringLatin1(idbytes), alloc);
    }

    public final void allocData() {
        block3: {
            block2: {
                if (this.data == null) break block2;
                Intrinsics.checkNotNull((Object)this.data);
                if (this.data.length >= this.len) break block3;
            }
            this.data = new byte[this.len];
        }
    }

    private final void computeCrcForWriting() {
        Checksum checksum = this.crcengine = Zip.INSTANCE.crc32();
        Intrinsics.checkNotNull((Object)checksum);
        checksum.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            Checksum checksum2 = this.crcengine;
            Intrinsics.checkNotNull((Object)checksum2);
            Intrinsics.checkNotNull((Object)this.data);
            checksum2.update(this.data, 0, this.len);
        }
        Checksum checksum3 = this.crcengine;
        Intrinsics.checkNotNull((Object)checksum3);
        PngHelperInternal.INSTANCE.writeInt4tobytes((int)checksum3.getValue(), this.crcval, 0);
    }

    public final void writeChunk(@NotNull OutputPngStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        this.writeChunkHeader(os);
        if (this.len > 0) {
            if (!(this.data != null)) {
                boolean bl = false;
                String string = "cannot write chunk, raw chunk data is null [" + this.id + ']';
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.data);
            PngHelperInternal.INSTANCE.writeBytes(os, this.data, 0, this.len);
        }
        this.computeCrcForWriting();
        this.writeChunkCrc(os);
    }

    private final void writeChunkHeader(OutputPngStream os) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + this.id + ']');
        }
        PngHelperInternal.INSTANCE.writeInt4(os, this.len);
        PngHelperInternal.INSTANCE.writeBytes(os, this.idbytes);
    }

    private final void writeChunkCrc(OutputPngStream os) {
        PngHelperInternal.INSTANCE.writeBytes(os, this.crcval, 0, 4);
    }

    public final void checkCrc(boolean throwExcep) {
        Checksum checksum = this.crcengine;
        Intrinsics.checkNotNull((Object)checksum);
        int crcComputed = (int)checksum.getValue();
        int crcExpected = PngHelperInternal.INSTANCE.readInt4fromBytes(this.crcval, 0);
        if (crcComputed != crcExpected) {
            String msg = "Bad CRC in chunk: " + this.id + " (offset:" + this.offset + "). Expected:" + crcExpected + " Got:" + crcComputed;
            if (throwExcep) {
                throw new PngjBadCrcException(msg);
            }
            System.out.println((Object)msg);
        }
    }

    public final void updateCrc(@NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (this.crcengine == null) {
            this.crcengine = Zip.INSTANCE.crc32();
        }
        Checksum checksum = this.crcengine;
        Intrinsics.checkNotNull((Object)checksum);
        checksum.update(buf, off, len);
    }

    @NotNull
    public final InputPngStream getAsByteStream() {
        Intrinsics.checkNotNull((Object)this.data);
        return new InputPngStream(this.data);
    }

    @NotNull
    public String toString() {
        return "chunkid=" + ChunkHelper.INSTANCE.toStringLatin1(this.idbytes) + " len=" + this.len;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.id.hashCode();
        result = prime * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        ChunkRaw cfr_ignored_0 = (ChunkRaw)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)((ChunkRaw)other).id)) {
            return false;
        }
        return this.offset == ((ChunkRaw)other).offset;
    }
}

