/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngjExceptionInternal;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010+\u001a\u00020\u0006J\u0006\u0010,\u001a\u00020\u001aJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\b\"\u0004\b\u001d\u0010\u0014R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\u0014R\u001e\u0010\"\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\bR\u001e\u0010$\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\bR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/Deinterlacer;", "", "imi", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "bytesToRead", "", "getBytesToRead", "()I", "<set-?>", "cols", "getCols", "currRowReal", "getCurrRowReal", "currRowSeq", "currRowSubimg", "getCurrRowSubimg", "dX", "getDX", "setDX", "(I)V", "dXsamples", "dY", "getDY", "setDY", "isEnded", "", "oX", "getOX", "setOX", "oXsamples", "oY", "getOY", "setOY", "pass", "getPass", "rows", "getRows", "totalRawBytes", "", "getTotalRawBytes", "()J", "totalRows", "getTotalRows", "nextRow", "setPass", "", "p", "setRow", "n", "Companion", "plot-api"})
public final class Deinterlacer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageInfo imi;
    private int pass;
    private int rows;
    private int cols;
    private int dY;
    private int dX;
    private int oY;
    private int oX;
    private int oXsamples;
    private int dXsamples;
    private int currRowSubimg;
    private int currRowReal;
    private int currRowSeq;
    private int totalRows;
    private boolean isEnded;

    public Deinterlacer(@NotNull ImageInfo imi) {
        Intrinsics.checkNotNullParameter((Object)imi, (String)"imi");
        this.imi = imi;
        this.currRowSubimg = -1;
        this.currRowReal = -1;
        this.setPass(1);
        this.setRow(0);
    }

    public final int getPass() {
        return this.pass;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getCols() {
        return this.cols;
    }

    public final int getDY() {
        return this.dY;
    }

    public final void setDY(int n) {
        this.dY = n;
    }

    public final int getDX() {
        return this.dX;
    }

    public final void setDX(int n) {
        this.dX = n;
    }

    public final int getOY() {
        return this.oY;
    }

    public final void setOY(int n) {
        this.oY = n;
    }

    public final int getOX() {
        return this.oX;
    }

    public final void setOX(int n) {
        this.oX = n;
    }

    public final int getCurrRowSubimg() {
        return this.currRowSubimg;
    }

    public final int getCurrRowReal() {
        return this.currRowReal;
    }

    private final void setRow(int n) {
        this.currRowSubimg = n;
        this.currRowReal = n * this.dY + this.oY;
        if (this.currRowReal < 0 || this.currRowReal >= this.imi.getRows()) {
            throw new PngjExceptionInternal("bad row - this should not happen");
        }
    }

    public final boolean nextRow() {
        int n = this.currRowSeq;
        this.currRowSeq = n + 1;
        if (this.rows == 0 || this.currRowSubimg >= this.rows - 1) {
            if (this.pass == 7) {
                this.isEnded = true;
                return false;
            }
            this.setPass(this.pass + 1);
            if (this.rows == 0) {
                n = this.currRowSeq;
                this.currRowSeq = n + -1;
                return this.nextRow();
            }
            this.setRow(0);
        } else {
            this.setRow(this.currRowSubimg + 1);
        }
        return true;
    }

    private final void setPass(int p) {
        if (this.pass == p) {
            return;
        }
        this.pass = p;
        byte[] pp = Companion.paramsForPass(p);
        this.dX = pp[0];
        this.dY = pp[1];
        this.oX = pp[2];
        this.oY = pp[3];
        this.rows = this.imi.getRows() > this.oY ? (this.imi.getRows() + this.dY - 1 - this.oY) / this.dY : 0;
        int n = this.cols = this.imi.getCols() > this.oX ? (this.imi.getCols() + this.dX - 1 - this.oX) / this.dX : 0;
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.dXsamples = this.dX * this.imi.getChannels();
        this.oXsamples = this.oX * this.imi.getChannels();
    }

    public final int getBytesToRead() {
        return (this.imi.getBitspPixel() * this.cols + 7) / 8;
    }

    public final int getTotalRows() {
        if (this.totalRows == 0) {
            for (int p = 1; p < 8; ++p) {
                int cols;
                byte[] pp = Companion.paramsForPass(p);
                int rows = this.imi.getRows() > pp[3] ? (this.imi.getRows() + pp[1] - 1 - pp[3]) / pp[1] : 0;
                int n = cols = this.imi.getCols() > pp[2] ? (this.imi.getCols() + pp[0] - 1 - pp[2]) / pp[0] : 0;
                if (rows <= 0 || cols <= 0) continue;
                this.totalRows += rows;
            }
        }
        return this.totalRows;
    }

    public final long getTotalRawBytes() {
        long bytes = 0L;
        for (int p = 1; p < 8; ++p) {
            byte[] pp = Companion.paramsForPass(p);
            int rows = this.imi.getRows() > pp[3] ? (this.imi.getRows() + pp[1] - 1 - pp[3]) / pp[1] : 0;
            int cols = this.imi.getCols() > pp[2] ? (this.imi.getCols() + pp[0] - 1 - pp[2]) / pp[0] : 0;
            int bytesr = (this.imi.getBitspPixel() * cols + 7) / 8;
            if (rows <= 0 || cols <= 0) continue;
            bytes += (long)rows * (1L + (long)bytesr);
        }
        return bytes;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/Deinterlacer$Companion;", "", "()V", "paramsForPass", "", "p", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] paramsForPass(int p) {
            byte[] byArray;
            switch (p) {
                case 1: {
                    byte[] byArray2 = new byte[]{8, 8, 0, 0};
                    byArray = byArray2;
                    break;
                }
                case 2: {
                    byte[] byArray3 = new byte[]{8, 8, 4, 0};
                    byArray = byArray3;
                    break;
                }
                case 3: {
                    byte[] byArray4 = new byte[]{4, 8, 0, 4};
                    byArray = byArray4;
                    break;
                }
                case 4: {
                    byte[] byArray5 = new byte[]{4, 4, 2, 0};
                    byArray = byArray5;
                    break;
                }
                case 5: {
                    byte[] byArray6 = new byte[]{2, 4, 0, 2};
                    byArray = byArray6;
                    break;
                }
                case 6: {
                    byte[] byArray7 = new byte[]{2, 2, 1, 0};
                    byArray = byArray7;
                    break;
                }
                case 7: {
                    byte[] byArray8 = new byte[]{1, 2, 0, 1};
                    byArray = byArray8;
                    break;
                }
                default: {
                    throw new PngjExceptionInternal("bad interlace pass" + p);
                }
            }
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

