/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.intern.standardizing;

import java.awt.Color;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002J\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/intern/standardizing/JvmStandardizing;", "", "()V", "isDateTimeJvm", "", "o", "isJvm", "isKotlinxDateTime", "noTimeZoneError", "", "time", "standardize", "unsupportedTypeError", "", "plot-api"})
public final class JvmStandardizing {
    @NotNull
    public static final JvmStandardizing INSTANCE = new JvmStandardizing();

    private JvmStandardizing() {
    }

    public final boolean isDateTimeJvm(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Object object = o;
        return object instanceof Date ? true : (object instanceof java.time.Instant ? true : (object instanceof ZonedDateTime ? true : (object instanceof java.time.LocalDate ? true : (object instanceof LocalTime ? true : (object instanceof LocalDateTime ? true : this.isKotlinxDateTime(o))))));
    }

    public final boolean isJvm(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return this.isDateTimeJvm(o) ? true : o instanceof Color;
    }

    @NotNull
    public final Object standardize(@NotNull Object o) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Object object2 = o;
        if (object2 instanceof Date) {
            object = ((Date)o).getTime();
        } else if (object2 instanceof java.time.Instant) {
            object = ((java.time.Instant)o).toEpochMilli();
        } else if (object2 instanceof ZonedDateTime) {
            object = ((ZonedDateTime)o).toInstant().toEpochMilli();
        } else {
            if (object2 instanceof java.time.LocalDate) {
                this.noTimeZoneError(o);
                throw new KotlinNothingValueException();
            }
            if (object2 instanceof LocalTime) {
                this.noTimeZoneError(o);
                throw new KotlinNothingValueException();
            }
            if (object2 instanceof LocalDateTime) {
                this.noTimeZoneError(o);
                throw new KotlinNothingValueException();
            }
            if (object2 instanceof Color) {
                String string = "#%02x%02x%02x";
                Object[] objectArray = new Object[]{((Color)o).getRed(), ((Color)o).getGreen(), ((Color)o).getBlue()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            } else if (this.isKotlinxDateTime(o)) {
                Object object3 = o;
                if (object3 instanceof Instant) {
                    object = ((Instant)o).toEpochMilliseconds();
                } else {
                    if (object3 instanceof LocalDate) {
                        this.noTimeZoneError(o);
                        throw new KotlinNothingValueException();
                    }
                    if (object3 instanceof kotlinx.datetime.LocalDateTime) {
                        this.noTimeZoneError(o);
                        throw new KotlinNothingValueException();
                    }
                    this.unsupportedTypeError(o);
                    object = Unit.INSTANCE;
                }
            } else {
                this.unsupportedTypeError(o);
                object = Unit.INSTANCE;
            }
        }
        return object;
    }

    private final boolean isKotlinxDateTime(Object o) {
        String string = o.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"o.javaClass.name");
        return StringsKt.startsWith$default((String)string, (String)"kotlinx.datetime.", (boolean)false, (int)2, null);
    }

    private final Void noTimeZoneError(Object time) {
        throw new IllegalArgumentException("Can't convert " + Reflection.getOrCreateKotlinClass(time.getClass()).getQualifiedName() + " to the number of milliseconds from the epoch of 1970-01-01T00:00:00Z.");
    }

    private final void unsupportedTypeError(Object o) {
        throw new IllegalArgumentException("Can't standardize value \"" + o + "\" of type " + Reflection.getOrCreateKotlinClass(o.getClass()).getQualifiedName() + " as string or number.");
    }
}

