/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.bistro.corr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.bistro.corr.CorrUtil;
import org.jetbrains.letsPlot.bistro.corr.CorrVar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062$\u0010\b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0004\u0012\u00020\u00040\tH\u0002J`\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00040\u000b2\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u000b2$\u0010\b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0004\u0012\u00020\u00040\tJ:\u0010\u000f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00040\u000b2\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u000bJ>\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\"\u0010\u0016\u001a\u00020\u00172\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u000bJt\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00060\f2\u001e\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/bistro/corr/CorrUtil;", "", "()V", "correlation", "", "xs", "", "ys", "corrFun", "Lkotlin/Function2;", "correlations", "", "Lkotlin/Pair;", "", "data", "correlationsFromCoefficients", "coeff", "correlationsToDataframe", "cm", "Lorg/jetbrains/letsPlot/bistro/corr/CorrUtil$CorrMatrix;", "xSeries", "ySeries", "isCoefficientsMatrix", "", "matrixXYSeries", "variablesInOrder", "type", "nullDiag", "threshold", "dropDiagNA", "dropOtherNA", "CorrMatrix", "plot-api"})
public final class CorrUtil {
    @NotNull
    public static final CorrUtil INSTANCE = new CorrUtil();

    private CorrUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> correlations(@NotNull Map<String, ? extends List<? extends Object>> data, @NotNull Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        void $this$mapKeysTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(corrFun, (String)"corrFun");
        DataFrame df = DataFrameUtil.INSTANCE.fromMap(data);
        Iterable $this$filter$iv = df.variables();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!df.isNumeric(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numerics = (List)destination$iv$iv;
        HashMap correlations2 = new HashMap();
        for (DataFrame.Variable variable : numerics) {
            ((Map)correlations2).put(TuplesKt.to((Object)variable, (Object)variable), 1.0);
        }
        Iterator $i$f$filter22 = numerics.iterator();
        int variable = 0;
        while ($i$f$filter22.hasNext()) {
            int i = variable++;
            DataFrame.Variable vx = (DataFrame.Variable)$i$f$filter22.next();
            List xs = df.getNumeric(vx);
            for (int j = 0; j < i; ++j) {
                DataFrame.Variable vy = (DataFrame.Variable)numerics.get(j);
                List ys = df.getNumeric(vy);
                ((Map)correlations2).put(TuplesKt.to((Object)vx, (Object)vy), this.correlation(xs, ys, corrFun));
            }
        }
        Map $this$mapKeys$iv = correlations2;
        boolean $i$f$mapKeys = false;
        Map i = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Pair pair = new Pair((Object)((DataFrame.Variable)((Pair)it.getKey()).getFirst()).getLabel(), (Object)((DataFrame.Variable)((Pair)it.getKey()).getSecond()).getLabel());
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(pair, entry);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> correlationsFromCoefficients(@NotNull Map<String, ? extends List<? extends Object>> coeff) {
        Map<String, ? extends List<? extends Object>> map2;
        Intrinsics.checkNotNullParameter(coeff, (String)"coeff");
        LinkedHashMap correlations2 = new LinkedHashMap();
        Map<String, ? extends List<? extends Object>> $this$onEachIndexed$iv = coeff;
        boolean $i$f$onEachIndexed = false;
        Map<String, ? extends List<? extends Object>> $this$onEachIndexed_u24lambda_u243$iv = map2 = $this$onEachIndexed$iv;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u243$iv.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void $this$forEach$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv$iv;
            int vxIndex = n;
            boolean bl2 = false;
            String vx = (String)entry.getKey();
            List vxCoeffs = (List)entry.getValue();
            Sequence sequence = SequencesKt.mapIndexed((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)coeff.keySet()), (int)vxIndex), (Function2)((Function2)new Function2<Integer, String, Pair<? extends Integer, ? extends String>>(vxIndex){
                final /* synthetic */ int $vxIndex;
                {
                    this.$vxIndex = $vxIndex;
                    super(2);
                }

                @NotNull
                public final Pair<Integer, String> invoke(int i, @NotNull String vy) {
                    Intrinsics.checkNotNullParameter((Object)vy, (String)"vy");
                    return TuplesKt.to((Object)(this.$vxIndex + i), (Object)vy);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl3 = false;
                int vyIndex = ((Number)pair.component1()).intValue();
                String vy = (String)pair.component2();
                Map map3 = correlations2;
                Pair pair2 = TuplesKt.to((Object)vx, (Object)vy);
                Object e = vxCoeffs.get(vyIndex);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Double");
                Double d = (Double)e;
                map3.put(pair2, d);
            }
        }
        return correlations2;
    }

    public final boolean isCoefficientsMatrix(@NotNull Map<String, ? extends List<? extends Object>> data) {
        boolean bl;
        block7: {
            Sequence values2;
            boolean bl2;
            Collection<? extends List<? extends Object>> vectors;
            block6: {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                if (data.isEmpty()) {
                    return false;
                }
                vectors = data.values();
                Iterable $this$any$iv = vectors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        List it = (List)element$iv;
                        boolean bl3 = false;
                        if (!(it.size() != data.size())) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            Sequence $this$all$iv = values2 = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)vectors), (Function1)isCoefficientsMatrix.values.1.INSTANCE);
            boolean $i$f$all = false;
            Iterator iterator = $this$all$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl4 = false;
                if (it instanceof Double && ((Number)it).doubleValue() >= -1.0 && ((Number)it).doubleValue() <= 1.0) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        return bl;
    }

    private final double correlation(List<Double> xs, List<Double> ys, Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        List filtered = SeriesUtil.INSTANCE.filterFinite(xs, ys);
        List xs2 = (List)filtered.get(0);
        List ys2 = (List)filtered.get(1);
        return ((Number)corrFun.invoke((Object)xs2, (Object)ys2)).doubleValue();
    }

    @NotNull
    public final Pair<List<String>, List<String>> matrixXYSeries(@NotNull Map<Pair<String, String>, Double> correlations2, @NotNull List<String> variablesInOrder, @NotNull String type, boolean nullDiag, double threshold, boolean dropDiagNA, boolean dropOtherNA) {
        Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
        Intrinsics.checkNotNullParameter(variablesInOrder, (String)"variablesInOrder");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ArrayList<String> xs = new ArrayList<String>();
        ArrayList<String> ys = new ArrayList<String>();
        CorrMatrix cm = new CorrMatrix(correlations2, nullDiag, threshold);
        Iterator<String> iterator = variablesInOrder.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int ix = n++;
            String x = iterator.next();
            List<String> iterY = Intrinsics.areEqual((Object)type, (Object)"upper") ? variablesInOrder.subList(ix, variablesInOrder.size()) : (Intrinsics.areEqual((Object)type, (Object)"lower") ? variablesInOrder.subList(0, ix + 1) : variablesInOrder);
            for (String y : iterY) {
                Double v = cm.value(x, y);
                if (v == null && (dropDiagNA && Intrinsics.areEqual((Object)x, (Object)y) || dropOtherNA && !Intrinsics.areEqual((Object)x, (Object)y))) continue;
                xs.add(x);
                ys.add(y);
            }
        }
        return new Pair(xs, ys);
    }

    @NotNull
    public final Map<String, List<Object>> correlationsToDataframe(@NotNull CorrMatrix cm, @NotNull List<String> xSeries, @NotNull List<String> ySeries) {
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter(xSeries, (String)"xSeries");
        Intrinsics.checkNotNullParameter(ySeries, (String)"ySeries");
        ArrayList<String> corrX = new ArrayList<String>();
        ArrayList<String> corrY = new ArrayList<String>();
        ArrayList<Double> corr = new ArrayList<Double>();
        ArrayList<Double> corrAbs = new ArrayList<Double>();
        for (Pair pair : CollectionsKt.zip((Iterable)xSeries, (Iterable)ySeries)) {
            String x = (String)pair.component1();
            String y = (String)pair.component2();
            Double d = cm.value(x, y);
            if (d == null) {
                continue;
            }
            double v = d;
            corrX.add(x);
            corrY.add(y);
            corr.add(v);
            corrAbs.add(Math.abs(v));
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CorrVar.INSTANCE.getX(), corrX), TuplesKt.to((Object)CorrVar.INSTANCE.getY(), corrY), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR(), corr), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR_ABS(), corrAbs)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012R&\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/bistro/corr/CorrUtil$CorrMatrix;", "", "correlations", "", "Lkotlin/Pair;", "", "", "nullDiag", "", "threshold", "(Ljava/util/Map;ZD)V", "toKey", "pair", "s0", "s1", "value", "x", "y", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "plot-api"})
    public static final class CorrMatrix {
        private final boolean nullDiag;
        private final double threshold;
        @NotNull
        private final Map<Pair<String, String>, Double> correlations;

        /*
         * WARNING - void declaration
         */
        public CorrMatrix(@NotNull Map<Pair<String, String>, Double> correlations2, boolean nullDiag, double threshold) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
            this.nullDiag = nullDiag;
            this.threshold = threshold;
            Map<Pair<String, String>, Double> map2 = correlations2;
            CorrMatrix corrMatrix = this;
            boolean $i$f$mapKeys = false;
            void var7_7 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Pair<String, String> pair = this.toKey((Pair<String, String>)((Pair)it.getKey()));
                Map map4 = map3;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map4.put(pair, v);
            }
            corrMatrix.correlations = destination$iv$iv;
        }

        private final Pair<String, String> toKey(String s0, String s1) {
            return s0.compareTo(s1) < 0 ? TuplesKt.to((Object)s0, (Object)s1) : TuplesKt.to((Object)s1, (Object)s0);
        }

        private final Pair<String, String> toKey(Pair<String, String> pair) {
            return this.toKey((String)pair.getFirst(), (String)pair.getSecond());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Double value(@NotNull String x, @NotNull String y) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            if (Intrinsics.areEqual((Object)x, (Object)y) && this.nullDiag) {
                object = null;
            } else {
                void var3_3;
                Double v = this.correlations.get(this.toKey(x, y));
                object = v == null ? null : (Math.abs(v) < this.threshold ? null : var3_3);
            }
            return object;
        }
    }
}

