/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import org.apache.jorphan.reflect.ServiceLoadExceptionHandler;
import org.slf4j.Logger;

public class LogAndIgnoreServiceLoadExceptionHandler
implements ServiceLoadExceptionHandler<Object> {
    private final Logger log;

    public LogAndIgnoreServiceLoadExceptionHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void handle(Class<?> service, String className, Throwable throwable) {
        if (throwable instanceof NoClassDefFoundError) {
            if (throwable.getMessage().contains("javafx")) {
                this.log.error("Exception registering implementation: [{}] of interface: [{}], a dependency used by the plugin class is missing. Add JavaFX to your Java installation if you want to use renderer: {}", new Object[]{className, service, className, throwable});
            } else {
                this.log.error("Exception registering implementation: [{}] of interface: [{}], a dependency used by the plugin class is missing", new Object[]{className, service, throwable});
            }
        } else {
            this.log.error("Exception registering implementation: [{}] of interface: [{}], a jar is probably missing", new Object[]{className, service, throwable});
        }
    }
}

