/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jorphan.collections.HashTreeTraverser;

public class HashTree
implements Serializable,
Map<Object, HashTree>,
Cloneable {
    private static final long serialVersionUID = 240L;
    private static final String FOUND = "found";
    protected final IdentityHashMap<Object, HashTree> data;

    public HashTree() {
        this(null, null);
    }

    protected HashTree(Map<Object, HashTree> _map) {
        this(_map, null);
    }

    public HashTree(Object key) {
        this(new IdentityHashMap(), key);
    }

    private HashTree(Map<Object, ? extends HashTree> _map, Object key) {
        if (_map != null) {
            if (_map instanceof IdentityHashMap) {
                this.data = (IdentityHashMap)_map;
            } else {
                IdentityHashMap<Object, ? extends HashTree> identityMap = new IdentityHashMap<Object, HashTree>(_map);
                this.data = identityMap;
            }
        } else {
            this.data = new IdentityHashMap();
        }
        if (key != null) {
            this.data.put(key, new HashTree());
        }
    }

    @Override
    public void putAll(Map<?, ? extends HashTree> map) {
        if (!(map instanceof HashTree)) {
            throw new UnsupportedOperationException("can only putAll other HashTree objects");
        }
        this.add((HashTree)map);
    }

    @Override
    public Set<Map.Entry<Object, HashTree>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public HashTree put(Object key, HashTree value) {
        HashTree previous = this.data.get(key);
        this.add(key, value);
        return previous;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Collection<HashTree> values() {
        return this.data.values();
    }

    public void add(Object key, HashTree subTree) {
        this.add(key).add(subTree);
    }

    public void add(HashTree newTree) {
        for (Object item : newTree.list()) {
            this.add(item).add(newTree.getTree(item));
        }
    }

    public HashTree(Collection<?> keys) {
        this.data = new IdentityHashMap();
        for (Object o : keys) {
            this.data.put(o, new HashTree());
        }
    }

    public HashTree(Object[] keys) {
        this.data = new IdentityHashMap();
        for (Object key : keys) {
            this.data.put(key, new HashTree());
        }
    }

    @Override
    public boolean containsKey(Object o) {
        return this.data.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void set(Object key, Object value) {
        this.data.put(key, this.createNewTree(value));
    }

    public void set(Object key, HashTree t) {
        this.data.put(key, t);
    }

    public void set(Object key, Object[] values) {
        this.data.put(key, this.createNewTree(Arrays.asList(values)));
    }

    public void set(Object key, Collection<?> values) {
        this.data.put(key, this.createNewTree(values));
    }

    public void set(Object[] treePath, Object[] values) {
        if (treePath != null && values != null) {
            this.set(Arrays.asList(treePath), Arrays.asList(values));
        }
    }

    public void set(Object[] treePath, Collection<?> values) {
        if (treePath != null) {
            this.set(Arrays.asList(treePath), values);
        }
    }

    public void set(Collection<?> treePath, Object[] values) {
        HashTree tree = this.addTreePath(treePath);
        tree.set(Arrays.asList(values));
    }

    public void set(Collection<?> values) {
        this.clear();
        this.add(values);
    }

    public void set(Collection<?> treePath, Collection<?> values) {
        HashTree tree = this.addTreePath(treePath);
        tree.set(values);
    }

    public HashTree add(Object key) {
        if (!this.data.containsKey(key)) {
            HashTree newTree = this.createNewTree();
            this.data.put(key, newTree);
            return newTree;
        }
        return this.getTree(key);
    }

    public void add(Object[] keys) {
        for (Object key : keys) {
            this.add(key);
        }
    }

    public void add(Collection<?> keys) {
        for (Object o : keys) {
            this.add(o);
        }
    }

    public HashTree add(Object key, Object value) {
        return this.add(key).add(value);
    }

    public void add(Object key, Object[] values) {
        this.add(key).add(values);
    }

    public void add(Object key, Collection<?> values) {
        this.add(key).add(values);
    }

    public void add(Object[] treePath, Object[] values) {
        if (treePath != null) {
            this.add((Collection<?>)Arrays.asList(treePath), (Collection<?>)Arrays.asList(values));
        }
    }

    public void add(Object[] treePath, Collection<?> values) {
        if (treePath != null) {
            this.add((Collection<?>)Arrays.asList(treePath), values);
        }
    }

    public HashTree add(Object[] treePath, Object value) {
        return this.add(Arrays.asList(treePath), value);
    }

    public void add(Collection<?> treePath, Object[] values) {
        HashTree tree = this.addTreePath(treePath);
        tree.add(Arrays.asList(values));
    }

    public HashTree add(Collection<?> treePath, Object value) {
        HashTree tree = this.addTreePath(treePath);
        return tree.add(value);
    }

    public void add(Collection<?> treePath, Collection<?> values) {
        HashTree tree = this.addTreePath(treePath);
        tree.add(values);
    }

    protected HashTree addTreePath(Collection<?> treePath) {
        HashTree tree = this;
        for (Object temp : treePath) {
            tree = tree.add(temp);
        }
        return tree;
    }

    public HashTree getTree(Object key) {
        return this.data.get(key);
    }

    @Override
    public HashTree get(Object key) {
        return this.getTree(key);
    }

    public HashTree getTree(Object[] treePath) {
        if (treePath != null) {
            return this.getTree(Arrays.asList(treePath));
        }
        return this;
    }

    public Object clone() {
        HashTree newTree = new HashTree();
        this.cloneTree(newTree);
        return newTree;
    }

    protected void cloneTree(HashTree newTree) {
        for (Object key : this.list()) {
            newTree.set(key, (HashTree)this.getTree(key).clone());
        }
    }

    protected HashTree createNewTree() {
        return new HashTree();
    }

    protected HashTree createNewTree(Object key) {
        return new HashTree(key);
    }

    protected HashTree createNewTree(Collection<?> values) {
        return new HashTree(values);
    }

    public HashTree getTree(Collection<?> treePath) {
        return this.getTreePath(treePath);
    }

    public Collection<Object> list() {
        return this.data.keySet();
    }

    public Collection<?> list(Object key) {
        HashTree temp = this.data.get(key);
        if (temp != null) {
            return temp.list();
        }
        return new HashSet();
    }

    @Override
    public HashTree remove(Object key) {
        return this.data.remove(key);
    }

    public Collection<?> list(Object[] treePath) {
        if (treePath != null) {
            return this.list(Arrays.asList(treePath));
        }
        return this.list();
    }

    public Collection<?> list(Collection<?> treePath) {
        HashTree tree = this.getTreePath(treePath);
        if (tree != null) {
            return tree.list();
        }
        return new HashSet();
    }

    public void replaceKey(Object currentKey, Object newKey) {
        HashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
    }

    public Object[] getArray() {
        return this.data.keySet().toArray();
    }

    public Object[] getArray(Object key) {
        HashTree t = this.getTree(key);
        if (t != null) {
            return t.getArray();
        }
        return null;
    }

    public Object[] getArray(Object[] treePath) {
        if (treePath != null) {
            return this.getArray(Arrays.asList(treePath));
        }
        return this.getArray();
    }

    public Object[] getArray(Collection<?> treePath) {
        HashTree tree = this.getTreePath(treePath);
        return tree != null ? tree.getArray() : null;
    }

    protected HashTree getTreePath(Collection<?> treePath) {
        HashTree tree = this;
        for (Object aTreePath : treePath) {
            if ((tree = tree.getTree(aTreePath)) != null) continue;
            return null;
        }
        return tree;
    }

    @Override
    public int hashCode() {
        int xor = 0;
        int sum = 0;
        int mul = 0;
        for (Map.Entry<Object, HashTree> objectHashTreeEntry : this.data.entrySet()) {
            int key = System.identityHashCode(objectHashTreeEntry.getKey());
            int value = objectHashTreeEntry.getValue().hashCode();
            xor = xor + key ^ value;
            sum = sum + key + value;
            mul += (key | 1) * (value | 1);
        }
        int hash = 1;
        hash = hash * 31 + xor;
        hash = hash * 31 + sum;
        hash = hash * 31 + mul;
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashTree)) {
            return false;
        }
        HashTree oo = (HashTree)o;
        if (oo.size() != this.size()) {
            return false;
        }
        for (Map.Entry<Object, HashTree> entry : this.data.entrySet()) {
            HashTree otherValue = oo.data.get(entry.getKey());
            if (entry.getValue().equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Object> keySet() {
        return this.data.keySet();
    }

    public HashTree search(Object key) {
        TreeSearcher searcher;
        block3: {
            HashTree result = this.getTree(key);
            if (result != null) {
                return result;
            }
            searcher = new TreeSearcher(key);
            try {
                this.traverse(searcher);
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals(FOUND)) break block3;
                throw e;
            }
        }
        return searcher.getResult();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public void traverse(HashTreeTraverser visitor) {
        for (Object item : this.list()) {
            visitor.addNode(item, this.getTree(item));
            this.getTree(item).traverseInto(visitor);
        }
    }

    private void traverseInto(HashTreeTraverser visitor) {
        if (this.list().isEmpty()) {
            visitor.processPath();
        } else {
            for (Object item : this.list()) {
                HashTree treeItem = this.getTree(item);
                visitor.addNode(item, treeItem);
                treeItem.traverseInto(visitor);
            }
        }
        visitor.subtractNode();
    }

    public String toString() {
        ConvertToString converter = new ConvertToString();
        try {
            this.traverse(converter);
        }
        catch (Exception e) {
            converter.reportError(e);
        }
        return converter.toString();
    }

    private static class ConvertToString
    implements HashTreeTraverser {
        private final StringBuilder string = new StringBuilder(this.getClass().getName() + "{");
        private final StringBuilder spaces = new StringBuilder();
        private int depth = 0;

        private ConvertToString() {
        }

        @Override
        public void addNode(Object key, HashTree subTree) {
            ++this.depth;
            this.string.append("\n").append(this.getSpaces()).append(key);
            this.string.append(" {");
        }

        @Override
        public void subtractNode() {
            this.string.append("\n" + this.getSpaces() + "}");
            --this.depth;
        }

        @Override
        public void processPath() {
        }

        public String toString() {
            this.string.append("\n}");
            return this.string.toString();
        }

        void reportError(Throwable t) {
            this.string.append("Error: ").append(t.toString());
        }

        private String getSpaces() {
            if (this.spaces.length() < this.depth * 2) {
                while (this.spaces.length() < this.depth * 2) {
                    this.spaces.append("  ");
                }
            } else if (this.spaces.length() > this.depth * 2) {
                this.spaces.setLength(this.depth * 2);
            }
            return this.spaces.toString();
        }
    }

    private static class TreeSearcher
    implements HashTreeTraverser {
        private final Object target;
        private HashTree result;

        public TreeSearcher(Object t) {
            this.target = t;
        }

        public HashTree getResult() {
            return this.result;
        }

        @Override
        public void addNode(Object node, HashTree subTree) {
            this.result = subTree.getTree(this.target);
            if (this.result != null) {
                throw new RuntimeException(HashTree.FOUND);
            }
        }

        @Override
        public void processPath() {
        }

        @Override
        public void subtractNode() {
        }
    }
}

