/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.time.interval;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.plot.common.time.TimeUtil;
import jetbrains.datalore.plot.common.time.interval.TimeInterval;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H$J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H$J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/common/time/interval/MeasuredInDays;", "Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "count", "", "(I)V", "addInterval", "Ljetbrains/datalore/base/datetime/DateTime;", "toInstant", "getFirstDayContaining", "Ljetbrains/datalore/base/datetime/Date;", "instant", "range", "", "", "start", "end", "plot-common-portable"})
public abstract class MeasuredInDays
extends TimeInterval {
    protected MeasuredInDays(int count2) {
        super(count2);
    }

    @NotNull
    protected abstract Date getFirstDayContaining(@NotNull DateTime var1);

    @Override
    @NotNull
    public List<Double> range(double start2, double end) {
        if (start2 > end) {
            throw new RuntimeException("Duration must be positive");
        }
        DateTime dateTimeStart = TimeUtil.INSTANCE.asDateTimeUTC(start2);
        Date dateStart = this.getFirstDayContaining(dateTimeStart);
        DateTime dateTimeTick = new DateTime(dateStart, null, 2, null);
        if (dateTimeTick.compareTo(dateTimeStart) < 0) {
            dateTimeTick = this.addInterval(dateTimeTick);
        }
        ArrayList<Double> result2 = new ArrayList<Double>();
        double tick = TimeUtil.INSTANCE.asInstantUTC(dateTimeTick);
        while (tick <= end) {
            result2.add(tick);
            dateTimeTick = this.addInterval(dateTimeTick);
            tick = TimeUtil.INSTANCE.asInstantUTC(dateTimeTick);
        }
        return result2;
    }

    @NotNull
    protected abstract DateTime addInterval(@NotNull DateTime var1);
}

