/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfoQuad;
import jetbrains.datalore.plot.builder.layout.AxisLayoutQuad;
import jetbrains.datalore.plot.builder.layout.GeomMarginsLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.tile.TileLayoutUtil;
import jetbrains.datalore.plot.builder.layout.util.GeomAreaInsets;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/layout/tile/TopDownTileLayout;", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "axisLayoutQuad", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutQuad;", "hDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "vDomain", "marginsLayout", "Ljetbrains/datalore/plot/builder/layout/GeomMarginsLayout;", "(Ljetbrains/datalore/plot/builder/layout/AxisLayoutQuad;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/builder/layout/GeomMarginsLayout;)V", "insideOut", "", "getInsideOut", "()Z", "doLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "Companion", "plot-builder-portable"})
public final class TopDownTileLayout
implements TileLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisLayoutQuad axisLayoutQuad;
    @NotNull
    private final DoubleSpan hDomain;
    @NotNull
    private final DoubleSpan vDomain;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    private final boolean insideOut;

    public TopDownTileLayout(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        this.axisLayoutQuad = axisLayoutQuad;
        this.hDomain = hDomain;
        this.vDomain = vDomain;
        this.marginsLayout = marginsLayout;
    }

    @Override
    public boolean getInsideOut() {
        return this.insideOut;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        GeomAreaInsets geomAreaInsets = TopDownTileLayout.Companion.computeAxisInfos(this.axisLayoutQuad, preferredSize, this.hDomain, this.vDomain, this.marginsLayout, coordProvider);
        DoubleRectangle geomBoundsAfterLayout = TileLayoutUtil.INSTANCE.geomOuterBounds(geomAreaInsets, preferredSize, this.hDomain, this.vDomain, this.marginsLayout, coordProvider);
        AxisLayoutInfoQuad axisInfos = geomAreaInsets.getAxisInfoQuad();
        AxisLayoutInfo l = axisInfos.component1();
        AxisLayoutInfo r = axisInfos.component2();
        AxisLayoutInfo t = axisInfos.component3();
        AxisLayoutInfo b2 = axisInfos.component4();
        Object object = new AxisLayoutInfo[]{l, r, t, b2};
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AxisLayoutInfo axisLayoutInfo = (AxisLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.axisBoundsAbsolute(geomBoundsAfterLayout));
        }
        List axisBounds = (List)destination$iv$iv;
        Iterable $this$fold$iv = axisBounds;
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = geomBoundsAfterLayout;
        for (Object element$iv : $this$fold$iv) {
            void e;
            Object item$iv$iv;
            item$iv$iv = (DoubleRectangle)element$iv;
            DoubleRectangle a2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = a2.union((DoubleRectangle)e);
        }
        DoubleRectangle geomWithAxisBounds = accumulator$iv;
        DoubleRectangle geomInnerBounds = this.marginsLayout.toInnerBounds(geomBoundsAfterLayout);
        AxisLayoutInfoQuad axisInfosNew = axisInfos.withHAxisLength(geomInnerBounds.getWidth()).withVAxisLength(geomInnerBounds.getHeight());
        return new TileLayoutInfo(DoubleVector.Companion.getZERO(), geomWithAxisBounds, geomBoundsAfterLayout, geomInnerBounds, axisInfosNew, true, true, null, null, 0, 384, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/layout/tile/TopDownTileLayout$Companion;", "", "()V", "computeAxisInfos", "Ljetbrains/datalore/plot/builder/layout/util/GeomAreaInsets;", "axisLayoutQuad", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutQuad;", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "hDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "vDomain", "marginsLayout", "Ljetbrains/datalore/plot/builder/layout/GeomMarginsLayout;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final GeomAreaInsets computeAxisInfos(AxisLayoutQuad axisLayoutQuad, DoubleVector plotSize2, DoubleSpan hDomain, DoubleSpan vDomain, GeomMarginsLayout marginsLayout, CoordProvider coordProvider) {
            GeomAreaInsets geomAreaInsets;
            DoubleRectangle plottingArea;
            double hAxisLength;
            GeomAreaInsets insetsInitial = GeomAreaInsets.Companion.init(axisLayoutQuad);
            DoubleVector it = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsInitial, plotSize2, hDomain, vDomain, marginsLayout, coordProvider).getDimension();
            boolean bl = false;
            double geomHeightEstim = marginsLayout.toInnerSize(it).getY();
            GeomAreaInsets insetsVAxis = insetsInitial.layoutVAxis(vDomain, geomHeightEstim);
            GeomAreaInsets insetsHVAxis = insetsVAxis.layoutHAxis(hDomain, hAxisLength = marginsLayout.toInnerBounds(plottingArea = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsVAxis, plotSize2, hDomain, vDomain, marginsLayout, coordProvider)).getWidth());
            if (insetsHVAxis.getTop() + insetsHVAxis.getBottom() > insetsInitial.getTop() + insetsInitial.getBottom()) {
                DoubleVector it2 = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsHVAxis, plotSize2, hDomain, vDomain, marginsLayout, coordProvider).getDimension();
                boolean bl2 = false;
                double geomHeight = marginsLayout.toInnerSize(it2).getY();
                geomAreaInsets = insetsHVAxis.layoutVAxis(vDomain, geomHeight);
            } else {
                geomAreaInsets = insetsHVAxis;
            }
            GeomAreaInsets insetsFinal = geomAreaInsets;
            return insetsFinal;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

