/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.render.svg.MultilineLabel;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentLayout;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JN\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponent;", "Ljetbrains/datalore/plot/builder/guide/LegendBox;", "spec", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "(Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;)V", "getSpec", "()Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "addColorBar", "", "g", "Ljetbrains/datalore/vis/svg/SvgGElement;", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "mapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "Ljetbrains/datalore/base/values/Color;", "numBins", "", "barBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barLengthExpand", "", "horizontal", "", "reverse", "addTickMark", "p0", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p1", "appendGuideContent", "contentRoot", "Ljetbrains/datalore/vis/svg/SvgNode;", "plot-builder-portable"})
public final class ColorBarComponent
extends LegendBox {
    @NotNull
    private final ColorBarComponentSpec spec;

    public ColorBarComponent(@NotNull ColorBarComponentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
    }

    @Override
    @NotNull
    public ColorBarComponentSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        ColorBarComponentLayout layout = this.getSpec().getLayout();
        SvgGElement guideBarGroup = new SvgGElement();
        DoubleRectangle barBounds = layout.getBarBounds();
        boolean horizontal = layout.isHorizontal();
        this.addColorBar(guideBarGroup, this.getSpec().getDomain(), this.getSpec().getScaleMapper(), this.getSpec().getBinCount(), barBounds, layout.getBarLengthExpand(), horizontal, this.getSpec().getReverse());
        double barThickness = horizontal ? barBounds.getHeight() : barBounds.getWidth();
        double tickLength = barThickness / (double)5;
        Iterator<ColorBarComponentLayout.BreakInfo> breakInfos = layout.getBreakInfos$plot_builder_portable().iterator();
        for (String brLabel : this.getSpec().getBreaks().getLabels()) {
            double d;
            ColorBarComponentLayout.BreakInfo brInfo = breakInfos.next();
            double tickLocation = brInfo.getTickLocation();
            ArrayList<DoubleVector> tickMarkPoints = new ArrayList<DoubleVector>();
            if (horizontal) {
                double tickX = barBounds.getLeft() + tickLocation;
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop()));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop() + tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom() - tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom()));
            } else {
                double tickY = barBounds.getTop() + tickLocation;
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft(), tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft() + tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight() - tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight(), tickY));
            }
            Object e = tickMarkPoints.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"tickMarkPoints[0]");
            DoubleVector doubleVector = (DoubleVector)e;
            Object e2 = tickMarkPoints.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"tickMarkPoints[1]");
            this.addTickMark(guideBarGroup, doubleVector, (DoubleVector)e2);
            Object e3 = tickMarkPoints.get(2);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"tickMarkPoints[2]");
            DoubleVector doubleVector2 = (DoubleVector)e3;
            Object e4 = tickMarkPoints.get(3);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"tickMarkPoints[3]");
            this.addTickMark(guideBarGroup, doubleVector2, (DoubleVector)e4);
            double lineHeight = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height();
            MultilineLabel label = new MultilineLabel(brLabel);
            label.addClassName("legend-item");
            label.setHorizontalAnchor(brInfo.getLabelHorizontalAnchor());
            label.setLineHeight(lineHeight);
            switch (WhenMappings.$EnumSwitchMapping$0[brInfo.getLabelVerticalAnchor().ordinal()]) {
                case 1: {
                    d = lineHeight * 0.7;
                    break;
                }
                case 2: {
                    d = -ColorBarComponent.appendGuideContent$labelSize(brLabel, this).getY() + lineHeight;
                    break;
                }
                case 3: {
                    d = -ColorBarComponent.appendGuideContent$labelSize(brLabel, this).getY() / (double)2 + lineHeight * 0.85;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double yOffset2 = d;
            label.moveTo(brInfo.getLabelLocation().getX(), brInfo.getLabelLocation().getY() + barBounds.getTop() + yOffset2);
            guideBarGroup.children().add(label.getRootGroup());
        }
        if (this.getDebug()) {
            DoubleRectangle graphBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), layout.getGraphSize());
            guideBarGroup.children().add(LegendBox.Companion.createTransparentRect(graphBounds, Color.Companion.getDARK_BLUE(), 1.0));
        }
        contentRoot.children().add(guideBarGroup);
        return layout.getSize();
    }

    /*
     * WARNING - void declaration
     */
    private final void addColorBar(SvgGElement g, DoubleSpan domain, ScaleMapper<Color> mapper, int numBins, DoubleRectangle barBounds, double barLengthExpand, boolean horizontal, boolean reverse) {
        void $this$mapTo$iv$iv;
        double domainSpan = domain.getLength();
        int stepCount = Math.max(2, numBins);
        double step = domainSpan / (double)stepCount;
        double v = domain.getLowerEnd() + step / (double)2;
        ArrayList<Double> domainValues = new ArrayList<Double>();
        for (int i = 0; i < stepCount; ++i) {
            domainValues.add(v + step * (double)i);
        }
        if (reverse) {
            CollectionsKt.reverse((List)domainValues);
        }
        Iterable $this$map$iv = domainValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mapper.invoke((double)it));
        }
        List colors = (List)destination$iv$iv;
        double barLength = horizontal ? barBounds.getWidth() : barBounds.getHeight();
        double effectiveBarLength = barLength - barLengthExpand * (double)2;
        double segmentStep = effectiveBarLength / (double)stepCount;
        double segmentLeft = barBounds.getLeft();
        double segmentRight = barBounds.getRight();
        double segmentBottom = barBounds.getBottom();
        double segmentTop = barBounds.getTop();
        Iterator iterator2 = colors.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Color color = (Color)iterator2.next();
            SvgRectElement r = new SvgRectElement(segmentLeft, segmentTop, segmentRight - segmentLeft, segmentBottom - segmentTop);
            r.strokeWidth().set(0.0);
            r.fillColor().set(color);
            g.children().add(r);
            if (horizontal) {
                segmentLeft += segmentStep;
            } else {
                segmentTop += segmentStep;
            }
            if (i != 0) continue;
            if (horizontal) {
                segmentLeft += barLengthExpand;
                continue;
            }
            segmentTop += barLengthExpand;
        }
    }

    private final void addTickMark(SvgGElement g, DoubleVector p0, DoubleVector p1) {
        SvgLineElement line2 = new SvgLineElement(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        line2.strokeWidth().set(1.0);
        line2.strokeColor().set(this.getTheme().backgroundFill());
        g.children().add(line2);
    }

    private static final DoubleVector appendGuideContent$labelSize(String brLabel, ColorBarComponent this$0) {
        return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(brLabel, PlotLabelSpecFactory.INSTANCE.legendItem(this$0.getTheme()));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

