/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.event.Event;
import jetbrains.datalore.base.gcommon.base.Throwables;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.PlotContext;
import jetbrains.datalore.plot.base.render.svg.MultilineLabel;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.FrameOfReference;
import jetbrains.datalore.plot.builder.FrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.MarginSide;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.PlotTile;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.interact.PlotInteractor;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayout;
import jetbrains.datalore.plot.builder.layout.LegendsBlockInfo;
import jetbrains.datalore.plot.builder.layout.Margins;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TextJustification;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.builder.presentation.LabelSpec;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.builder.theme.PlotTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import jetbrains.datalore.plot.builder.tooltip.VerticalAxisTooltipPosition;
import jetbrains.datalore.vis.StyleSheet;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.event.SvgEventHandler;
import jetbrains.datalore.vis.svg.event.SvgEventSpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 e2\u00020\u0001:\u0001eB\u0089\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018JH\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0003H\u0002J>\u0010K\u001a\u00020=2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010L\u001a\u00020B2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010J\u001a\u00020\u0003H\u0002J\b\u0010O\u001a\u00020=H\u0014J\b\u0010P\u001a\u00020=H\u0002J\b\u0010Q\u001a\u00020=H\u0002J\b\u0010R\u001a\u00020=H\u0016J8\u0010S\u001a\u00020B2\u0006\u0010T\u001a\u00020B2\b\b\u0002\u0010U\u001a\u00020V2\b\b\u0002\u0010W\u001a\u00020V2\b\b\u0002\u0010X\u001a\u00020V2\b\b\u0002\u0010Y\u001a\u00020VH\u0002J$\u0010Z\u001a\u00020=2\u0006\u0010[\u001a\u00020B2\u0006\u0010\\\u001a\u00020]2\n\b\u0002\u0010^\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010_\u001a\u00020=2\u0006\u0010`\u001a\u00020a2\u0006\u0010^\u001a\u00020\u0003H\u0002J4\u0010b\u001a\u00020B2\u0006\u0010>\u001a\u00020\u00032\u0006\u0010L\u001a\u00020B2\u0006\u0010D\u001a\u00020E2\b\b\u0002\u0010?\u001a\u00020@2\b\b\u0002\u0010c\u001a\u00020dH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR(\u0010&\u001a\u0004\u0018\u00010%2\b\u0010$\u001a\u0004\u0018\u00010%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "title", "", "subtitle", "caption", "coreLayersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "marginalLayersByTile", "figureLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "frameProviderByTile", "Ljetbrains/datalore/plot/builder/FrameOfReferenceProvider;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "interactionsEnabled", "", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "styleSheet", "Ljetbrains/datalore/vis/StyleSheet;", "plotContext", "Ljetbrains/datalore/plot/base/PlotContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljetbrains/datalore/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;Ljava/util/List;Ljetbrains/datalore/plot/builder/coord/CoordProvider;ZLjetbrains/datalore/plot/builder/theme/Theme;Ljetbrains/datalore/vis/StyleSheet;Ljetbrains/datalore/plot/base/PlotContext;)V", "containsLiveMap", "getContainsLiveMap", "()Z", "figureSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getFigureSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "flippedAxis", "getFlippedAxis", "hAxisTitle", "getInteractionsEnabled", "value", "Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "interactor", "getInteractor", "()Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "setInteractor", "(Ljetbrains/datalore/plot/builder/interact/PlotInteractor;)V", "isDisposed", "<set-?>", "Ljetbrains/datalore/base/values/SomeFig;", "liveMapFigures", "getLiveMapFigures$plot_builder_portable", "()Ljava/util/List;", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "getMouseEventPeer", "()Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "getPlotContext", "()Ljetbrains/datalore/plot/base/PlotContext;", "getStyleSheet", "()Ljetbrains/datalore/vis/StyleSheet;", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/Theme;", "vAxisTitle", "addAxisTitle", "", "text", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "overallTileBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "overallGeomBounds", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/LabelSpec;", "justification", "Ljetbrains/datalore/plot/builder/layout/TextJustification;", "margins", "Ljetbrains/datalore/plot/builder/layout/Margins;", "className", "addTitle", "boundRect", "rotation", "Ljetbrains/datalore/plot/builder/layout/TextJustification$Companion$TextRotation;", "buildComponent", "buildPlot", "buildPlotComponents", "clear", "createTextRectangle", "elementRect", "topMargin", "", "rightMargin", "bottomMargin", "leftMargin", "drawDebugRect", "r", "color", "Ljetbrains/datalore/base/values/Color;", "message", "onMouseMove", "e", "Ljetbrains/datalore/vis/svg/SvgElement;", "textBoundingBox", "align", "", "Companion", "plot-builder-portable"})
public final class PlotSvgComponent
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String title;
    @Nullable
    private final String subtitle;
    @Nullable
    private final String caption;
    @NotNull
    private final List<List<GeomLayer>> coreLayersByTile;
    @NotNull
    private final List<List<GeomLayer>> marginalLayersByTile;
    @NotNull
    private final PlotFigureLayoutInfo figureLayoutInfo;
    @NotNull
    private final List<FrameOfReferenceProvider> frameProviderByTile;
    @NotNull
    private final CoordProvider coordProvider;
    private final boolean interactionsEnabled;
    @NotNull
    private final Theme theme;
    @NotNull
    private final StyleSheet styleSheet;
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final DoubleVector figureSize;
    private final boolean flippedAxis;
    @NotNull
    private final MouseEventPeer mouseEventPeer;
    @Nullable
    private PlotInteractor interactor;
    @NotNull
    private List<? extends SomeFig> liveMapFigures;
    private final boolean containsLiveMap;
    @Nullable
    private final String hAxisTitle;
    @Nullable
    private final String vAxisTitle;
    private boolean isDisposed;
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotSvgComponent.class));
    private static final boolean DEBUG_DRAWING = false;

    /*
     * WARNING - void declaration
     */
    public PlotSvgComponent(@Nullable String title, @Nullable String subtitle, @Nullable String caption, @NotNull List<? extends List<? extends GeomLayer>> coreLayersByTile, @NotNull List<? extends List<? extends GeomLayer>> marginalLayersByTile, @NotNull PlotFigureLayoutInfo figureLayoutInfo, @NotNull List<? extends FrameOfReferenceProvider> frameProviderByTile, @NotNull CoordProvider coordProvider, boolean interactionsEnabled, @NotNull Theme theme, @NotNull StyleSheet styleSheet, @NotNull PlotContext plotContext) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(coreLayersByTile, (String)"coreLayersByTile");
            Intrinsics.checkNotNullParameter(marginalLayersByTile, (String)"marginalLayersByTile");
            Intrinsics.checkNotNullParameter((Object)figureLayoutInfo, (String)"figureLayoutInfo");
            Intrinsics.checkNotNullParameter(frameProviderByTile, (String)"frameProviderByTile");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
            Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
            this.title = title;
            this.subtitle = subtitle;
            this.caption = caption;
            this.coreLayersByTile = coreLayersByTile;
            this.marginalLayersByTile = marginalLayersByTile;
            this.figureLayoutInfo = figureLayoutInfo;
            this.frameProviderByTile = frameProviderByTile;
            this.coordProvider = coordProvider;
            this.interactionsEnabled = interactionsEnabled;
            this.theme = theme;
            this.styleSheet = styleSheet;
            this.plotContext = plotContext;
            this.figureSize = this.figureLayoutInfo.getFigureSize();
            this.flippedAxis = this.frameProviderByTile.get(0).getFlipAxis();
            this.mouseEventPeer = new MouseEventPeer();
            this.liveMapFigures = CollectionsKt.emptyList();
            Iterable iterable = CollectionsKt.flatten((Iterable)this.coreLayersByTile);
            PlotSvgComponent plotSvgComponent = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomLayer p0 = (GeomLayer)element$iv;
                    boolean bl3 = false;
                    if (!p0.isLiveMap()) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        plotSvgComponent.containsLiveMap = bl = bl2;
        this.hAxisTitle = this.frameProviderByTile.get(0).getHAxisLabel();
        this.vAxisTitle = this.frameProviderByTile.get(0).getVAxisLabel();
    }

    public final boolean getInteractionsEnabled() {
        return this.interactionsEnabled;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @NotNull
    public final StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @NotNull
    public final PlotContext getPlotContext() {
        return this.plotContext;
    }

    @NotNull
    public final DoubleVector getFigureSize() {
        return this.figureSize;
    }

    public final boolean getFlippedAxis() {
        return this.flippedAxis;
    }

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.mouseEventPeer;
    }

    @Nullable
    public final PlotInteractor getInteractor() {
        return this.interactor;
    }

    public final void setInteractor(@Nullable PlotInteractor value) {
        if (!(this.interactor == null)) {
            boolean $i$a$-check-PlotSvgComponent$interactor$32 = false;
            String $i$a$-check-PlotSvgComponent$interactor$32 = "interactor can be initialize only once.";
            throw new IllegalStateException($i$a$-check-PlotSvgComponent$interactor$32.toString());
        }
        if (!(!this.isBuilt())) {
            boolean bl = false;
            String string = "Can't change interactor after plot has already been built.";
            throw new IllegalStateException(string.toString());
        }
        this.interactor = value;
    }

    @NotNull
    public final List<SomeFig> getLiveMapFigures$plot_builder_portable() {
        return this.liveMapFigures;
    }

    public final boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @Override
    public void clear() {
        this.isDisposed = true;
        super.clear();
    }

    @Override
    protected void buildComponent() {
        if (!(!this.isDisposed)) {
            boolean $i$a$-check-PlotSvgComponent$buildComponent$22 = false;
            String $i$a$-check-PlotSvgComponent$buildComponent$22 = "Plot can't be rebuild after it was disposed.";
            throw new IllegalStateException($i$a$-check-PlotSvgComponent$buildComponent$22.toString());
        }
        try {
            this.buildPlot();
        }
        catch (RuntimeException e) {
            LOG.error(e, (Function0<String>)((Function0)buildComponent.2.INSTANCE));
            Throwable rootCause = Throwables.INSTANCE.getRootCause(e);
            String[] stringArray = new String[]{"Error building plot: " + Reflection.getOrCreateKotlinClass(rootCause.getClass()).getSimpleName(), rootCause.getMessage() != null ? '\'' + rootCause.getMessage() + '\'' : "<no message>"};
            String[] messages = stringArray;
            double y2 = this.figureSize.getY() / (double)2 - (double)8;
            for (String s2 : messages) {
                TextLabel errorLabel = new TextLabel(s2);
                Color textColor2 = this.theme.plot().showBackground() ? this.theme.plot().textColor() : Defaults.INSTANCE.getTEXT_COLOR();
                errorLabel.textColor().set(textColor2);
                errorLabel.setFontWeight("normal");
                errorLabel.setFontStyle("normal");
                errorLabel.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
                errorLabel.setVerticalAnchor(Text.VerticalAnchor.CENTER);
                errorLabel.moveTo(this.figureSize.getX() / (double)2, y2);
                this.getRootGroup().children().add(errorLabel.getRootGroup());
                y2 += 16.0;
            }
        }
    }

    private final void buildPlot() {
        this.buildPlotComponents();
        this.reg(new Registration(this){
            final /* synthetic */ PlotSvgComponent this$0;
            {
                this.this$0 = $receiver;
            }

            protected void doRemove() {
                PlotInteractor plotInteractor = this.this$0.getInteractor();
                if (plotInteractor != null) {
                    plotInteractor.dispose();
                }
                PlotSvgComponent.access$setLiveMapFigures$p(this.this$0, CollectionsKt.emptyList());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPlotComponents() {
        block23: {
            DoubleRectangle doubleRectangle;
            DoubleRectangle captionElementRect;
            DoubleRectangle doubleRectangle2;
            Object it;
            DoubleRectangle doubleRectangle3;
            DoubleRectangle subtitleElementRect;
            DoubleRectangle doubleRectangle4;
            Object it2;
            DoubleRectangle doubleRectangle5;
            DoubleRectangle plotTitleElementRect;
            DoubleRectangle doubleRectangle6;
            Object it3;
            DoubleVector plotAreaOrigin;
            DoubleRectangle overallRect = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.figureSize);
            PlotTheme plotTheme = this.theme.plot();
            if (plotTheme.showBackground()) {
                void $this$buildPlotComponents_u24lambda_u243;
                SvgRectElement svgRectElement;
                SvgRectElement svgRectElement2 = svgRectElement = new SvgRectElement(overallRect);
                PlotSvgComponent plotSvgComponent = this;
                boolean bl = false;
                $this$buildPlotComponents_u24lambda_u243.strokeColor().set(plotTheme.backgroundColor());
                $this$buildPlotComponents_u24lambda_u243.strokeWidth().set(plotTheme.backgroundStrokeWidth());
                $this$buildPlotComponents_u24lambda_u243.fillColor().set(plotTheme.backgroundFill());
                if (this.containsLiveMap) {
                    $this$buildPlotComponents_u24lambda_u243.fillOpacity().set(0.0);
                }
                plotSvgComponent.add(svgRectElement);
            }
            boolean axisEnabled = !this.containsLiveMap;
            PlotLayoutInfo layoutInfo = this.figureLayoutInfo.getPlotLayoutInfo();
            DoubleRectangle plotOuterBounds = this.figureLayoutInfo.getFigureLayoutedBounds();
            DoubleRectangle plotOuterBoundsWithoutTitleAndCaption = this.figureLayoutInfo.getFigureBoundsWithoutTitleAndCaption();
            DoubleVector tilesOrigin = plotAreaOrigin = this.figureLayoutInfo.getPlotAreaOrigin();
            for (TileLayoutInfo tileLayoutInfo : layoutInfo.getTiles()) {
                int tileIndex = tileLayoutInfo.getTrueIndex();
                FrameOfReferenceProvider tileFrameProvider = this.frameProviderByTile.get(tileIndex);
                FrameOfReference tileFrame = tileFrameProvider.createTileFrame(tileLayoutInfo, this.coordProvider, false);
                Map<MarginSide, FrameOfReference> marginalFrameByMargin = tileFrameProvider.createMarginalFrames(tileLayoutInfo, this.coordProvider, false);
                PlotTile tile2 = new PlotTile(this.coreLayersByTile.get(tileIndex), this.marginalLayersByTile.get(tileIndex), tilesOrigin, tileLayoutInfo, this.theme, tileFrame, marginalFrameByMargin);
                DoubleVector plotOriginAbsolute = tilesOrigin.add(tileLayoutInfo.getOffset());
                tile2.moveTo(plotOriginAbsolute);
                this.add(tile2);
                if (tile2.getLiveMapFigure() != null) {
                    SomeFig $this$buildPlotComponents_u24lambda_u244;
                    boolean bl = false;
                    this.liveMapFigures = CollectionsKt.plus((Collection)this.liveMapFigures, (Iterable)CollectionsKt.listOf((Object)$this$buildPlotComponents_u24lambda_u244));
                }
                DoubleRectangle geomOuterBoundsAbsolute = tileLayoutInfo.getGeomOuterBounds().add(plotOriginAbsolute);
                DoubleRectangle geomInnerBoundsAbsolute = tileLayoutInfo.getGeomInnerBounds().add(plotOriginAbsolute);
                DoubleVector axisOrigin = new DoubleVector(layoutInfo.getHasLeftAxis() ? geomOuterBoundsAbsolute.getLeft() : geomOuterBoundsAbsolute.getRight(), layoutInfo.getHasBottomAxis() ? geomOuterBoundsAbsolute.getBottom() : geomOuterBoundsAbsolute.getTop());
                PlotInteractor plotInteractor = this.interactor;
                if (plotInteractor == null) continue;
                plotInteractor.onTileAdded(geomInnerBoundsAbsolute, tile2.getTargetLocators(), tile2.getLayerYOrientations(), axisOrigin, layoutInfo.getHasBottomAxis() ? HorizontalAxisTooltipPosition.BOTTOM : HorizontalAxisTooltipPosition.TOP, layoutInfo.getHasLeftAxis() ? VerticalAxisTooltipPosition.LEFT : VerticalAxisTooltipPosition.RIGHT);
            }
            DoubleRectangle geomAreaBounds = this.figureLayoutInfo.getGeomAreaBounds();
            String string = this.title;
            if (string != null) {
                it3 = string;
                boolean bl = false;
                doubleRectangle6 = new DoubleRectangle(geomAreaBounds.getLeft(), plotOuterBounds.getTop(), geomAreaBounds.getWidth(), PlotLayoutUtil.INSTANCE.titleThickness$plot_builder_portable(this.title, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), this.theme.plot().titleMargins()));
            } else {
                doubleRectangle6 = null;
            }
            DoubleRectangle doubleRectangle7 = plotTitleElementRect = doubleRectangle6;
            if (doubleRectangle7 != null) {
                it3 = doubleRectangle7;
                boolean bl = false;
                doubleRectangle5 = PlotSvgComponent.buildPlotComponents$textRectangle(this, (DoubleRectangle)it3, this.theme.plot().titleMargins());
            } else {
                doubleRectangle5 = null;
            }
            DoubleRectangle plotTitleTextRect = doubleRectangle5;
            String string2 = this.subtitle;
            if (string2 != null) {
                it2 = string2;
                boolean bl = false;
                DoubleRectangle doubleRectangle8 = plotTitleElementRect;
                doubleRectangle4 = new DoubleRectangle(geomAreaBounds.getLeft(), doubleRectangle8 != null ? doubleRectangle8.getBottom() : plotOuterBounds.getTop(), geomAreaBounds.getWidth(), PlotLayoutUtil.INSTANCE.titleThickness$plot_builder_portable(this.subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), this.theme.plot().subtitleMargins()));
            } else {
                doubleRectangle4 = null;
            }
            DoubleRectangle doubleRectangle9 = subtitleElementRect = doubleRectangle4;
            if (doubleRectangle9 != null) {
                it2 = doubleRectangle9;
                boolean bl = false;
                doubleRectangle3 = PlotSvgComponent.buildPlotComponents$textRectangle(this, (DoubleRectangle)it2, this.theme.plot().subtitleMargins());
            } else {
                doubleRectangle3 = null;
            }
            DoubleRectangle subtitleTextRect = doubleRectangle3;
            String string3 = this.caption;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                double captionRectHeight = PlotLayoutUtil.INSTANCE.titleThickness$plot_builder_portable(this.caption, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), this.theme.plot().captionMargins());
                doubleRectangle2 = new DoubleRectangle(geomAreaBounds.getLeft(), plotOuterBounds.getBottom() - captionRectHeight, geomAreaBounds.getWidth(), captionRectHeight);
            } else {
                doubleRectangle2 = null;
            }
            DoubleRectangle doubleRectangle10 = captionElementRect = doubleRectangle2;
            if (doubleRectangle10 != null) {
                it = doubleRectangle10;
                boolean bl = false;
                doubleRectangle = PlotSvgComponent.buildPlotComponents$textRectangle(this, (DoubleRectangle)it, this.theme.plot().captionMargins());
            } else {
                doubleRectangle = null;
            }
            DoubleRectangle captionTextRect = doubleRectangle;
            DoubleRectangle doubleRectangle11 = plotTitleTextRect;
            if (doubleRectangle11 != null) {
                it = doubleRectangle11;
                boolean bl = false;
                PlotSvgComponent.addTitle$default(this, this.title, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), plotTheme.titleJustification(), (DoubleRectangle)it, null, "plot-title", 16, null);
            }
            DoubleRectangle doubleRectangle12 = subtitleTextRect;
            if (doubleRectangle12 != null) {
                it = doubleRectangle12;
                boolean bl = false;
                PlotSvgComponent.addTitle$default(this, this.subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), plotTheme.subtitleJustification(), (DoubleRectangle)it, null, "plot-subtitle", 16, null);
            }
            DoubleRectangle overallTileBounds = PlotLayoutUtil.INSTANCE.overallTileBounds(layoutInfo).add(plotAreaOrigin);
            if (axisEnabled) {
                Orientation titleOrientation;
                if (this.vAxisTitle != null) {
                    titleOrientation = ((TileLayoutInfo)CollectionsKt.first(layoutInfo.getTiles())).getAxisInfos().getVAxisTitleOrientation();
                    this.addAxisTitle(this.vAxisTitle, titleOrientation, overallTileBounds, geomAreaBounds, PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.verticalAxis(this.flippedAxis)), this.theme.verticalAxis(this.flippedAxis).titleJustification(), this.theme.verticalAxis(this.flippedAxis).titleMargins(), "axis-title-" + this.theme.verticalAxis(this.flippedAxis).getAxis());
                }
                if (this.hAxisTitle != null) {
                    titleOrientation = ((TileLayoutInfo)CollectionsKt.first(layoutInfo.getTiles())).getAxisInfos().getHAxisTitleOrientation();
                    this.addAxisTitle(this.hAxisTitle, titleOrientation, overallTileBounds, geomAreaBounds, PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.horizontalAxis(this.flippedAxis)), this.theme.horizontalAxis(this.flippedAxis).titleJustification(), this.theme.horizontalAxis(this.flippedAxis).titleMargins(), "axis-title-" + this.theme.horizontalAxis(this.flippedAxis).getAxis());
                }
            }
            LegendTheme legendTheme = this.theme.legend();
            LegendsBlockInfo legendsBlockInfo = this.figureLayoutInfo.getLegendsBlockInfo();
            if (!legendTheme.position().isHidden()) {
                LegendsBlockInfo legendsBlockInfoLayouted = new LegendBoxesLayout(plotOuterBoundsWithoutTitleAndCaption, geomAreaBounds, legendTheme).doLayout(legendsBlockInfo);
                for (LegendBoxesLayout.BoxWithLocation boxWithLocation : legendsBlockInfoLayouted.getBoxWithLocationList()) {
                    LegendBox legendBox = boxWithLocation.getLegendBox().createLegendBox();
                    legendBox.moveTo(boxWithLocation.getLocation());
                    this.add(legendBox);
                }
            }
            DoubleRectangle doubleRectangle13 = captionTextRect;
            if (doubleRectangle13 == null) break block23;
            DoubleRectangle it4 = doubleRectangle13;
            boolean bl = false;
            PlotSvgComponent.addTitle$default(this, this.caption, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), plotTheme.captionJustification(), it4, null, "plot-caption", 16, null);
        }
    }

    private final DoubleRectangle createTextRectangle(DoubleRectangle elementRect, double topMargin, double rightMargin, double bottomMargin, double leftMargin) {
        return new DoubleRectangle(elementRect.getLeft() + leftMargin, elementRect.getTop() + topMargin, elementRect.getWidth() - (rightMargin + leftMargin), elementRect.getHeight() - (topMargin + bottomMargin));
    }

    static /* synthetic */ DoubleRectangle createTextRectangle$default(PlotSvgComponent plotSvgComponent, DoubleRectangle doubleRectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d4 = 0.0;
        }
        return plotSvgComponent.createTextRectangle(doubleRectangle, d, d2, d3, d4);
    }

    private final void addAxisTitle(String text, Orientation orientation, DoubleRectangle overallTileBounds, DoubleRectangle overallGeomBounds, LabelSpec labelSpec, TextJustification justification, Margins margins, String className) {
        DoubleRectangle doubleRectangle;
        TextJustification.Companion.TextRotation textRotation;
        DoubleRectangle doubleRectangle2;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: 
            case 2: {
                doubleRectangle2 = new DoubleRectangle(overallTileBounds.getLeft(), overallGeomBounds.getTop(), overallTileBounds.getWidth(), overallGeomBounds.getHeight());
                break;
            }
            case 3: 
            case 4: {
                doubleRectangle2 = new DoubleRectangle(overallGeomBounds.getLeft(), overallTileBounds.getTop(), overallGeomBounds.getWidth(), overallTileBounds.getHeight());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle referenceRect = doubleRectangle2;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                textRotation = TextJustification.Companion.TextRotation.ANTICLOCKWISE;
                break;
            }
            case 2: {
                textRotation = TextJustification.Companion.TextRotation.ANTICLOCKWISE;
                break;
            }
            default: {
                textRotation = null;
            }
        }
        TextJustification.Companion.TextRotation rotation = textRotation;
        double textHeight = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(text, labelSpec).getY();
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft() - textHeight - margins.width(), referenceRect.getTop(), textHeight + margins.width(), referenceRect.getHeight());
                break;
            }
            case 2: {
                doubleRectangle = new DoubleRectangle(referenceRect.getRight(), referenceRect.getTop(), textHeight + margins.width(), referenceRect.getHeight());
                break;
            }
            case 3: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft(), referenceRect.getTop() - textHeight - margins.height(), referenceRect.getWidth(), textHeight + margins.height());
                break;
            }
            case 4: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft(), referenceRect.getBottom(), referenceRect.getWidth(), textHeight + margins.height());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle axisTitleElementRect = doubleRectangle;
        DoubleRectangle axisTitleTextRect = orientation.isHorizontal() ? PlotSvgComponent.createTextRectangle$default(this, axisTitleElementRect, margins.getTop(), 0.0, margins.getBottom(), 0.0, 20, null) : PlotSvgComponent.createTextRectangle$default(this, axisTitleElementRect, 0.0, margins.getRight(), 0.0, margins.getLeft(), 10, null);
        this.addTitle(text, labelSpec, justification, axisTitleTextRect, rotation, className);
    }

    private final DoubleRectangle textBoundingBox(String text, DoubleRectangle boundRect, LabelSpec labelSpec, Orientation orientation, int align) {
        DoubleRectangle doubleRectangle;
        DoubleVector d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(text, labelSpec);
        Orientation[] orientationArray = new Orientation[]{Orientation.TOP, Orientation.BOTTOM};
        if (CollectionsKt.listOf((Object[])orientationArray).contains((Object)orientation)) {
            double x2 = align > 0 ? boundRect.getRight() - d.getX() : (align < 0 ? boundRect.getLeft() : boundRect.getCenter().getX() - d.getX() / (double)2);
            doubleRectangle = new DoubleRectangle(x2, boundRect.getCenter().getY() - d.getY() / (double)2, d.getX(), d.getY());
        } else {
            double y2 = align > 0 ? boundRect.getBottom() - d.getX() : (align < 0 ? boundRect.getTop() : boundRect.getCenter().getY() - d.getX() / (double)2);
            doubleRectangle = new DoubleRectangle(boundRect.getCenter().getX() - d.getY() / (double)2, y2, d.getY(), d.getX());
        }
        return doubleRectangle;
    }

    static /* synthetic */ DoubleRectangle textBoundingBox$default(PlotSvgComponent plotSvgComponent, String string, DoubleRectangle doubleRectangle, LabelSpec labelSpec, Orientation orientation, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            orientation = Orientation.TOP;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return plotSvgComponent.textBoundingBox(string, doubleRectangle, labelSpec, orientation, n);
    }

    private final void addTitle(String title, LabelSpec labelSpec, TextJustification justification, DoubleRectangle boundRect, TextJustification.Companion.TextRotation rotation, String className) {
        if (title == null) {
            return;
        }
        double lineHeight = labelSpec.height();
        MultilineLabel titleLabel = new MultilineLabel(title);
        titleLabel.addClassName(className);
        Pair<DoubleVector, Text.HorizontalAnchor> pair2 = TextJustification.Companion.applyJustification(boundRect, PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(title, labelSpec), lineHeight, justification, rotation);
        DoubleVector position = (DoubleVector)pair2.component1();
        Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair2.component2());
        titleLabel.setLineHeight(lineHeight);
        titleLabel.setHorizontalAnchor(hAnchor);
        titleLabel.moveTo(position);
        TextJustification.Companion.TextRotation textRotation = rotation;
        if (textRotation != null) {
            double p0 = textRotation.getAngle();
            boolean bl = false;
            titleLabel.rotate(p0);
        }
        this.add(titleLabel);
    }

    static /* synthetic */ void addTitle$default(PlotSvgComponent plotSvgComponent, String string, LabelSpec labelSpec, TextJustification textJustification, DoubleRectangle doubleRectangle, TextJustification.Companion.TextRotation textRotation, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            textRotation = null;
        }
        plotSvgComponent.addTitle(string, labelSpec, textJustification, doubleRectangle, textRotation, string2);
    }

    private final void drawDebugRect(DoubleRectangle r, Color color, String message) {
        SvgRectElement rect2 = new SvgRectElement(r);
        rect2.strokeColor().set(color);
        rect2.strokeWidth().set(1.0);
        rect2.fillOpacity().set(0.0);
        String string = message;
        if (string != null) {
            String $this$drawDebugRect_u24lambda_u2424 = string;
            boolean bl = false;
            this.onMouseMove(rect2, message + ": " + r);
        }
        this.add(rect2);
    }

    static /* synthetic */ void drawDebugRect$default(PlotSvgComponent plotSvgComponent, DoubleRectangle doubleRectangle, Color color, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        plotSvgComponent.drawDebugRect(doubleRectangle, color, string);
    }

    private final void onMouseMove(SvgElement e, String message) {
        e.addEventHandler(SvgEventSpec.MOUSE_MOVE, new SvgEventHandler<Event>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
            }

            public void handle(@NotNull SvgNode node, @NotNull Event e) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                System.out.println((Object)this.$message);
            }
        });
    }

    private static final DoubleRectangle buildPlotComponents$textRectangle(PlotSvgComponent this$0, DoubleRectangle elementRect, Margins margins) {
        return PlotSvgComponent.createTextRectangle$default(this$0, elementRect, margins.getTop(), 0.0, margins.getBottom(), 0.0, 20, null);
    }

    public static final /* synthetic */ void access$setLiveMapFigures$p(PlotSvgComponent $this, List list2) {
        $this.liveMapFigures = list2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/PlotSvgComponent$Companion;", "", "()V", "DEBUG_DRAWING", "", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

