/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.HLineGeom;
import jetbrains.datalore.plot.base.geom.util.ArrowSpec;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgPathElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/base/geom/SegmentGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "arrowSpec", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;)V", "flat", "", "getFlat", "()Z", "setFlat", "(Z)V", "geodesic", "getGeodesic", "setGeodesic", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class SegmentGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrowSpec arrowSpec;
    @Nullable
    private Object animation;
    private boolean flat;
    private boolean geodesic;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    public final boolean getFlat() {
        return this.flat;
    }

    public final void setFlat(boolean bl) {
        this.flat = bl;
    }

    public final boolean getGeodesic() {
        return this.geodesic;
    }

    public final void setGeodesic(boolean bl) {
        this.geodesic = bl;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        GeomHelper.SvgElementHelper helper = new GeomHelper(pos, coord, ctx2).createSvgElementHelper();
        helper.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.SEGMENT, ctx2);
        for (DataPointAesthetics p : aesthetics.dataPoints()) {
            SvgPathElement arrow;
            if (!SeriesUtil.INSTANCE.allFinite(p.x(), p.y(), p.xend(), p.yend())) continue;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = p.y();
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector start2 = new DoubleVector(d2, d3);
            Double d4 = p.xend();
            Intrinsics.checkNotNull((Object)d4);
            double d5 = d4;
            Double d6 = p.yend();
            Intrinsics.checkNotNull((Object)d6);
            DoubleVector end = new DoubleVector(d5, d6);
            SvgLineElement line2 = helper.createLine(start2, end, p);
            if (line2 == null) continue;
            root.add(line2);
            Object[] objectArray = new DoubleVector[2];
            Intrinsics.checkNotNull((Object)coord.toClient(start2));
            Intrinsics.checkNotNull((Object)coord.toClient(end));
            GeomTargetCollector.DefaultImpls.addPath$default(targetCollector, CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Integer, Integer>(p){
                final /* synthetic */ DataPointAesthetics $p;
                {
                    this.$p = $p;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$p.index();
                }
            }, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)p), 7, null), null, 8, null);
            if (this.arrowSpec == null) continue;
            Object ValueT = line2.x1().get();
            Intrinsics.checkNotNull(ValueT);
            double clientX1 = ((Number)ValueT).doubleValue();
            Object ValueT2 = line2.y1().get();
            Intrinsics.checkNotNull(ValueT2);
            double clientY1 = ((Number)ValueT2).doubleValue();
            Object ValueT3 = line2.x2().get();
            Intrinsics.checkNotNull(ValueT3);
            double clientX2 = ((Number)ValueT3).doubleValue();
            Object ValueT4 = line2.y2().get();
            Intrinsics.checkNotNull(ValueT4);
            double clientY2 = ((Number)ValueT4).doubleValue();
            double abscissa = clientX2 - clientX1;
            double ordinate = clientY2 - clientY1;
            if (abscissa == 0.0 && ordinate == 0.0) continue;
            double polarAngle = Math.atan2(ordinate, abscissa);
            ArrowSpec arrowSpec = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec);
            DataPointAesthetics arrowAes = arrowSpec.toArrowAes(p);
            ArrowSpec arrowSpec2 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec2);
            if (arrowSpec2.isOnLastEnd()) {
                ArrowSpec arrowSpec3 = this.arrowSpec;
                Intrinsics.checkNotNull((Object)arrowSpec3);
                arrow = arrowSpec3.createElement(polarAngle, clientX2, clientY2);
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, arrow, arrowAes, true, null, 8, null);
                root.add(arrow);
            }
            ArrowSpec arrowSpec4 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec4);
            if (!arrowSpec4.isOnFirstEnd()) continue;
            ArrowSpec arrowSpec5 = this.arrowSpec;
            Intrinsics.checkNotNull((Object)arrowSpec5);
            arrow = arrowSpec5.createElement(polarAngle + Math.PI, clientX1, clientY1);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, arrow, arrowAes, true, null, 8, null);
            root.add(arrow);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/geom/SegmentGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

