/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.WithHeight;
import jetbrains.datalore.plot.base.geom.WithWidth;
import jetbrains.datalore.plot.base.geom.legend.LollipopLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.NamedShape;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003ABCB\u0005\u00a2\u0006\u0002\u0010\u0004J>\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0$H\u0002J0\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0014J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J0\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020%2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016J0\u0010>\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020%2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010?\u001a\u0004\u0018\u0001042\u0006\u00108\u001a\u00020%2\u0006\u0010@\u001a\u00020=H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010\u00a8\u0006D"}, d2={"Ljetbrains/datalore/plot/base/geom/LollipopGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "Ljetbrains/datalore/plot/base/geom/WithWidth;", "Ljetbrains/datalore/plot/base/geom/WithHeight;", "()V", "direction", "Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;", "getDirection", "()Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;", "setDirection", "(Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;)V", "fatten", "", "getFatten", "()D", "setFatten", "(D)V", "intercept", "getIntercept", "setIntercept", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "slope", "getSlope", "setSlope", "buildHint", "", "lollipop", "Ljetbrains/datalore/plot/base/geom/LollipopGeom$Lollipop;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "colorsByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "", "Ljetbrains/datalore/base/values/Color;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "getBase", "Ljetbrains/datalore/base/geometry/DoubleVector;", "head", "heightSpan", "Ljetbrains/datalore/base/interval/DoubleSpan;", "p", "coordAes", "Ljetbrains/datalore/plot/base/Aes;", "resolution", "isDiscrete", "", "widthSpan", "xyVec", "flip", "Companion", "Direction", "Lollipop", "plot-base-portable"})
public final class LollipopGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fatten = 2.5;
    private double slope;
    private double intercept;
    @NotNull
    private Direction direction = DEF_DIRECTION;
    public static final double DEF_FATTEN = 2.5;
    public static final double DEF_SLOPE = 0.0;
    public static final double DEF_INTERCEPT = 0.0;
    @NotNull
    private static final Direction DEF_DIRECTION = Direction.ORTHOGONAL_TO_AXIS;
    public static final boolean HANDLES_GROUPS = false;

    public final double getFatten() {
        return this.fatten;
    }

    public final void setFatten(double d) {
        this.fatten = d;
    }

    public final double getSlope() {
        return this.slope;
    }

    public final void setSlope(double d) {
        this.slope = d;
    }

    public final double getIntercept() {
        return this.intercept;
    }

    public final void setIntercept(double d) {
        this.intercept = d;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
        this.direction = direction;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new LollipopLegendKeyElementFactory(this.fatten, 0.0, 2, null);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.LOLLIPOP, ctx2);
        List lollipops = new ArrayList();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY())) {
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double x2 = d;
            Double d2 = p.y();
            Intrinsics.checkNotNull((Object)d2);
            double y2 = d2;
            DoubleVector head = new DoubleVector(x2, y2);
            DoubleVector base = this.getBase(head);
            double stickLength = Math.sqrt(Math.pow(head.getX() - base.getX(), 2) + Math.pow(head.getY() - base.getY(), 2));
            lollipops.add(new Lollipop(p, head, base, stickLength));
        }
        Iterable $this$sortedByDescending$iv = lollipops;
        boolean $i$f$sortedByDescending = false;
        for (Lollipop lollipop : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Lollipop it = (Lollipop)b2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getLength());
                it = (Lollipop)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLength()));
            }
        })) {
            SvgLineElement stick = lollipop.createStick(helper);
            if (stick != null) {
                root.add(stick);
            }
            root.add(lollipop.createCandy(helper));
            this.buildHint(lollipop, helper, targetCollector, colorsByDataPoint);
        }
    }

    private final void buildHint(Lollipop lollipop, GeomHelper helper, GeomTargetCollector targetCollector, Function1<? super DataPointAesthetics, ? extends List<Color>> colorsByDataPoint) {
        int n = lollipop.getPoint().index();
        DoubleVector doubleVector = helper.toClient(lollipop.getHead(), lollipop.getPoint());
        Intrinsics.checkNotNull((Object)doubleVector);
        GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, n, doubleVector, lollipop.getCandyRadius(), new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)lollipop.getPoint()), 7, null), null, 16, null);
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        boolean flip = Intrinsics.areEqual(coordAes, Aes.Companion.getY());
        DoubleVector doubleVector = this.xyVec(p, flip);
        if (doubleVector == null) {
            return null;
        }
        DoubleVector head = doubleVector;
        return new DoubleSpan(this.getBase(head).getX(), head.getX());
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        boolean flip = Intrinsics.areEqual(coordAes, Aes.Companion.getX());
        DoubleVector doubleVector = this.xyVec(p, flip);
        if (doubleVector == null) {
            return null;
        }
        DoubleVector head = doubleVector;
        return new DoubleSpan(this.getBase(head).getY(), head.getY());
    }

    private final DoubleVector xyVec(DataPointAesthetics p, boolean flip) {
        Double y2;
        Double d;
        Double d2;
        Double it = d2 = p.x();
        boolean bl = false;
        Double d3 = !flip ? d2 : null;
        if (d3 == null) {
            d3 = p.y();
        }
        Double x2 = d3;
        Double it2 = d = p.y();
        boolean bl2 = false;
        Double d4 = !flip ? d : null;
        if (d4 == null) {
            d4 = p.x();
        }
        if (!SeriesUtil.INSTANCE.allFinite(x2, y2 = d4)) {
            return null;
        }
        Double d5 = x2;
        Intrinsics.checkNotNull((Object)d5);
        double d6 = d5;
        Double d7 = y2;
        Intrinsics.checkNotNull((Object)d7);
        return new DoubleVector(d6, d7);
    }

    private final DoubleVector getBase(DoubleVector head) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(head.getX(), this.slope * head.getX() + this.intercept);
                break;
            }
            case 2: {
                if (this.slope == 0.0) {
                    doubleVector = new DoubleVector(this.intercept, head.getY());
                    break;
                }
                doubleVector = new DoubleVector((head.getY() - this.intercept) / this.slope, head.getY());
                break;
            }
            case 3: {
                double baseX = (head.getX() + this.slope * (head.getY() - this.intercept)) / (1.0 + Math.pow(this.slope, 2));
                double baseY = this.slope * baseX + this.intercept;
                doubleVector = new DoubleVector(baseX, baseY);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/plot/base/geom/LollipopGeom$Lollipop;", "", "point", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "head", "Ljetbrains/datalore/base/geometry/DoubleVector;", "base", "length", "", "(Ljetbrains/datalore/plot/base/geom/LollipopGeom;Ljetbrains/datalore/plot/base/DataPointAesthetics;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;D)V", "getBase", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "candyRadius", "getCandyRadius", "()D", "getHead", "getLength", "getPoint", "()Ljetbrains/datalore/plot/base/DataPointAesthetics;", "createCandy", "Ljetbrains/datalore/vis/svg/SvgGElement;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "createStick", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "shiftHeadToBase", "clientBase", "clientHead", "shiftLength", "plot-base-portable"})
    private final class Lollipop {
        @NotNull
        private final DataPointAesthetics point;
        @NotNull
        private final DoubleVector head;
        @NotNull
        private final DoubleVector base;
        private final double length;

        public Lollipop(@NotNull DataPointAesthetics point2, @NotNull DoubleVector head, DoubleVector base, double length) {
            Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
            Intrinsics.checkNotNullParameter((Object)head, (String)"head");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.point = point2;
            this.head = head;
            this.base = base;
            this.length = length;
        }

        @NotNull
        public final DataPointAesthetics getPoint() {
            return this.point;
        }

        @NotNull
        public final DoubleVector getHead() {
            return this.head;
        }

        @NotNull
        public final DoubleVector getBase() {
            return this.base;
        }

        public final double getLength() {
            return this.length;
        }

        public final double getCandyRadius() {
            PointShape shape;
            PointShape pointShape = this.point.shape();
            Intrinsics.checkNotNull((Object)pointShape);
            PointShape pointShape2 = shape = pointShape;
            double shapeCoeff = ((pointShape2 == NamedShape.STICK_PLUS ? true : pointShape2 == NamedShape.STICK_STAR) ? true : pointShape2 == NamedShape.STICK_CROSS) ? 0.0 : 1.0;
            return (shape.size(this.point, LollipopGeom.this.getFatten()) + shapeCoeff * shape.strokeWidth(this.point)) / 2.0;
        }

        @NotNull
        public final SvgGElement createCandy(@NotNull GeomHelper helper) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            DoubleVector doubleVector = helper.toClient(this.head, this.point);
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector location = doubleVector;
            PointShape pointShape = this.point.shape();
            Intrinsics.checkNotNull((Object)pointShape);
            PointShape shape = pointShape;
            SvgSlimObject o = PointShapeSvg.INSTANCE.create(shape, location, this.point, LollipopGeom.this.getFatten());
            return GeomBase.Companion.wrap(o);
        }

        @Nullable
        public final SvgLineElement createStick(@NotNull GeomHelper helper) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            DoubleVector doubleVector = helper.toClient(this.base, this.point);
            if (doubleVector == null) {
                return null;
            }
            DoubleVector clientBase = doubleVector;
            DoubleVector doubleVector2 = helper.toClient(this.head, this.point);
            if (doubleVector2 == null) {
                return null;
            }
            DoubleVector clientHead = doubleVector2;
            double stickLength = Math.sqrt(Math.pow(clientHead.getX() - clientBase.getX(), 2) + Math.pow(clientHead.getY() - clientBase.getY(), 2));
            if (this.getCandyRadius() > stickLength) {
                return null;
            }
            DoubleVector neck = this.shiftHeadToBase(clientBase, clientHead, this.getCandyRadius());
            SvgLineElement line2 = new SvgLineElement(clientBase.getX(), clientBase.getY(), neck.getX(), neck.getY());
            GeomHelper.Companion.decorate(line2, this.point, true, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).lineWidth(p0);
                }
            }));
            return line2;
        }

        private final DoubleVector shiftHeadToBase(DoubleVector clientBase, DoubleVector clientHead, double shiftLength) {
            double x0 = clientBase.getX();
            double x1 = clientHead.getX();
            double y0 = clientBase.getY();
            double y1 = clientHead.getY();
            if (x0 == x1) {
                double dy = y0 < y1 ? -shiftLength : shiftLength;
                return new DoubleVector(x1, y1 + dy);
            }
            double dx = Math.sqrt(Math.pow(shiftLength, 2) / (1.0 + Math.pow(y0 - y1, 2) / Math.pow(x0 - x1, 2)));
            double x2 = x0 < x1 ? x1 - dx : x1 + dx;
            double y2 = (x2 - x1) * (y0 - y1) / (x0 - x1) + y1;
            return new DoubleVector(x2, y2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;", "", "(Ljava/lang/String;I)V", "ORTHOGONAL_TO_AXIS", "ALONG_AXIS", "SLOPE", "plot-base-portable"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction ORTHOGONAL_TO_AXIS = new Direction();
        public static final /* enum */ Direction ALONG_AXIS = new Direction();
        public static final /* enum */ Direction SLOPE = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.ORTHOGONAL_TO_AXIS, Direction.ALONG_AXIS, Direction.SLOPE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/geom/LollipopGeom$Companion;", "", "()V", "DEF_DIRECTION", "Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;", "getDEF_DIRECTION", "()Ljetbrains/datalore/plot/base/geom/LollipopGeom$Direction;", "DEF_FATTEN", "", "DEF_INTERCEPT", "DEF_SLOPE", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Direction getDEF_DIRECTION() {
            return DEF_DIRECTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.ORTHOGONAL_TO_AXIS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ALONG_AXIS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SLOPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

