/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleSegment;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.HintsCollection;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildHints", "", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "colorsByDataPoint", "Lkotlin/Function1;", "", "Ljetbrains/datalore/base/values/Color;", "isVerticalGeom", "", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "Companion", "ErrorBarLegendKeyElementFactory", "plot-base-portable"})
public final class ErrorBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new ErrorBarLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.ERROR_BAR, ctx2);
        Iterable<DataPointAesthetics> dataPoints2 = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getYMIN(), Aes.Companion.getYMAX(), Aes.Companion.getWIDTH());
        boolean isVertical = CollectionsKt.any(dataPoints2);
        if (!isVertical) {
            dataPoints2 = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getY(), Aes.Companion.getXMIN(), Aes.Companion.getXMAX(), Aes.Companion.getHEIGHT());
        }
        Aes<Double> xAes = isVertical ? Aes.Companion.getX() : Aes.Companion.getY();
        Aes<Double> minAes = isVertical ? Aes.Companion.getYMIN() : Aes.Companion.getXMIN();
        Aes<Double> maxAes = isVertical ? Aes.Companion.getYMAX() : Aes.Companion.getXMAX();
        Aes<Double> widthAes = isVertical ? Aes.Companion.getWIDTH() : Aes.Companion.getHEIGHT();
        for (DataPointAesthetics p : dataPoints2) {
            DoubleRectangle doubleRectangle;
            void $this$mapTo$iv$iv;
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            double x2 = ((Number)d).doubleValue();
            Double d2 = p.get(minAes);
            Intrinsics.checkNotNull((Object)d2);
            double ymin = ((Number)d2).doubleValue();
            Double d3 = p.get(maxAes);
            Intrinsics.checkNotNull((Object)d3);
            double ymax = ((Number)d3).doubleValue();
            Double d4 = p.get(widthAes);
            Intrinsics.checkNotNull((Object)d4);
            double width2 = ((Number)d4).doubleValue() * ctx2.getResolution(xAes);
            double height = ymax - ymin;
            DoubleRectangle rect2 = new DoubleRectangle(x2 - width2 / (double)2, ymin, width2, height);
            Iterable $this$map$iv = ErrorBarGeom.Companion.errorBarShapeSegments(rect2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DoubleSegment doubleSegment;
                void it;
                DoubleSegment doubleSegment2 = (DoubleSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean bl2 = isVertical;
                if (bl2) {
                    doubleSegment = it;
                } else if (!bl2) {
                    doubleSegment = new DoubleSegment(it.getStart().flip(), it.getEnd().flip());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(doubleSegment);
            }
            List segments = (List)destination$iv$iv;
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(segments, p, geomHelper);
            root.add(g);
            DoubleRectangle it = new DoubleRectangle(rect2.getLeft(), rect2.getCenter().getY(), rect2.getWidth(), 0.0);
            boolean bl = false;
            boolean bl3 = isVertical;
            if (bl3) {
                doubleRectangle = it;
            } else if (!bl3) {
                doubleRectangle = it.flip();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleRectangle hintRect = doubleRectangle;
            this.buildHints(hintRect, p, ctx2, geomHelper, colorsByDataPoint, isVertical);
        }
    }

    private final void buildHints(DoubleRectangle rect2, DataPointAesthetics p, GeomContext ctx2, GeomHelper geomHelper, Function1<? super DataPointAesthetics, ? extends List<Color>> colorsByDataPoint, boolean isVerticalGeom) {
        Double d;
        DoubleRectangle clientRect;
        boolean isVerticallyOriented = isVerticalGeom ? !ctx2.getFlipped() : ctx2.getFlipped();
        DoubleRectangle doubleRectangle = clientRect = geomHelper.toClient(rect2, p);
        if (doubleRectangle != null) {
            DoubleRectangle $this$buildHints_u24lambda_u242 = doubleRectangle;
            boolean bl = false;
            d = isVerticallyOriented ? $this$buildHints_u24lambda_u242.getWidth() / 2.0 : $this$buildHints_u24lambda_u242.getHeight() / 2.0;
        } else {
            d = null;
        }
        Intrinsics.checkNotNull(d);
        double objectRadius = d;
        Aes<Double> aes = isVerticalGeom ? Aes.Companion.getX() : Aes.Companion.getY();
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(objectRadius);
        Double d2 = p.get(aes);
        Intrinsics.checkNotNull((Object)d2);
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultCoord(((Number)d2).doubleValue()).defaultKind(isVerticallyOriented ? TipLayoutHint.Kind.HORIZONTAL_TOOLTIP : TipLayoutHint.Kind.ROTATED_TOOLTIP);
        Aes<Double> minAes = isVerticalGeom ? Aes.Companion.getYMIN() : Aes.Companion.getXMIN();
        Aes<Double> maxAes = isVerticalGeom ? Aes.Companion.getYMAX() : Aes.Companion.getXMAX();
        Map<Aes<?>, TipLayoutHint> hints = new HintsCollection(p, geomHelper).addHint(hint.create(minAes)).addHint(hint.create(maxAes)).getHints();
        ctx2.getTargetCollector().addRectangle(p.index(), clientRect, new GeomTargetCollector.TooltipParams(hints, null, null, (List)colorsByDataPoint.invoke((Object)p), 6, null), isVerticallyOriented ? TipLayoutHint.Kind.HORIZONTAL_TOOLTIP : TipLayoutHint.Kind.VERTICAL_TOOLTIP);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$ErrorBarLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-base-portable"})
    public static final class ErrorBarLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size2.getX() - strokeWidth);
            double height = size2.getY() - strokeWidth;
            double x2 = (size2.getX() - width2) / (double)2;
            double y2 = strokeWidth / (double)2;
            return Companion.errorBarLegendShape(Companion.errorBarShapeSegments(new DoubleRectangle(x2, y2, width2, height)), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "errorBarLegendShape", "Ljetbrains/datalore/vis/svg/SvgGElement;", "segments", "", "Ljetbrains/datalore/base/geometry/DoubleSegment;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "errorBarShape", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "errorBarShapeSegments", "r", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgGElement errorBarLegendShape(List<DoubleSegment> segments, DataPointAesthetics p) {
            SvgGElement g = new SvgGElement();
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment = (DoubleSegment)element$iv;
                boolean bl = false;
                SvgLineElement shapeLine = new SvgLineElement(segment.getStart().getX(), segment.getStart().getY(), segment.getEnd().getX(), segment.getEnd().getY());
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, shapeLine, p, false, null, 12, null);
                g.children().add(shapeLine);
            }
            return g;
        }

        private final List<DoubleSegment> errorBarShapeSegments(DoubleRectangle r) {
            double center = r.getLeft() + r.getWidth() / (double)2;
            DoubleRectangle $this$errorBarShapeSegments_u24lambda_u241 = r;
            boolean bl = false;
            Object[] objectArray = new DoubleSegment[]{new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getTop())), new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getBottom()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getBottom())), new DoubleSegment(new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getBottom()))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final SvgGElement errorBarShape(List<DoubleSegment> segments, DataPointAesthetics p, GeomHelper geomHelper) {
            SvgGElement g = new SvgGElement();
            GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
            elementHelper.setStrokeAlphaEnabled(true);
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment = (DoubleSegment)element$iv;
                boolean bl = false;
                ObservableList<SvgNode> observableList = g.children();
                SvgLineElement svgLineElement = elementHelper.createLine(segment.getStart(), segment.getEnd(), p);
                Intrinsics.checkNotNull((Object)svgLineElement);
                observableList.add(svgLineElement);
            }
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

