/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections.set;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jetbrains.datalore.base.observable.collections.CollectionAdapter;
import jetbrains.datalore.base.observable.collections.CollectionItemEvent;
import jetbrains.datalore.base.observable.collections.CollectionListener;
import jetbrains.datalore.base.observable.collections.set.ObservableSet;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.event.ListenerCaller;
import jetbrains.datalore.base.observable.event.Listeners;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000bH\u0016J\u001f\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\"\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010'\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0096\u0002J\u0017\u0010)\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/datalore/base/observable/collections/set/AbstractObservableSet;", "ItemT", "Lkotlin/collections/AbstractMutableSet;", "Ljetbrains/datalore/base/observable/collections/set/ObservableSet;", "()V", "actualIterator", "", "getActualIterator", "()Ljava/util/Iterator;", "myListeners", "Ljetbrains/datalore/base/observable/event/Listeners;", "Ljetbrains/datalore/base/observable/collections/CollectionListener;", "add", "", "element", "(Ljava/lang/Object;)Z", "addHandler", "Ljetbrains/datalore/base/registration/Registration;", "handler", "Ljetbrains/datalore/base/observable/event/EventHandler;", "Ljetbrains/datalore/base/observable/collections/CollectionItemEvent;", "addListener", "l", "afterItemAdded", "", "item", "success", "(Ljava/lang/Object;Z)V", "afterItemRemoved", "beforeItemAdded", "(Ljava/lang/Object;)V", "beforeItemRemoved", "checkAdd", "checkRemove", "doAdd", "doAfterAdd", "doAfterRemove", "doBeforeAdd", "doBeforeRemove", "doRemove", "iterator", "onItemAdd", "onItemRemove", "remove", "base"})
public abstract class AbstractObservableSet<ItemT>
extends AbstractMutableSet<ItemT>
implements ObservableSet<ItemT> {
    @Nullable
    private Listeners<CollectionListener<? super ItemT>> myListeners;

    @NotNull
    public abstract Iterator<ItemT> getActualIterator();

    @Override
    @NotNull
    public Registration addListener(@NotNull CollectionListener<? super ItemT> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        if (this.myListeners == null) {
            this.myListeners = new Listeners();
        }
        Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
        Intrinsics.checkNotNull(listeners);
        return listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ItemT element) {
        if (this.contains(element)) {
            return false;
        }
        this.doBeforeAdd(element);
        boolean success2 = false;
        try {
            this.onItemAdd(element);
            success2 = this.doAdd(element);
        }
        finally {
            this.doAfterAdd(element, success2);
        }
        return success2;
    }

    private final void doBeforeAdd(ItemT item) {
        this.checkAdd(item);
        this.beforeItemAdded(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAfterAdd(ItemT item, boolean success2) {
        try {
            if (success2 && this.myListeners != null) {
                Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
                Intrinsics.checkNotNull(listeners);
                listeners.fire(new ListenerCaller<CollectionListener<? super ItemT>>(item){
                    final /* synthetic */ ItemT $item;
                    {
                        this.$item = $item;
                    }

                    public void call(@NotNull CollectionListener<? super ItemT> l) {
                        Intrinsics.checkNotNullParameter(l, (String)"l");
                        l.onItemAdded(new CollectionItemEvent<Object>(null, this.$item, -1, CollectionItemEvent.EventType.ADD));
                    }
                });
            }
        }
        finally {
            this.afterItemAdded(item, success2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        if (!this.contains(element)) {
            return false;
        }
        this.doBeforeRemove(element);
        boolean success2 = false;
        try {
            this.onItemRemove(element);
            success2 = this.doRemove(element);
        }
        finally {
            this.doAfterRemove(element, success2);
        }
        return success2;
    }

    @Override
    @NotNull
    public Iterator<ItemT> iterator() {
        if (this.size() == 0) {
            return ((Set)new LinkedHashSet()).iterator();
        }
        Iterator<ItemT> iterator2 = this.getActualIterator();
        return new Iterator<ItemT>(iterator2, this){
            private boolean myCanRemove;
            @Nullable
            private ItemT myLastReturned;
            final /* synthetic */ Iterator<ItemT> $iterator;
            final /* synthetic */ AbstractObservableSet<ItemT> this$0;
            {
                this.$iterator = $iterator;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.$iterator.hasNext();
            }

            public ItemT next() {
                this.myLastReturned = this.$iterator.next();
                this.myCanRemove = true;
                ItemT ItemT = this.myLastReturned;
                Intrinsics.checkNotNull(ItemT);
                return ItemT;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                if (!this.myCanRemove) {
                    throw new IllegalStateException();
                }
                this.myCanRemove = false;
                ItemT ItemT = this.myLastReturned;
                Intrinsics.checkNotNull(ItemT);
                AbstractObservableSet.access$doBeforeRemove(this.this$0, ItemT);
                boolean success2 = false;
                try {
                    this.$iterator.remove();
                    success2 = true;
                }
                finally {
                    ItemT ItemT2 = this.myLastReturned;
                    Intrinsics.checkNotNull(ItemT2);
                    AbstractObservableSet.access$doAfterRemove(this.this$0, ItemT2, success2);
                }
            }
        };
    }

    private final void doBeforeRemove(ItemT item) {
        this.checkRemove(item);
        this.beforeItemRemoved(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAfterRemove(ItemT item, boolean success2) {
        try {
            if (success2 && this.myListeners != null) {
                Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
                Intrinsics.checkNotNull(listeners);
                listeners.fire(new ListenerCaller<CollectionListener<? super ItemT>>(item){
                    final /* synthetic */ ItemT $item;
                    {
                        this.$item = $item;
                    }

                    public void call(@NotNull CollectionListener<? super ItemT> l) {
                        Intrinsics.checkNotNullParameter(l, (String)"l");
                        l.onItemRemoved(new CollectionItemEvent<Object>(this.$item, null, -1, CollectionItemEvent.EventType.REMOVE));
                    }
                });
            }
        }
        finally {
            this.afterItemRemoved(item, success2);
        }
    }

    protected abstract boolean doAdd(ItemT var1);

    protected abstract boolean doRemove(ItemT var1);

    protected void checkAdd(@Nullable ItemT item) {
    }

    protected void checkRemove(@Nullable ItemT item) {
    }

    protected void beforeItemAdded(@Nullable ItemT item) {
    }

    protected void onItemAdd(@Nullable ItemT item) {
    }

    protected void afterItemAdded(@Nullable ItemT item, boolean success2) {
    }

    protected void beforeItemRemoved(@Nullable ItemT item) {
    }

    protected void onItemRemove(ItemT item) {
    }

    protected void afterItemRemoved(@Nullable ItemT item, boolean success2) {
    }

    @Override
    @NotNull
    public Registration addHandler(@NotNull EventHandler<? super CollectionItemEvent<? extends ItemT>> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.addListener(new CollectionAdapter<ItemT>(handler2){
            final /* synthetic */ EventHandler<CollectionItemEvent<? extends ItemT>> $handler;
            {
                this.$handler = $handler;
            }

            public void onItemAdded(@NotNull CollectionItemEvent<? extends ItemT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.onEvent(event);
            }

            public void onItemRemoved(@NotNull CollectionItemEvent<? extends ItemT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.onEvent(event);
            }
        });
    }

    public static final /* synthetic */ void access$doBeforeRemove(AbstractObservableSet $this, Object item) {
        $this.doBeforeRemove(item);
    }

    public static final /* synthetic */ void access$doAfterRemove(AbstractObservableSet $this, Object item, boolean success2) {
        $this.doAfterRemove(item, success2);
    }
}

