/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.vis.swing.ApplicationContext;
import jetbrains.datalore.vis.swing.PlotComponentProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/vis/swing/PlotPanel;", "Ljavax/swing/JPanel;", "Ljetbrains/datalore/base/registration/Disposable;", "plotComponentProvider", "Ljetbrains/datalore/vis/swing/PlotComponentProvider;", "preferredSizeFromPlot", "", "repaintDelay", "", "applicationContext", "Ljetbrains/datalore/vis/swing/ApplicationContext;", "(Ljetbrains/datalore/vis/swing/PlotComponentProvider;ZILjetbrains/datalore/vis/swing/ApplicationContext;)V", "dispose", "", "handleChildRemoved", "child", "Ljava/awt/Component;", "handleChildRemovedIntern", "plotComponentCreated", "plotComponent", "Ljavax/swing/JComponent;", "rebuildProvidedComponent", "containerSize", "Ljava/awt/Dimension;", "ResizeHook", "vis-swing-common"})
public class PlotPanel
extends JPanel
implements Disposable {
    @NotNull
    private final PlotComponentProvider plotComponentProvider;

    public PlotPanel(@NotNull PlotComponentProvider plotComponentProvider, boolean preferredSizeFromPlot, int repaintDelay, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.plotComponentProvider = plotComponentProvider;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(@NotNull ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"e.child");
                this.handleChildRemovedIntern(component);
            }
        });
        JComponent providedComponent = preferredSizeFromPlot ? this.rebuildProvidedComponent(null) : null;
        this.addComponentListener(new ResizeHook(this, providedComponent, (Function1<? super Dimension, ? extends Dimension>)((Function1)new Function1<Dimension, Dimension>(){

            @NotNull
            public final Dimension invoke(@NotNull Dimension containerSize) {
                Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
                return plotComponentProvider.getPreferredSize(containerSize);
            }
        }), (Function1<? super Dimension, ? extends JComponent>)((Function1)new Function1<Dimension, JComponent>(){

            @NotNull
            public final JComponent invoke(@NotNull Dimension containerSize) {
                Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
                return this.rebuildProvidedComponent(containerSize);
            }
        }), applicationContext, repaintDelay));
    }

    public void dispose() {
        this.removeAll();
    }

    private final void handleChildRemovedIntern(Component child) {
        this.handleChildRemoved(child);
        Component component = child;
        if (component instanceof Disposable) {
            ((Disposable)child).dispose();
        } else if (component instanceof JScrollPane) {
            Component component2 = ((JScrollPane)child).getViewport().getView();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"child.viewport.view");
            this.handleChildRemovedIntern(component2);
        }
    }

    protected void handleChildRemoved(@NotNull Component child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
    }

    protected void plotComponentCreated(@NotNull JComponent plotComponent) {
        Intrinsics.checkNotNullParameter((Object)plotComponent, (String)"plotComponent");
    }

    private final JComponent rebuildProvidedComponent(Dimension containerSize) {
        JComponent jComponent;
        this.removeAll();
        JComponent providedComponent = this.plotComponentProvider.createComponent(containerSize);
        if (providedComponent instanceof JScrollPane) {
            Component component = ((JScrollPane)providedComponent).getViewport().getView();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            jComponent = (JComponent)component;
        } else {
            jComponent = providedComponent;
        }
        JComponent actualPlotComponent = jComponent;
        this.plotComponentCreated(actualPlotComponent);
        this.add(providedComponent);
        return providedComponent;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/vis/swing/PlotPanel$ResizeHook;", "Ljava/awt/event/ComponentAdapter;", "plotPanel", "Ljetbrains/datalore/vis/swing/PlotPanel;", "lastProvidedComponent", "Ljavax/swing/JComponent;", "plotPreferredSize", "Lkotlin/Function1;", "Ljava/awt/Dimension;", "plotComponentFactory", "applicationContext", "Ljetbrains/datalore/vis/swing/ApplicationContext;", "repaintDelay", "", "(Ljetbrains/datalore/vis/swing/PlotPanel;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljetbrains/datalore/vis/swing/ApplicationContext;I)V", "lastPreferredSize", "refreshTimer", "Ljavax/swing/Timer;", "skipThisRun", "", "componentResized", "", "e", "Ljava/awt/event/ComponentEvent;", "rebuildPlotComponent", "vis-swing-common"})
    private static final class ResizeHook
    extends ComponentAdapter {
        @NotNull
        private final PlotPanel plotPanel;
        @Nullable
        private JComponent lastProvidedComponent;
        @NotNull
        private final Function1<Dimension, Dimension> plotPreferredSize;
        @NotNull
        private final Function1<Dimension, JComponent> plotComponentFactory;
        @NotNull
        private final ApplicationContext applicationContext;
        private boolean skipThisRun;
        @Nullable
        private Dimension lastPreferredSize;
        @NotNull
        private final Timer refreshTimer;

        /*
         * WARNING - void declaration
         */
        public ResizeHook(@NotNull PlotPanel plotPanel2, @Nullable JComponent lastProvidedComponent, @NotNull Function1<? super Dimension, ? extends Dimension> plotPreferredSize, @NotNull Function1<? super Dimension, ? extends JComponent> plotComponentFactory, @NotNull ApplicationContext applicationContext, int repaintDelay) {
            void $this$refreshTimer_u24lambda_u241;
            Timer timer;
            Intrinsics.checkNotNullParameter((Object)plotPanel2, (String)"plotPanel");
            Intrinsics.checkNotNullParameter(plotPreferredSize, (String)"plotPreferredSize");
            Intrinsics.checkNotNullParameter(plotComponentFactory, (String)"plotComponentFactory");
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            this.plotPanel = plotPanel2;
            this.lastProvidedComponent = lastProvidedComponent;
            this.plotPreferredSize = plotPreferredSize;
            this.plotComponentFactory = plotComponentFactory;
            this.applicationContext = applicationContext;
            this.skipThisRun = this.lastProvidedComponent != null;
            Timer timer2 = timer = new Timer(repaintDelay, arg_0 -> ResizeHook.refreshTimer$lambda$0(this, arg_0));
            ResizeHook resizeHook = this;
            boolean bl = false;
            $this$refreshTimer_u24lambda_u241.setRepeats(false);
            resizeHook.refreshTimer = timer;
        }

        @Override
        public void componentResized(@Nullable ComponentEvent e) {
            if (!this.refreshTimer.isRunning() && this.skipThisRun) {
                this.applicationContext.runWriteAction(() -> ResizeHook.componentResized$lambda$2(this));
                return;
            }
            this.refreshTimer.stop();
            if (this.lastProvidedComponent instanceof JScrollPane) {
                JComponent jComponent = this.lastProvidedComponent;
                if (jComponent != null) {
                    Serializable serializable = e;
                    jComponent.setPreferredSize(serializable != null && (serializable = ((ComponentEvent)serializable).getComponent()) != null ? ((Component)serializable).getSize() : null);
                }
                JComponent jComponent2 = this.lastProvidedComponent;
                if (jComponent2 != null) {
                    Serializable serializable = e;
                    jComponent2.setSize(serializable != null && (serializable = ((ComponentEvent)serializable).getComponent()) != null ? ((Component)serializable).getSize() : null);
                }
                this.plotPanel.revalidate();
                return;
            }
            this.refreshTimer.restart();
        }

        private final void rebuildPlotComponent() {
            Runnable action = () -> ResizeHook.rebuildPlotComponent$lambda$4(this);
            this.applicationContext.invokeLater(action, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ ResizeHook this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return ResizeHook.access$getRefreshTimer$p(this.this$0).isRunning();
                }
            }));
        }

        private static final void refreshTimer$lambda$0(ResizeHook this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.rebuildPlotComponent();
        }

        private static final void componentResized$lambda$2(ResizeHook this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.skipThisRun = false;
        }

        private static final void rebuildPlotComponent$lambda$4(ResizeHook this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Dimension plotContainerSize = this$0.plotPanel.getSize();
            if (plotContainerSize == null) {
                return;
            }
            if (!(!(this$0.lastProvidedComponent instanceof JScrollPane))) {
                boolean bl = false;
                String string = "Unexpected JScrollPane";
                throw new IllegalStateException(string.toString());
            }
            Dimension preferredSize = (Dimension)this$0.plotPreferredSize.invoke((Object)plotContainerSize);
            if (Intrinsics.areEqual((Object)this$0.lastPreferredSize, (Object)preferredSize)) {
                return;
            }
            this$0.lastPreferredSize = preferredSize;
            this$0.lastProvidedComponent = (JComponent)this$0.plotComponentFactory.invoke((Object)plotContainerSize);
            this$0.plotPanel.revalidate();
        }

        public static final /* synthetic */ Timer access$getRefreshTimer$p(ResizeHook $this) {
            return $this.refreshTimer;
        }
    }
}

