/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.Checksum;
import org.jetbrains.letsPlot.util.pngj.PngjException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020-J\u0006\u0010/\u001a\u00020-J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR \u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R \u0010'\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&\u00a8\u00066"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "", "cols", "", "rows", "bitdepth", "alpha", "", "greyscale", "indexed", "(IIIZZZ)V", "getAlpha", "()Z", "bitDepth", "getBitDepth", "()I", "bitspPixel", "getBitspPixel", "bytesPerRow", "getBytesPerRow", "bytesPixel", "getBytesPixel", "channels", "getChannels", "getCols", "getGreyscale", "getIndexed", "packed", "getPacked", "getRows", "samplesPerRow", "getSamplesPerRow", "samplesPerRowPacked", "getSamplesPerRowPacked", "<set-?>", "", "totalPixels", "getTotalPixels", "()J", "totalRawBytes", "getTotalRawBytes", "equals", "other", "hashCode", "toString", "", "toStringBrief", "toStringDetail", "updateCrc", "", "crc", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "withSize", "Companion", "plot-api"})
public final class ImageInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int cols;
    private final int rows;
    private final boolean alpha;
    private final boolean greyscale;
    private final boolean indexed;
    private final int bitDepth;
    private final int channels;
    private final boolean packed;
    private final int bitspPixel;
    private final int bytesPixel;
    private final int bytesPerRow;
    private final int samplesPerRow;
    private final int samplesPerRowPacked;
    private long totalPixels;
    private long totalRawBytes;
    public static final int MAX_COLS_ROW = 0x1000000;

    @JvmOverloads
    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha, boolean greyscale, boolean indexed) {
        this.cols = cols;
        this.rows = rows;
        this.alpha = alpha;
        this.greyscale = greyscale;
        this.indexed = indexed;
        this.totalPixels = -1L;
        this.totalRawBytes = -1L;
        if (this.greyscale && this.indexed) {
            throw new PngjException("palette and greyscale are mutually exclusive");
        }
        this.channels = this.greyscale || this.indexed ? (this.alpha ? 2 : 1) : (this.alpha ? 4 : 3);
        this.bitDepth = bitdepth;
        this.packed = bitdepth < 8;
        this.bitspPixel = this.channels * this.bitDepth;
        this.bytesPixel = (this.bitspPixel + 7) / 8;
        this.bytesPerRow = (this.bitspPixel * this.cols + 7) / 8;
        this.samplesPerRow = this.channels * this.cols;
        this.samplesPerRowPacked = this.packed ? this.bytesPerRow : this.samplesPerRow;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (this.cols < 1 || this.cols > 0x1000000) {
            throw new PngjException("invalid cols=" + this.cols + " ???");
        }
        if (this.rows < 1 || this.rows > 0x1000000) {
            throw new PngjException("invalid rows=" + this.rows + " ???");
        }
        if (this.samplesPerRow < 1) {
            throw new PngjException("invalid image parameters (overflow?)");
        }
    }

    public /* synthetic */ ImageInfo(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x20) != 0) {
            bl3 = false;
        }
        this(n, n2, n3, bl, bl2, bl3);
    }

    public final int getCols() {
        return this.cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final boolean getAlpha() {
        return this.alpha;
    }

    public final boolean getGreyscale() {
        return this.greyscale;
    }

    public final boolean getIndexed() {
        return this.indexed;
    }

    public final int getBitDepth() {
        return this.bitDepth;
    }

    public final int getChannels() {
        return this.channels;
    }

    public final boolean getPacked() {
        return this.packed;
    }

    public final int getBitspPixel() {
        return this.bitspPixel;
    }

    public final int getBytesPixel() {
        return this.bytesPixel;
    }

    public final int getBytesPerRow() {
        return this.bytesPerRow;
    }

    public final int getSamplesPerRow() {
        return this.samplesPerRow;
    }

    public final int getSamplesPerRowPacked() {
        return this.samplesPerRowPacked;
    }

    public final long getTotalPixels() {
        if (this.totalPixels < 0L) {
            this.totalPixels = (long)this.cols * (long)this.rows;
        }
        return this.totalPixels;
    }

    public final long getTotalRawBytes() {
        if (this.totalRawBytes < 0L) {
            this.totalRawBytes = (long)(this.bytesPerRow + 1) * (long)this.rows;
        }
        return this.totalRawBytes;
    }

    @NotNull
    public final ImageInfo withSize(int cols, int rows) {
        return new ImageInfo(cols > 0 ? cols : this.cols, rows > 0 ? rows : this.rows, this.bitDepth, this.alpha, this.greyscale, this.indexed);
    }

    @NotNull
    public String toString() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + ']';
    }

    @NotNull
    public final String toStringBrief() {
        return "" + this.cols + 'x' + this.rows + (this.bitDepth != 8 ? "" + 'd' + this.bitDepth : "") + (this.alpha ? "a" : "") + (this.indexed ? "p" : "") + (this.greyscale ? "g" : "");
    }

    @NotNull
    public final String toStringDetail() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ImageInfo [cols=").append(this.cols).append(", rows=").append(this.rows).append(", bitDepth=").append(this.bitDepth).append(", channels=").append(this.channels).append(", bitspPixel=").append(this.bitspPixel).append(", bytesPixel=").append(this.bytesPixel).append(", bytesPerRow=").append(this.bytesPerRow).append(", samplesPerRow=").append(this.samplesPerRow).append(", samplesPerRowP=").append(this.samplesPerRowPacked).append(", alpha=").append(this.alpha).append(", greyscale=").append(this.greyscale).append(", indexed=");
        stringBuilder.append(this.indexed).append(", packed=").append(this.packed).append(']');
        return stringBuilder.toString();
    }

    public final void updateCrc(@NotNull Checksum crc) {
        Intrinsics.checkNotNullParameter((Object)crc, (String)"crc");
        crc.update((byte)this.rows);
        crc.update((byte)(this.rows >> 8));
        crc.update((byte)(this.rows >> 16));
        crc.update((byte)this.cols);
        crc.update((byte)(this.cols >> 8));
        crc.update((byte)(this.cols >> 16));
        crc.update((byte)this.bitDepth);
        crc.update((byte)(this.indexed ? 1 : 2));
        crc.update((byte)(this.greyscale ? 3 : 4));
        crc.update((byte)(this.alpha ? 3 : 4));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.alpha ? 1231 : 1237);
        result = prime * result + this.bitDepth;
        result = prime * result + this.cols;
        result = prime * result + (this.greyscale ? 1231 : 1237);
        result = prime * result + (this.indexed ? 1231 : 1237);
        result = prime * result + this.rows;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        ImageInfo cfr_ignored_0 = (ImageInfo)other;
        if (this.alpha != ((ImageInfo)other).alpha) {
            return false;
        }
        if (this.bitDepth != ((ImageInfo)other).bitDepth) {
            return false;
        }
        if (this.cols != ((ImageInfo)other).cols) {
            return false;
        }
        if (this.greyscale != ((ImageInfo)other).greyscale) {
            return false;
        }
        if (this.indexed != ((ImageInfo)other).indexed) {
            return false;
        }
        return this.rows == ((ImageInfo)other).rows;
    }

    @JvmOverloads
    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha, boolean greyscale) {
        this(cols, rows, bitdepth, alpha, greyscale, false, 32, null);
    }

    @JvmOverloads
    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha) {
        this(cols, rows, bitdepth, alpha, false, false, 48, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageInfo$Companion;", "", "()V", "MAX_COLS_ROW", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

