/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.mapper.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.observable.event.ListenerCaller;
import jetbrains.datalore.base.observable.event.Listeners;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.mapper.core.Mapper;
import jetbrains.datalore.mapper.core.Mappers;
import jetbrains.datalore.mapper.core.MappingContextListener;
import jetbrains.datalore.mapper.core.MappingContextProperty;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\tJ\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00140\u001aJ/\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u0011\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014J\u001f\u0010#\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010$\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0001\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/datalore/mapper/core/MappingContext;", "", "()V", "myListeners", "Ljetbrains/datalore/base/observable/event/Listeners;", "Ljetbrains/datalore/mapper/core/MappingContextListener;", "myMappers", "", "myProperties", "Ljetbrains/datalore/mapper/core/MappingContextProperty;", "addListener", "Ljetbrains/datalore/base/registration/Registration;", "l", "contains", "", "property", "get", "ValueT", "(Ljetbrains/datalore/mapper/core/MappingContextProperty;)Ljava/lang/Object;", "getMapper", "Ljetbrains/datalore/mapper/core/Mapper;", "S", "ancestor", "source", "(Ljetbrains/datalore/mapper/core/Mapper;Ljava/lang/Object;)Ljetbrains/datalore/mapper/core/Mapper;", "getMappers", "", "(Ljava/lang/Object;)Ljava/util/Set;", "(Ljetbrains/datalore/mapper/core/Mapper;Ljava/lang/Object;)Ljava/util/Set;", "put", "", "value", "(Ljetbrains/datalore/mapper/core/MappingContextProperty;Ljava/lang/Object;)V", "register", "mapper", "remove", "unregister", "mapper-core"})
public final class MappingContext {
    @NotNull
    private final Map<? super Object, ? super Object> myMappers = new LinkedHashMap();
    @NotNull
    private final Listeners<MappingContextListener> myListeners = new Listeners();
    @NotNull
    private final Map<MappingContextProperty<?>, Object> myProperties = new LinkedHashMap();

    @NotNull
    public final Registration addListener(@NotNull MappingContextListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return this.myListeners.add(l);
    }

    public final void register(@NotNull Mapper<?, ?> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (mapper.isFindable()) {
            Object source = mapper.getSource();
            if (!this.myMappers.containsKey(source)) {
                this.myMappers.put(source, mapper);
            } else {
                Object ms = this.myMappers.get(source);
                if (ms instanceof Set) {
                    Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                    mappers.add(mapper);
                } else {
                    Intrinsics.checkNotNull((Object)ms, (String)"null cannot be cast to non-null type jetbrains.datalore.mapper.core.Mapper<*, *>");
                    Mapper m = (Mapper)ms;
                    Object[] objectArray = new Mapper[]{m, mapper};
                    Set mappers = SetsKt.mutableSetOf((Object[])objectArray);
                    this.myMappers.put(source, mappers);
                }
            }
        }
        this.myListeners.fire(new ListenerCaller<MappingContextListener>(mapper){
            final /* synthetic */ Mapper<?, ?> $mapper;
            {
                this.$mapper = $mapper;
            }

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperRegistered(this.$mapper);
            }
        });
    }

    public final void unregister(@NotNull Mapper<?, ?> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (mapper.isFindable()) {
            Object source = mapper.getSource();
            if (!this.myMappers.containsKey(source)) {
                throw new IllegalStateException();
            }
            Object ms = this.myMappers.get(source);
            if (ms instanceof Set) {
                Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                mappers.remove(mapper);
                if (mappers.size() == 1) {
                    this.myMappers.put(source, mappers.iterator().next());
                }
            } else {
                if (!Intrinsics.areEqual((Object)ms, mapper)) {
                    throw new IllegalStateException();
                }
                this.myMappers.remove(source);
            }
        }
        this.myListeners.fire(new ListenerCaller<MappingContextListener>(mapper){
            final /* synthetic */ Mapper<?, ?> $mapper;
            {
                this.$mapper = $mapper;
            }

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperUnregistered(this.$mapper);
            }
        });
    }

    @Nullable
    public final <S> Mapper<? super S, Object> getMapper(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> result2 = this.getMappers(ancestor, source);
        if (result2.isEmpty()) {
            return null;
        }
        if (result2.size() > 1) {
            throw new IllegalStateException("There are more than one mapper for " + source);
        }
        return result2.iterator().next();
    }

    @NotNull
    public final <S> Set<Mapper<? super S, Object>> getMappers(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> mappers = this.getMappers(source);
        Set result2 = null;
        for (Mapper<S, Object> m : mappers) {
            if (!Mappers.INSTANCE.isDescendant(ancestor, m)) continue;
            if (result2 == null) {
                if (mappers.size() == 1) {
                    return SetsKt.setOf(m);
                }
                result2 = new LinkedHashSet();
            }
            result2.add(m);
        }
        if (result2 == null) {
            return SetsKt.emptySet();
        }
        return result2;
    }

    public final <ValueT> void put(@NotNull MappingContextProperty<ValueT> property2, @Nullable ValueT value) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (this.myProperties.containsKey(property2)) {
            throw new IllegalStateException("Property " + property2 + " is already defined");
        }
        if (value == null) {
            throw new IllegalArgumentException("Trying to set null as a value of " + property2);
        }
        this.myProperties.put(property2, value);
    }

    public final <ValueT> ValueT get(@NotNull MappingContextProperty<ValueT> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        Object object = this.myProperties.get(property2);
        if (object == null) {
            throw new IllegalStateException("Property " + property2 + " wasn't found");
        }
        Object value = object;
        return (ValueT)value;
    }

    public final boolean contains(@NotNull MappingContextProperty<Object> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        return this.myProperties.containsKey(property2);
    }

    public final <ValueT> ValueT remove(@NotNull MappingContextProperty<Object> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (!this.myProperties.containsKey(property2)) {
            throw new IllegalStateException("Property " + property2 + " wasn't found");
        }
        return (ValueT)this.myProperties.remove(property2);
    }

    @NotNull
    public final Set<Mapper<? super Object, Object>> getMappers() {
        Set mappers = new LinkedHashSet();
        for (Object object : this.myMappers.keySet()) {
            mappers.addAll((Collection)this.getMappers(object));
        }
        return mappers;
    }

    private final <S> Set<Mapper<? super S, Object>> getMappers(S source) {
        if (!this.myMappers.containsKey(source)) {
            return SetsKt.emptySet();
        }
        Object mappersObject = this.myMappers.get(source);
        if (mappersObject instanceof Mapper) {
            Mapper mapper = (Mapper)mappersObject;
            return SetsKt.setOf((Object)mapper);
        }
        Set result2 = new LinkedHashSet();
        Intrinsics.checkNotNull((Object)mappersObject, (String)"null cannot be cast to non-null type kotlin.collections.Set<jetbrains.datalore.mapper.core.Mapper<in S of jetbrains.datalore.mapper.core.MappingContext.getMappers, kotlin.Any>>");
        Set mapperSet = (Set)mappersObject;
        for (Mapper m : mapperSet) {
            result2.add(m);
        }
        return result2;
    }
}

