/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.function.Supplier;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u001b\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\u0002\u0010\u0018R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/base/registration/RegistrationMap;", "KeyT", "", "()V", "myMap", "Ljava/util/HashMap;", "Ljetbrains/datalore/base/registration/Registration;", "Lkotlin/collections/HashMap;", "clear", "", "keys", "", "put", "key", "registration", "(Ljava/lang/Object;Ljetbrains/datalore/base/registration/Registration;)V", "remove", "(Ljava/lang/Object;)V", "removeOptional", "", "(Ljava/lang/Object;)Z", "replace", "registrationSupplier", "Ljetbrains/datalore/base/function/Supplier;", "(Ljava/lang/Object;Ljetbrains/datalore/base/function/Supplier;)Z", "base"})
public final class RegistrationMap<KeyT> {
    @NotNull
    private final HashMap<KeyT, Registration> myMap = new HashMap();

    public final void put(KeyT key, @NotNull Registration registration2) {
        Intrinsics.checkNotNullParameter((Object)registration2, (String)"registration");
        Registration prev = this.myMap.put(key, registration2);
        if (prev != null) {
            prev.remove();
            Registration registration3 = this.myMap.remove(key);
            Intrinsics.checkNotNull((Object)registration3);
            registration3.remove();
            throw new IllegalStateException("Registration for the key '" + key + "' already exists.");
        }
    }

    public final boolean replace(KeyT key, @NotNull Supplier<Registration> registrationSupplier) {
        Intrinsics.checkNotNullParameter(registrationSupplier, (String)"registrationSupplier");
        boolean res = this.removeOptional(key);
        ((Map)this.myMap).put(key, registrationSupplier.get());
        return res;
    }

    public final void remove(KeyT key) {
        Registration prev = this.myMap.remove(key);
        if (prev == null) {
            throw new IllegalStateException("Registration for the key '" + key + "' not found.");
        }
        prev.remove();
    }

    public final boolean removeOptional(KeyT key) {
        Registration prev = this.myMap.remove(key);
        if (prev != null) {
            prev.remove();
            return true;
        }
        return false;
    }

    @NotNull
    public final Set<KeyT> keys() {
        Set<KeyT> set2 = this.myMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"myMap.keys");
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        try {
            for (Registration r : this.myMap.values()) {
                r.remove();
            }
        }
        finally {
            this.myMap.clear();
        }
    }
}

