/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class DateTimeConvertFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(DateTimeConvertFunction.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__dateTimeConvert";
    private static final int MIN_PARAMETER_COUNT = 3;
    private static final int MAX_PARAMETER_COUNT = 4;
    private CompoundVariable[] values;

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String dateString = this.values[0].execute();
        String sourceDateFormat = this.values[1].execute();
        String targetDateFormat = this.values[2].execute();
        try {
            String newDate;
            DateTimeFormatter targetDateFormatter = DateTimeFormatter.ofPattern(targetDateFormat).withZone(ZoneId.systemDefault());
            if (sourceDateFormat != null && !sourceDateFormat.isEmpty()) {
                DateTimeFormatter sourceDateFormatter = DateTimeFormatter.ofPattern(sourceDateFormat).withZone(ZoneId.systemDefault());
                newDate = targetDateFormatter.format(sourceDateFormatter.parse(dateString));
            } else {
                newDate = targetDateFormatter.format(Instant.ofEpochMilli(Long.parseLong(dateString)));
            }
            this.addVariableValue(newDate, this.values, 3);
            return newDate;
        }
        catch (Exception e) {
            log.error("Error calling {} function with value {}, source format {}, target format {}, ", new Object[]{KEY, dateString, sourceDateFormat, targetDateFormat, e});
            return "";
        }
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 3, 4);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"date_string"));
        desc.add(JMeterUtils.getResString((String)"date_format_old"));
        desc.add(JMeterUtils.getResString((String)"date_format_new"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

