/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.sampling.method.GroupSamplingBase;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import jetbrains.datalore.plot.builder.sampling.method.SystematicSampling;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0016J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/GroupSystematicSampling;", "Ljetbrains/datalore/plot/builder/sampling/method/GroupSamplingBase;", "sampleSize", "", "(I)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "groupMapper", "Lkotlin/Function1;", "isApplicable", "", "groupCount", "Companion", "plot-builder-portable"})
public final class GroupSystematicSampling
extends GroupSamplingBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ALIAS = "group_systematic";

    public GroupSystematicSampling(int sampleSize) {
        super(sampleSize);
    }

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_group_systematic(n=" + this.getSampleSize() + ')';
    }

    @Override
    public boolean isApplicable(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2, int groupCount2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        return super.isApplicable(population, groupMapper2, groupCount2) && SystematicSampling.Companion.computeStep(groupCount2, this.getSampleSize()) >= 2;
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        if (!this.isApplicable(population, groupMapper2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<Integer> distinctGroups = SamplingUtil.INSTANCE.distinctGroups(groupMapper2, population.rowCount());
        int step = SystematicSampling.Companion.computeStep(distinctGroups.size(), this.getSampleSize());
        HashSet<Integer> pickedGroups = new HashSet<Integer>();
        for (int i = 0; i < distinctGroups.size(); i += step) {
            pickedGroups.add(distinctGroups.get(i));
        }
        return this.doSelect(population, (Set<Integer>)pickedGroups, groupMapper2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/GroupSystematicSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

