/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgContainer;
import jetbrains.datalore.vis.svg.SvgCssResource;
import jetbrains.datalore.vis.svg.SvgIRI;
import jetbrains.datalore.vis.svg.SvgLocatable;
import jetbrains.datalore.vis.svg.SvgPlatformPeer;
import jetbrains.datalore.vis.svg.SvgStylableElement;
import jetbrains.datalore.vis.svg.SvgStyleElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002#$B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012J\u0010\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0012J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 J\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012J\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012J\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Ljetbrains/datalore/vis/svg/SvgStylableElement;", "Ljetbrains/datalore/vis/svg/SvgContainer;", "Ljetbrains/datalore/vis/svg/SvgLocatable;", "width", "", "height", "(DD)V", "()V", "bBox", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getBBox", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "clipPath", "Ljetbrains/datalore/base/observable/property/Property;", "Ljetbrains/datalore/vis/svg/SvgIRI;", "opacity", "pointToAbsoluteCoordinates", "Ljetbrains/datalore/base/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "setStyle", "", "css", "Ljetbrains/datalore/vis/svg/SvgCssResource;", "viewBox", "Ljetbrains/datalore/vis/svg/SvgSvgElement$ViewBoxRectangle;", "viewBoxRect", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "x", "y", "Companion", "ViewBoxRectangle", "vis-svg-portable"})
public final class SvgSvgElement
extends SvgStylableElement
implements SvgContainer,
SvgLocatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X = SvgAttributeSpec.Companion.createSpec("x");
    @NotNull
    private static final SvgAttributeSpec<Double> Y = SvgAttributeSpec.Companion.createSpec("y");
    @NotNull
    private static final SvgAttributeSpec<Double> WIDTH = SvgAttributeSpec.Companion.createSpec("width");
    @NotNull
    private static final SvgAttributeSpec<Double> HEIGHT = SvgAttributeSpec.Companion.createSpec("height");
    @NotNull
    private static final SvgAttributeSpec<ViewBoxRectangle> VIEW_BOX = SvgAttributeSpec.Companion.createSpec("viewBox");

    public SvgSvgElement() {
        this.elementName = "svg";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgSvgElement(double width, double height) {
        this();
        this.setAttribute(WIDTH, width);
        this.setAttribute(HEIGHT, height);
    }

    public final void setStyle(@NotNull SvgCssResource css) {
        Intrinsics.checkNotNullParameter((Object)css, (String)"css");
        this.children().add((Object)new SvgStyleElement(css));
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    @NotNull
    public final Property<Double> width() {
        return this.getAttribute(WIDTH);
    }

    @NotNull
    public final Property<Double> height() {
        return this.getAttribute(HEIGHT);
    }

    @NotNull
    public final Property<ViewBoxRectangle> viewBox() {
        return this.getAttribute(VIEW_BOX);
    }

    @NotNull
    public final WritableProperty<DoubleRectangle> viewBoxRect() {
        return (WritableProperty)new WritableProperty<DoubleRectangle>(this){
            final /* synthetic */ SvgSvgElement this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@NotNull DoubleRectangle value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.this$0.viewBox().set((Object)new ViewBoxRectangle(value));
            }
        };
    }

    @Override
    @NotNull
    public Property<Double> opacity() {
        return this.getAttribute(SvgContainer.Companion.getOPACITY());
    }

    @Override
    @NotNull
    public Property<SvgIRI> clipPath() {
        return this.getAttribute(SvgContainer.Companion.getCLIP_PATH());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/vis/svg/SvgSvgElement$Companion;", "", "()V", "HEIGHT", "Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "", "getHEIGHT", "()Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "VIEW_BOX", "Ljetbrains/datalore/vis/svg/SvgSvgElement$ViewBoxRectangle;", "getVIEW_BOX", "WIDTH", "getWIDTH", "X", "getX", "Y", "getY", "vis-svg-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX() {
            return X;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY() {
            return Y;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getWIDTH() {
            return WIDTH;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getHEIGHT() {
            return HEIGHT;
        }

        @NotNull
        public final SvgAttributeSpec<ViewBoxRectangle> getVIEW_BOX() {
            return VIEW_BOX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/vis/svg/SvgSvgElement$ViewBoxRectangle;", "", "x", "", "y", "width", "height", "(DDDD)V", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;)V", "myHeight", "myWidth", "myX", "myY", "toString", "", "vis-svg-portable"})
    public static final class ViewBoxRectangle {
        private double myX;
        private double myY;
        private double myWidth;
        private double myHeight;

        public ViewBoxRectangle(double x, double y, double width, double height) {
            this.myX = x;
            this.myY = y;
            this.myWidth = width;
            this.myHeight = height;
        }

        public ViewBoxRectangle(@NotNull DoubleRectangle rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            this.myX = rect.getOrigin().getX();
            this.myY = rect.getOrigin().getY();
            this.myWidth = rect.getDimension().getX();
            this.myHeight = rect.getDimension().getY();
        }

        @NotNull
        public String toString() {
            return "" + this.myX + ' ' + this.myY + ' ' + this.myWidth + ' ' + this.myHeight;
        }
    }
}

