/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProviderFactory;
import jetbrains.datalore.plot.builder.layout.axis.AxisLayouter;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout;", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "breaksProviderFactory", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "(Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/guide/Orientation;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "axisLength", "maxTickLabelsBoundsStretched", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "initialThickness", "Companion", "plot-builder-portable"})
public final class PlotAxisLayout
implements AxisLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisBreaksProviderFactory breaksProviderFactory;
    @NotNull
    private final AxisTheme theme;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private static final PlotLabelSpec TICK_LABEL_SPEC = PlotLabelSpec.AXIS_TICK;

    public PlotAxisLayout(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @NotNull AxisTheme theme, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.breaksProviderFactory = breaksProviderFactory;
        this.theme = theme;
        this.orientation = orientation;
    }

    @Override
    public double initialThickness() {
        if (this.theme.showTickMarks() || this.theme.showLabels()) {
            double v = this.theme.tickLabelDistance();
            return this.theme.showLabels() ? v + PlotAxisLayout.Companion.initialTickLabelSize(this.orientation) : v;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public AxisLayoutInfo doLayout(@NotNull ClosedRange<Double> axisDomain, double axisLength, @Nullable DoubleRectangle maxTickLabelsBoundsStretched) {
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        AxisBreaksProvider breaksProvider = this.breaksProviderFactory.createAxisBreaksProvider(axisDomain);
        AxisLayouter layouter = AxisLayouter.Companion.create(this.orientation, axisDomain, breaksProvider, this.theme);
        return layouter.doLayout(axisLength, maxTickLabelsBoundsStretched);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout$Companion;", "", "()V", "TICK_LABEL_SPEC", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "initialTickLabelSize", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final double initialTickLabelSize(Orientation orientation) {
            return orientation.isHorizontal() ? TICK_LABEL_SPEC.height() : TICK_LABEL_SPEC.width(1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

