/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact.loc;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.loc.TargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetProjectionKt;
import jetbrains.datalore.plot.common.geometry.PolylineSimplifier;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "Ljetbrains/datalore/plot/builder/interact/loc/TargetProjection;", "data", "", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "x", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "xy", "", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "Companion", "RingXY", "plot-builder-portable"})
public final class PolygonTargetProjection
extends TargetProjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object data;
    private static final double AREA_LIMIT_TO_REMOVE_POLYGON = 25.0;
    private static final double POINTS_COUNT_TO_SKIP_SIMPLIFICATION = 20.0;
    private static final double AREA_TOLERANCE_RATIO = 0.1;
    private static final double MAX_TOLERANCE = 40.0;
    private static final boolean isLogEnabled = false;

    private PolygonTargetProjection(Object data) {
        this.data = data;
    }

    @NotNull
    public final Object getData() {
        return this.data;
    }

    @NotNull
    public final MathUtil.DoubleRange x() {
        return (MathUtil.DoubleRange)this.data;
    }

    @NotNull
    public final List<RingXY> xy() {
        return (List)this.data;
    }

    public /* synthetic */ PolygonTargetProjection(Object data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\rH\u0002J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$Companion;", "", "()V", "AREA_LIMIT_TO_REMOVE_POLYGON", "", "AREA_TOLERANCE_RATIO", "MAX_TOLERANCE", "POINTS_COUNT_TO_SKIP_SIMPLIFICATION", "isLogEnabled", "", "create", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "points", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "lookupSpace", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;", "log", "", "str", "", "mapToX", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "rings", "mapToXY", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolygonTargetProjection create(@NotNull List<DoubleVector> points, @NotNull GeomTargetLocator.LookupSpace lookupSpace) {
            PolygonTargetProjection polygonTargetProjection;
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter((Object)lookupSpace, (String)"lookupSpace");
            List rings = GeometryKt.splitRings(points);
            GeomTargetLocator.LookupSpace lookupSpace2 = lookupSpace;
            int n = WhenMappings.$EnumSwitchMapping$0[lookupSpace2.ordinal()];
            switch (n) {
                case 1: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToX(rings), null);
                    break;
                }
                case 2: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToXY(rings), null);
                    break;
                }
                case 3: {
                    TargetProjectionKt.access$undefinedLookupSpaceError();
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return polygonTargetProjection;
        }

        private final MathUtil.DoubleRange mapToX(List<? extends List<DoubleVector>> rings) {
            double min;
            double max = min = rings.get(0).get(0).getX();
            for (List<DoubleVector> list : rings) {
                for (DoubleVector point2 : list) {
                    double d = point2.getX();
                    boolean bl = false;
                    min = Math.min(min, d);
                    d = point2.getX();
                    bl = false;
                    max = Math.max(max, d);
                }
            }
            return MathUtil.DoubleRange.Companion.withStartAndEnd(min, max);
        }

        private final List<RingXY> mapToXY(List<? extends List<DoubleVector>> rings) {
            ArrayList<RingXY> polygon2 = new ArrayList<RingXY>();
            for (List list : rings) {
                if (list.size() < 4) continue;
                DoubleRectangle bbox = DoubleRectangles.INSTANCE.boundingBox((Iterable)list);
                double area2 = GeometryKt.calculateArea(list);
                List simplifiedRing = null;
                if ((double)list.size() > 20.0) {
                    double d = area2 * 0.1;
                    double d2 = 40.0;
                    boolean bl = false;
                    double tolerance = Math.min(d, d2);
                    simplifiedRing = PolylineSimplifier.Companion.visvalingamWhyatt(list).setWeightLimit(tolerance).getPoints();
                } else {
                    simplifiedRing = list;
                }
                if (simplifiedRing.size() < 4) continue;
                polygon2.add(new RingXY(simplifiedRing, bbox));
            }
            return polygon2;
        }

        private final void log(String str) {
            boolean bl = false;
            System.out.println((Object)str);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GeomTargetLocator.LookupSpace.values().length];
                nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
                nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 2;
                nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "", "edges", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bbox", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "(Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleRectangle;)V", "getBbox", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getEdges", "()Ljava/util/List;", "plot-builder-portable"})
    public static final class RingXY {
        @NotNull
        private final List<DoubleVector> edges;
        @NotNull
        private final DoubleRectangle bbox;

        public RingXY(@NotNull List<DoubleVector> edges, @NotNull DoubleRectangle bbox) {
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
            this.edges = edges;
            this.bbox = bbox;
        }

        @NotNull
        public final List<DoubleVector> getEdges() {
            return this.edges;
        }

        @NotNull
        public final DoubleRectangle getBbox() {
            return this.bbox;
        }
    }
}

