/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.menu;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apiguardian.api.API;

@API(since="5.3", status=API.Status.INTERNAL)
public class StaticJMeterGUIComponent
implements JMeterGUIComponent {
    private final String labelResource;
    private final ResourceBundle resourceBundle;
    private final Collection<String> groups;

    public StaticJMeterGUIComponent(Class<?> c, TestElementMetadata metadata) {
        this.labelResource = metadata.labelResource();
        String resourceBundle = metadata.resourceBundle();
        this.resourceBundle = !resourceBundle.isEmpty() ? ResourceBundle.getBundle(c.getName() + "Resources") : (this.labelResource.equals("displayName") ? ResourceBundle.getBundle(c.getName() + "Resources") : null);
        this.groups = this.getGroups(c, metadata);
    }

    private List<String> getGroups(Class<?> c, TestElementMetadata metadata) {
        String group;
        String[] groups = metadata.actionGroups();
        if (groups.length == 1 && groups[0].equals("")) {
            return null;
        }
        if (groups.length != 0) {
            return Collections.unmodifiableList(Arrays.asList(groups));
        }
        if (Assertion.class.isAssignableFrom(c) || AbstractAssertionGui.class.isAssignableFrom(c)) {
            group = "menu_assertions";
        } else if (ConfigElement.class.isAssignableFrom(c) || AbstractConfigGui.class.isAssignableFrom(c)) {
            group = "menu_config_element";
        } else if (Controller.class.isAssignableFrom(c) || AbstractControllerGui.class.isAssignableFrom(c)) {
            group = "menu_logic_controller";
        } else if (Visualizer.class.isAssignableFrom(c) || AbstractListenerGui.class.isAssignableFrom(c)) {
            group = "menu_listener";
        } else if (PostProcessor.class.isAssignableFrom(c) || AbstractPostProcessorGui.class.isAssignableFrom(c)) {
            group = "menu_post_processors";
        } else if (PreProcessor.class.isAssignableFrom(c) || AbstractPreProcessorGui.class.isAssignableFrom(c)) {
            group = "menu_pre_processors";
        } else if (Sampler.class.isAssignableFrom(c) || AbstractSamplerGui.class.isAssignableFrom(c)) {
            group = "menu_generative_controller";
        } else if (Timer.class.isAssignableFrom(c) || AbstractTimerGui.class.isAssignableFrom(c)) {
            group = "menu_timer";
        } else if (ThreadGroup.class.isAssignableFrom(c) || AbstractThreadGroupGui.class.isAssignableFrom(c)) {
            group = "menu_threads";
        } else {
            throw new IllegalArgumentException("Unknown group for class " + c);
        }
        return Collections.singletonList(group);
    }

    @Override
    public String getLabelResource() {
        return this.labelResource;
    }

    @Override
    public String getStaticLabel() {
        String labelResource = this.getLabelResource();
        if (this.resourceBundle == null) {
            return JMeterUtils.getResString(labelResource);
        }
        return this.resourceBundle.getString(labelResource);
    }

    @Override
    public Collection<String> getMenuCategories() {
        return this.groups;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDocAnchor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TestElement createTestElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyTestElement(TestElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JPopupMenu createPopupMenu() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void configure(TestElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearGui() {
        throw new UnsupportedOperationException();
    }
}

