/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.Month;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.hamcrest.Description;

public class IsMonth<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, Month> converter;
    private final TemporalProvider<Month> expected;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsMonth(TemporalConverter<T, Month> converter, TemporalProvider<Month> expected, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsMonth(TemporalConverter<T, Month> converter, TemporalProvider<Month> expected) {
        this(converter, expected, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        Month actualValue;
        Month expectedValue = this.expected.apply(this.zone);
        if (!expectedValue.equals(actualValue = this.converter.apply(actual, this.zone))) {
            mismatchDescription.appendText("the date has the month " + this.describe(actualValue));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the month " + this.describe(this.expected.apply(this.zone)));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsMonth<T>(this.converter, this.expected, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsMonth<T>(this.converter, this.expected, this.zone, locale);
    }

    private String describe(Month actualValue) {
        return actualValue.getDisplayName(TextStyle.FULL, this.locale);
    }
}

