/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Factory;

public abstract class LocalDateTimeMatchers {
    public static TemporalMatcher<LocalDateTime> after(LocalDateTime date) {
        return new IsAfter<LocalDateTime, LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return LocalDateTimeMatchers.after(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static TemporalMatcher<LocalDateTime> before(LocalDateTime date) {
        return new IsBefore<LocalDateTime, LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return LocalDateTimeMatchers.before(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static TemporalMatcher<LocalDateTime> sameDay(LocalDateTime date) {
        return new IsSameDay<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<LocalDateTime> isDay(LocalDate date) {
        return new IsSameDay<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<LocalDateTime> isDay(int year, Month month, int dayOfMonth) {
        return LocalDateTimeMatchers.isDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<LocalDateTime> sameInstant(LocalDateTime date) {
        return new IsSame<LocalDateTime, LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        return LocalDateTimeMatchers.sameInstant(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanos));
    }

    public static TemporalMatcher<LocalDateTime> sameOrBefore(LocalDateTime date) {
        return new IsSameOrBefore<LocalDateTime, LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    @Factory
    public static TemporalMatcher<LocalDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second) {
        return LocalDateTimeMatchers.sameOrBefore(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    public static TemporalMatcher<LocalDateTime> sameOrAfter(LocalDateTime date) {
        return new IsSameOrAfter<LocalDateTime, LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second) {
        return LocalDateTimeMatchers.sameOrAfter(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    public static TemporalMatcher<LocalDateTime> sameMonthOfYear(LocalDateTime date) {
        return new IsMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<LocalDateTime> sameDayOfMonth(LocalDateTime date) {
        return new IsDayOfMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<LocalDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<LocalDateTime> sameYear(LocalDateTime date) {
        return new IsYear<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<LocalDateTime> isYear(int year) {
        return new IsYear<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_YEAR, TemporalProviders.year(year));
    }

    public static TemporalMatcher<LocalDateTime> within(long period, ChronoUnit unit, LocalDateTime date) {
        return new IsWithin<LocalDateTime, LocalDateTime>(Interval.of(period, unit), TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos) {
        return LocalDateTimeMatchers.within(period, unit, LocalDateTime.of(year, month, dayofMonth, hour, minute, second, nanos));
    }

    public static TemporalMatcher<LocalDateTime> isYesterday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now().minusDays(1L));
    }

    public static TemporalMatcher<LocalDateTime> isToday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now());
    }

    public static TemporalMatcher<LocalDateTime> isTomorrow() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now(ZoneId.systemDefault()).plusDays(1L));
    }

    public static TemporalMatcher<LocalDateTime> sameDayOfWeek(LocalDateTime date) {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static TemporalMatcher<LocalDateTime> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<LocalDateTime> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<LocalDateTime> isMonday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<LocalDateTime> isTuesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<LocalDateTime> isWednesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<LocalDateTime> isThursday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<LocalDateTime> isFriday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<LocalDateTime> isSaturday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<LocalDateTime> isSunday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<LocalDateTime> isWeekday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<LocalDateTime> isWeekend() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<LocalDateTime> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, field);
    }

    public static TemporalMatcher<LocalDateTime> isLastDayOfMonth() {
        return new IsLastDayOfMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME);
    }

    public static TemporalMatcher<LocalDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_LOCALDATETIME, field);
    }

    public static TemporalMatcher<LocalDateTime> isMonth(Month month) {
        return new IsMonth<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<LocalDateTime> isJanuary() {
        return LocalDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<LocalDateTime> isFebruary() {
        return LocalDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<LocalDateTime> isMarch() {
        return LocalDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<LocalDateTime> isApril() {
        return LocalDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<LocalDateTime> isMay() {
        return LocalDateTimeMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<LocalDateTime> isJune() {
        return LocalDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<LocalDateTime> isJuly() {
        return LocalDateTimeMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<LocalDateTime> isAugust() {
        return LocalDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<LocalDateTime> isSeptember() {
        return LocalDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<LocalDateTime> isOctober() {
        return LocalDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<LocalDateTime> isNovember() {
        return LocalDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<LocalDateTime> isDecember() {
        return LocalDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<LocalDateTime> isLeapYear() {
        return new IsLeapYear<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_YEAR);
    }

    public static TemporalMatcher<LocalDateTime> isHour(int hour) {
        return new IsHour<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static TemporalMatcher<LocalDateTime> sameHourOfDay(LocalDateTime date) {
        return new IsHour<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_HOUR, TemporalProviders.hour(date));
    }

    public static TemporalMatcher<LocalDateTime> isMinute(int minute) {
        return new IsMinute<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_MINUTE, TemporalProviders.minute(minute));
    }

    public static TemporalMatcher<LocalDateTime> sameMinuteOfHour(LocalDateTime date) {
        return new IsMinute<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_MINUTE, TemporalProviders.minute(date));
    }

    public static TemporalMatcher<LocalDateTime> isSecond(int second) {
        return new IsSecond<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_SECOND, TemporalProviders.second(second));
    }

    public static TemporalMatcher<LocalDateTime> sameSecondOfMinute(LocalDateTime date) {
        return new IsSecond<LocalDateTime>(TemporalConverters.LOCALDATETIME_AS_SECOND, TemporalProviders.second(date));
    }
}

