/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.vis.svg.SvgPathData;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import jetbrains.datalore.vis.svg.SvgPathElement;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017JU\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "()V", "contentRect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getContentRect", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myPointerBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "myTextBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "buildComponent", "", "setPosition", "tooltipCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "pointerCoord", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "setPosition$plot_builder", "update", "fillColor", "Ljetbrains/datalore/base/values/Color;", "textColor", "borderColor", "strokeWidth", "", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "style", "", "rotate", "", "tooltipMinWidth", "(Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;DLjava/util/List;Ljava/lang/String;ZLjava/lang/Double;)V", "Orientation", "PointerBox", "PointerDirection", "TextBox", "plot-builder"})
public final class TooltipBox
extends SvgComponent {
    @NotNull
    private final PointerBox myPointerBox = new PointerBox();
    @NotNull
    private final TextBox myTextBox = new TextBox();

    @NotNull
    public final DoubleRectangle getContentRect() {
        return DoubleRectangle.Companion.span(DoubleVector.Companion.getZERO(), this.myTextBox.getDimension());
    }

    @Nullable
    public final PointerDirection getPointerDirection$plot_builder() {
        return this.myPointerBox.getPointerDirection$plot_builder();
    }

    @Override
    protected void buildComponent() {
        this.add(this.myPointerBox);
        this.add(this.myTextBox);
    }

    public final void update(@NotNull Color fillColor, @NotNull Color textColor2, @NotNull Color borderColor, double strokeWidth, @NotNull List<TooltipSpec.Line> lines, @NotNull String style, boolean rotate, @Nullable Double tooltipMinWidth) {
        Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
        Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.addClassName(style);
        this.myTextBox.update$plot_builder(lines, Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR(), textColor2, tooltipMinWidth, rotate);
        this.myPointerBox.updateStyle$plot_builder(fillColor, borderColor, strokeWidth);
    }

    public static /* synthetic */ void update$default(TooltipBox tooltipBox, Color color, Color color2, Color color3, double d, List list2, String string, boolean bl, Double d2, int n, Object object) {
        if ((n & 0x80) != 0) {
            d2 = null;
        }
        tooltipBox.update(color, color2, color3, d, list2, string, bl, d2);
    }

    public final void setPosition$plot_builder(@NotNull DoubleVector tooltipCoord, @NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
        Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.myPointerBox.update$plot_builder(pointerCoord.subtract(tooltipCoord), orientation);
        this.moveTo(tooltipCoord.getX(), tooltipCoord.getY());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "", "(Ljava/lang/String;I)V", "VERTICAL", "HORIZONTAL", "plot-builder"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation VERTICAL = new Orientation();
        public static final /* enum */ Orientation HORIZONTAL = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String value) {
            return Enum.valueOf(Orientation.class, value);
        }

        static {
            $VALUES = orientationArray = new Orientation[]{Orientation.VERTICAL, Orientation.HORIZONTAL};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "UP", "DOWN", "plot-builder"})
    public static final class PointerDirection
    extends Enum<PointerDirection> {
        public static final /* enum */ PointerDirection LEFT = new PointerDirection();
        public static final /* enum */ PointerDirection RIGHT = new PointerDirection();
        public static final /* enum */ PointerDirection UP = new PointerDirection();
        public static final /* enum */ PointerDirection DOWN = new PointerDirection();
        private static final /* synthetic */ PointerDirection[] $VALUES;

        public static PointerDirection[] values() {
            return (PointerDirection[])$VALUES.clone();
        }

        public static PointerDirection valueOf(String value) {
            return Enum.valueOf(PointerDirection.class, value);
        }

        static {
            $VALUES = pointerDirectionArray = new PointerDirection[]{PointerDirection.LEFT, PointerDirection.RIGHT, PointerDirection.UP, PointerDirection.DOWN};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J%\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "myPointerPath", "Ljetbrains/datalore/vis/svg/SvgPathElement;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "setPointerDirection$plot_builder", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;)V", "buildComponent", "", "calculatePointerFootingIndent", "", "sideLength", "update", "pointerCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "update$plot_builder", "updateStyle", "fillColor", "Ljetbrains/datalore/base/values/Color;", "borderColor", "strokeWidth", "updateStyle$plot_builder", "plot-builder"})
    private final class PointerBox
    extends SvgComponent {
        @NotNull
        private final SvgPathElement myPointerPath;
        @Nullable
        private PointerDirection pointerDirection;

        public PointerBox() {
            Intrinsics.checkNotNullParameter((Object)TooltipBox.this, (String)"this$0");
            this.myPointerPath = new SvgPathElement();
        }

        @Nullable
        public final PointerDirection getPointerDirection$plot_builder() {
            return this.pointerDirection;
        }

        public final void setPointerDirection$plot_builder(@Nullable PointerDirection pointerDirection) {
            this.pointerDirection = pointerDirection;
        }

        @Override
        protected void buildComponent() {
            this.add(this.myPointerPath);
        }

        public final void updateStyle$plot_builder(@NotNull Color fillColor, @NotNull Color borderColor, double strokeWidth) {
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
            SvgPathElement svgPathElement = this.myPointerPath;
            boolean bl = false;
            boolean bl2 = false;
            SvgPathElement $this$updateStyle_u24lambda_u2d0 = svgPathElement;
            boolean bl3 = false;
            $this$updateStyle_u24lambda_u2d0.strokeColor().set(borderColor);
            $this$updateStyle_u24lambda_u2d0.strokeOpacity().set(strokeWidth);
            $this$updateStyle_u24lambda_u2d0.fillColor().set(fillColor);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
            void $this$update_u24lambda_u2d2;
            PointerDirection pointerDirection;
            Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Orientation orientation2 = orientation;
            int n = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
            switch (n) {
                case 1: {
                    if (pointerCoord.getX() < TooltipBox.this.getContentRect().getLeft()) {
                        pointerDirection = PointerDirection.LEFT;
                        break;
                    }
                    if (pointerCoord.getX() > TooltipBox.this.getContentRect().getRight()) {
                        pointerDirection = PointerDirection.RIGHT;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                case 2: {
                    if (pointerCoord.getY() > TooltipBox.this.getContentRect().getBottom()) {
                        pointerDirection = PointerDirection.DOWN;
                        break;
                    }
                    if (pointerCoord.getY() < TooltipBox.this.getContentRect().getTop()) {
                        pointerDirection = PointerDirection.UP;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.pointerDirection = pointerDirection;
            double vertFootingIndent = -this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getHeight());
            double horFootingIndent = this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getWidth());
            SvgPathDataBuilder svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            TooltipBox tooltipBox = TooltipBox.this;
            boolean bl = false;
            boolean bl2 = false;
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder;
            Property<SvgPathData> property2 = this.myPointerPath.d();
            boolean bl3 = false;
            DoubleRectangle doubleRectangle = tooltipBox.getContentRect();
            boolean bl4 = false;
            boolean bl5 = false;
            DoubleRectangle $this$update_u24lambda_u2d2_u24lambda_u2d1 = doubleRectangle;
            boolean bl6 = false;
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom() + vertFootingIndent, false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.RIGHT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop() - vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight() - horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.UP);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft() + horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop() - vertFootingIndent, false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.LEFT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom() + vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft() + horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.DOWN);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight() - horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            Unit unit = Unit.INSTANCE;
            property2.set(svgPathDataBuilder.build());
        }

        private final double calculatePointerFootingIndent(double sideLength) {
            double d = sideLength * 0.4;
            double d2 = 12.0;
            boolean bl = false;
            double footingLength = Math.min(d, d2);
            return (sideLength - footingLength) / (double)2;
        }

        private static final void update$lambda-2$lambda-1$lineToIf(SvgPathDataBuilder $this_apply, DoubleVector p, boolean isTrue) {
            if (isTrue) {
                $this_apply.lineTo(p);
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                nArray[Orientation.HORIZONTAL.ordinal()] = 1;
                nArray[Orientation.VERTICAL.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J?\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "dimension", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getDimension", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "myContent", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "myLines", "buildComponent", "", "update", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "labelTextColor", "Ljetbrains/datalore/base/values/Color;", "valueTextColor", "tooltipMinWidth", "", "rotate", "", "update$plot_builder", "(Ljava/util/List;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;Ljava/lang/Double;Z)V", "plot-builder"})
    private final class TextBox
    extends SvgComponent {
        @NotNull
        private final SvgSvgElement myLines;
        @NotNull
        private final SvgSvgElement myContent;

        /*
         * WARNING - void declaration
         */
        public TextBox() {
            void $this$myContent_u24lambda_u2d1;
            SvgSvgElement $this$myLines_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)TooltipBox.this, (String)"this$0");
            SvgSvgElement svgSvgElement = new SvgSvgElement();
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement svgSvgElement2 = svgSvgElement;
            TextBox textBox = this;
            boolean bl3 = false;
            $this$myLines_u24lambda_u2d0.x().set(0.0);
            $this$myLines_u24lambda_u2d0.y().set(0.0);
            $this$myLines_u24lambda_u2d0.width().set(0.0);
            $this$myLines_u24lambda_u2d0.height().set(0.0);
            Unit unit = Unit.INSTANCE;
            textBox.myLines = svgSvgElement;
            svgSvgElement = new SvgSvgElement();
            bl = false;
            bl2 = false;
            $this$myLines_u24lambda_u2d0 = svgSvgElement;
            textBox = this;
            boolean bl4 = false;
            $this$myContent_u24lambda_u2d1.x().set(0.0);
            $this$myContent_u24lambda_u2d1.y().set(0.0);
            $this$myContent_u24lambda_u2d1.width().set(0.0);
            $this$myContent_u24lambda_u2d1.height().set(0.0);
            unit = Unit.INSTANCE;
            textBox.myContent = svgSvgElement;
        }

        @NotNull
        public final DoubleVector getDimension() {
            SvgSvgElement svgSvgElement = this.myContent;
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement $this$_get_dimension__u24lambda_u2d2 = svgSvgElement;
            boolean bl3 = false;
            Object ValueT = $this$_get_dimension__u24lambda_u2d2.width().get();
            Intrinsics.checkNotNull(ValueT);
            double d = ((Number)ValueT).doubleValue();
            Object ValueT2 = $this$_get_dimension__u24lambda_u2d2.height().get();
            Intrinsics.checkNotNull(ValueT2);
            return new DoubleVector(d, ((Number)ValueT2).doubleValue());
        }

        @Override
        protected void buildComponent() {
            this.add(this.myContent);
            this.myContent.children().add(this.myLines);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull List<TooltipSpec.Line> lines, @NotNull Color labelTextColor, @NotNull Color valueTextColor, @Nullable Double tooltipMinWidth, boolean rotate) {
            DoubleVector doubleVector;
            void $this$fold$iv;
            boolean bl;
            Object object;
            DoubleRectangle labelBBox;
            Pair $dstr$bBoxes$width;
            void $this$mapTo$iv$iv;
            Object object2;
            double valueWidth;
            DoubleVector doubleVector2;
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            Double d;
            Iterator $this$flatMapTo$iv$iv;
            double d2;
            Object $dstr$labelBbox;
            double line22;
            double component222;
            Object labelComponent;
            Iterable $this$mapTo$iv$iv4;
            Object object3;
            boolean bl2;
            Object p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv5;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)labelTextColor, (String)"labelTextColor");
            Intrinsics.checkNotNullParameter((Object)valueTextColor, (String)"valueTextColor");
            Iterable $this$map$iv = lines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                TextLabel textLabel;
                Iterator line3;
                TooltipSpec.Line line4 = (TooltipSpec.Line)item$iv$iv;
                collection = destination$iv$iv322;
                boolean bl3 = false;
                String string = ((TooltipSpec.Line)((Object)line3)).getLabel();
                if (string == null) {
                    textLabel = null;
                } else {
                    TextLabel textLabel2;
                    String string2 = string;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    p0 = string2;
                    bl2 = false;
                    textLabel = textLabel2 = new TextLabel((String)p0);
                }
                TextLabel textLabel3 = new TextLabel(((TooltipSpec.Line)((Object)line3)).getValue());
                TextLabel textLabel4 = textLabel;
                object3 = new Pair(textLabel4, (Object)textLabel3);
                collection.add(object3);
            }
            List components = (List)destination$iv$iv322;
            Iterable $this$onEach$iv = components;
            boolean $i$f$onEach = false;
            $this$mapTo$iv$iv5 = $this$onEach$iv;
            boolean destination$iv$iv322 = false;
            $i$f$mapTo = false;
            Iterable $this$apply$iv = $this$mapTo$iv$iv5;
            boolean bl6 = false;
            for (Object element$iv : $this$apply$iv) {
                Pair $dstr$labelComponent$_u24__u24 = (Pair)element$iv;
                boolean bl7 = false;
                TextLabel labelComponent2 = (TextLabel)$dstr$labelComponent$_u24__u24.component1();
                if (labelComponent2 == null) continue;
                labelComponent2.textColor().set(labelTextColor);
                this.myLines.children().add(labelComponent2.getRootGroup());
            }
            $this$onEach$iv = components;
            $i$f$onEach = false;
            $this$mapTo$iv$iv5 = $this$onEach$iv;
            destination$iv$iv322 = false;
            $i$f$mapTo = false;
            $this$apply$iv = $this$mapTo$iv$iv5;
            bl6 = false;
            for (Object element$iv : $this$apply$iv) {
                Pair $dstr$_u24__u24$valueComponent = (Pair)element$iv;
                boolean bl8 = false;
                TextLabel valueComponent = (TextLabel)$dstr$_u24__u24$valueComponent.component2();
                valueComponent.textColor().set(valueTextColor);
                this.myLines.children().add(valueComponent.getRootGroup());
            }
            Iterable $this$map$iv2 = CollectionsKt.zip((Iterable)lines, (Iterable)components);
            boolean $i$f$map2 = false;
            Iterable destination$iv$iv322 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                Pair component222;
                void $dstr$line$component;
                Pair element$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                TooltipSpec.Line line22 = (TooltipSpec.Line)$dstr$line$component.component1();
                Pair pair2 = component222 = (Pair)$dstr$line$component.component2();
                labelComponent = (TextLabel)pair2.component1();
                TextLabel valueComponent = (TextLabel)pair2.component2();
                object3 = new Pair((Object)TextBox.update$getBBox(line22.getLabel(), (TextLabel)labelComponent), (Object)TextBox.update$getBBox(line22.getValue(), valueComponent));
                collection.add(object3);
            }
            List rawBBoxes = (List)destination$iv$iv;
            $this$mapTo$iv$iv4 = rawBBoxes;
            boolean bl10 = false;
            Iterator $i$f$mapTo22 = $this$mapTo$iv$iv4.iterator();
            if (!$i$f$mapTo22.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            Pair $dstr$labelBbox2 = (Pair)$i$f$mapTo22.next();
            boolean bl11 = false;
            DoubleRectangle labelBbox = (DoubleRectangle)$dstr$labelBbox2.component1();
            DoubleRectangle bl9 = labelBbox;
            double d3 = component222 = bl9 == null ? 0.0 : (line22 = bl9.getWidth());
            while ($i$f$mapTo22.hasNext()) {
                double valueComponent;
                $dstr$labelBbox = (Pair)$i$f$mapTo22.next();
                $i$a$-maxOf-TooltipBox$TextBox$update$maxLabelWidth$1 = false;
                DoubleRectangle labelBbox22 = (DoubleRectangle)$dstr$labelBbox.component1();
                labelComponent = labelBbox22;
                d2 = labelComponent == null ? 0.0 : (valueComponent = ((DoubleRectangle)labelComponent).getWidth());
                boolean labelBbox22 = false;
                component222 = Math.max(component222, d2);
            }
            double maxLabelWidth = component222;
            Iterable $this$flatMap$iv = rawBBoxes;
            boolean $i$f$flatMap = false;
            $dstr$labelBbox = $this$flatMap$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator component222 = $this$flatMapTo$iv$iv.iterator();
            while (component222.hasNext()) {
                Object element$iv$iv = component222.next();
                Pair it = (Pair)element$iv$iv;
                boolean bl12 = false;
                Iterable list$iv$iv = CollectionsKt.filterNotNull((Iterable)TuplesKt.toList((Pair)it));
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv.iterator();
            if (!$this$flatMapTo$iv$iv.hasNext()) {
                d = null;
            } else {
                DoubleRectangle p02 = (DoubleRectangle)$this$flatMapTo$iv$iv.next();
                boolean bl13 = false;
                double component222 = p02.getHeight();
                while ($this$flatMapTo$iv$iv.hasNext()) {
                    p0 = (DoubleRectangle)$this$flatMapTo$iv$iv.next();
                    $i$a$-maxOfOrNull-TooltipBox$TextBox$update$defaultLineHeight$2 = false;
                    d2 = ((DoubleRectangle)p0).getHeight();
                    boolean bl14 = false;
                    component222 = Math.max(component222, d2);
                }
                d = component222;
            }
            $i$f$mapTo22 = d;
            double defaultLineHeight = $i$f$mapTo22 == null ? 13.0 : (Double)((Object)$i$f$mapTo22);
            Iterable $this$map$iv3 = lines;
            boolean $i$f$map3 = false;
            $this$flatMapTo$iv$iv = $this$map$iv3;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                double d4;
                void line5;
                p0 = (TooltipSpec.Line)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl15 = false;
                if (line5.getLabel() == null) {
                    d4 = 0.0;
                } else {
                    String string = line5.getLabel();
                    Intrinsics.checkNotNull((Object)string);
                    CharSequence charSequence = string;
                    bl2 = false;
                    d4 = charSequence.length() == 0 ? maxLabelWidth : maxLabelWidth + 8.0;
                }
                object3 = d4;
                collection.add(object3);
            }
            List labelWidths = (List)destination$iv$iv2;
            Iterable $this$map$iv4 = rawBBoxes;
            boolean $i$f$map4 = false;
            destination$iv$iv2 = $this$map$iv4;
            Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                double d5;
                void $dstr$_u24__u24$valueBBox;
                Pair bl15 = (Pair)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl16 = false;
                DoubleRectangle valueBBox = (DoubleRectangle)$dstr$_u24__u24$valueBBox.component2();
                DoubleRectangle doubleRectangle = valueBBox;
                object3 = doubleRectangle == null ? 0.0 : ((doubleVector2 = doubleRectangle.getDimension()) == null ? 0.0 : (d5 = doubleVector2.getX()));
                collection.add(object3);
            }
            List valueWidths = (List)destination$iv$iv4;
            List lineWidths = CollectionsKt.zip((Iterable)labelWidths, (Iterable)valueWidths);
            destination$iv$iv4 = lineWidths;
            $i$f$mapTo4 = false;
            Iterator<Object> item$iv$iv = destination$iv$iv4.iterator();
            if (!item$iv$iv.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            Object $dstr$labelWidth$valueWidth = (Pair)item$iv$iv.next();
            boolean bl17 = false;
            double labelWidth = ((Number)$dstr$labelWidth$valueWidth.component1()).doubleValue();
            double valueWidth2 = ((Number)$dstr$labelWidth$valueWidth.component2()).doubleValue();
            Double d6 = tooltipMinWidth;
            double d7 = d6 == null ? 0.0 : d6;
            double d8 = labelWidth + valueWidth2;
            boolean bl18 = false;
            double d9 = Math.max(d7, d8);
            while (item$iv$iv.hasNext()) {
                Pair $dstr$labelWidth$valueWidth2 = (Pair)item$iv$iv.next();
                $i$a$-maxOf-TooltipBox$TextBox$update$maxLineWidth$1 = false;
                double labelWidth2 = ((Number)$dstr$labelWidth$valueWidth2.component1()).doubleValue();
                valueWidth = ((Number)$dstr$labelWidth$valueWidth2.component2()).doubleValue();
                object2 = tooltipMinWidth;
                d8 = object2 == null ? 0.0 : (Double)object2;
                double d10 = labelWidth2 + valueWidth;
                boolean bl19 = false;
                labelWidth = Math.max(d8, d10);
                boolean bl20 = false;
                d9 = Math.max(d9, labelWidth);
            }
            double maxLineWidth = d9;
            Iterable $this$map$iv5 = CollectionsKt.zip((Iterable)rawBBoxes, (Iterable)lineWidths);
            boolean $i$f$map222 = false;
            $dstr$labelWidth$valueWidth = $this$map$iv5;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                Double d11;
                Object object4;
                Double d12;
                double d13;
                double d14;
                doubleVector2 = (Pair)item$iv$iv2;
                collection = destination$iv$iv5;
                boolean bl21 = false;
                Pair bBoxes = (Pair)$dstr$bBoxes$width.component1();
                Pair width2 = (Pair)$dstr$bBoxes$width.component2();
                Pair pair3 = bBoxes;
                labelBBox = (DoubleRectangle)pair3.component1();
                DoubleRectangle valueBBox = (DoubleRectangle)pair3.component2();
                Pair pair4 = width2;
                double labelWidth3 = ((Number)pair4.component1()).doubleValue();
                double valueWidth3 = ((Number)pair4.component2()).doubleValue();
                double d15 = labelWidth3;
                object = labelBBox;
                if (object == null) {
                    d14 = 0.0;
                } else {
                    void $this$update_u24lambda_u2d15_u24lambda_u2d13;
                    object2 = object;
                    boolean bl22 = false;
                    bl = false;
                    Object object5 = object2;
                    d13 = d15;
                    boolean bl23 = false;
                    d12 = $this$update_u24lambda_u2d15_u24lambda_u2d13.getHeight() + $this$update_u24lambda_u2d15_u24lambda_u2d13.getTop();
                    d15 = d13;
                    object4 = d12;
                    d14 = (Double)object4;
                }
                double d16 = d14;
                double d17 = d15;
                DoubleVector labelDimension = new DoubleVector(d17, d16);
                double d18 = valueWidth3;
                object2 = valueBBox;
                if (object2 == null) {
                    d11 = null;
                } else {
                    void $this$update_u24lambda_u2d15_u24lambda_u2d14;
                    Object object6 = object2;
                    bl = false;
                    boolean $this$update_u24lambda_u2d15_u24lambda_u2d13 = false;
                    Object bl23 = object6;
                    d13 = d18;
                    boolean bl24 = false;
                    d12 = $this$update_u24lambda_u2d15_u24lambda_u2d14.getHeight() + $this$update_u24lambda_u2d15_u24lambda_u2d14.getTop();
                    d18 = d13;
                    d11 = d12;
                }
                object4 = d11;
                double d19 = object4 == null ? (labelBBox == null ? defaultLineHeight : 0.0) : (Double)object4;
                double d20 = d18;
                DoubleVector valueDimension = new DoubleVector(d20, d19);
                object2 = labelBBox;
                object4 = object2 == null ? null : ((DoubleRectangle)object2).getOrigin();
                DoubleRectangle doubleRectangle = new DoubleRectangle((DoubleVector)(object4 == null ? DoubleVector.Companion.getZERO() : object4), labelDimension);
                object2 = valueBBox;
                object4 = object2 == null ? null : ((DoubleRectangle)object2).getOrigin();
                object3 = new Pair((Object)doubleRectangle, (Object)new DoubleRectangle((DoubleVector)(object4 == null ? DoubleVector.Companion.getZERO() : object4), valueDimension));
                collection.add(object3);
            }
            List lineBBoxes = (List)destination$iv$iv5;
            Iterable $i$f$map222 = CollectionsKt.zip((Iterable)components, (Iterable)lineBBoxes);
            DoubleVector initial$iv = DoubleVector.Companion.getZERO();
            boolean $i$f$fold = false;
            DoubleVector accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Unit unit;
                void $dstr$lineInfo$bBoxes;
                $dstr$bBoxes$width = (Pair)element$iv;
                DoubleVector textDimension = accumulator$iv;
                boolean bl25 = false;
                Pair lineInfo = (Pair)$dstr$lineInfo$bBoxes.component1();
                Pair bBoxes = (Pair)$dstr$lineInfo$bBoxes.component2();
                labelBBox = lineInfo;
                TextLabel labelComponent3 = (TextLabel)labelBBox.component1();
                TextLabel valueComponent = (TextLabel)labelBBox.component2();
                Pair labelWidth3 = bBoxes;
                DoubleRectangle labelBBox2 = (DoubleRectangle)labelWidth3.component1();
                DoubleRectangle valueBBox = (DoubleRectangle)labelWidth3.component2();
                valueWidth = valueBBox.getTop();
                double d21 = labelBBox2.getTop();
                bl = false;
                double yPosition = textDimension.getY() - Math.min(valueWidth, d21);
                valueComponent.y().set(yPosition);
                TextLabel textLabel = labelComponent3;
                if (textLabel == null) {
                    unit = null;
                } else {
                    Property<Double> property2 = textLabel.y();
                    if (property2 == null) {
                        unit = null;
                    } else {
                        property2.set(yPosition);
                        unit = Unit.INSTANCE;
                    }
                }
                if (labelComponent3 != null && labelBBox2.getDimension().getX() > 0.0) {
                    labelComponent3.x().set(-labelBBox2.getLeft());
                    valueComponent.x().set(maxLineWidth);
                    valueComponent.setHorizontalAnchor(TextLabel.HorizontalAnchor.RIGHT);
                } else if (valueBBox.getDimension().getX() == maxLineWidth) {
                    valueComponent.x().set(-valueBBox.getLeft());
                } else {
                    valueComponent.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                    valueComponent.x().set(maxLineWidth / (double)2);
                }
                Object ValueT = valueComponent.y().get();
                Intrinsics.checkNotNull(ValueT);
                valueWidth = valueBBox.getHeight();
                d21 = labelBBox2.getHeight();
                bl = false;
                accumulator$iv = new DoubleVector(maxLineWidth, ((Number)ValueT).doubleValue() + Math.max(valueWidth, d21) + 3.0);
            }
            Object object7 = accumulator$iv;
            boolean bl26 = false;
            boolean bl27 = false;
            DoubleVector textSize = object7;
            boolean bl28 = false;
            if (rotate) {
                void $this$onEach$iv2;
                Iterable element$iv = components;
                boolean $i$f$onEach2 = false;
                void var28_105 = $this$onEach$iv2;
                boolean bl29 = false;
                boolean bl30 = false;
                void $this$apply$iv2 = var28_105;
                $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                for (Object element$iv2 : $this$apply$iv2) {
                    Unit unit;
                    Unit unit2;
                    Unit unit3;
                    Pair $dstr$labelComponent$valueComponent = (Pair)element$iv2;
                    boolean bl31 = false;
                    TextLabel labelComponent4 = (TextLabel)$dstr$labelComponent$valueComponent.component1();
                    TextLabel valueComponent = (TextLabel)$dstr$labelComponent$valueComponent.component2();
                    object = labelComponent4;
                    if (object == null) {
                        unit3 = null;
                    } else {
                        ((SvgComponent)object).rotate(90.0);
                        unit3 = Unit.INSTANCE;
                    }
                    object = labelComponent4;
                    if (object == null) {
                        unit2 = null;
                    } else {
                        Property<Double> property3 = ((TextLabel)object).y();
                        if (property3 == null) {
                            unit2 = null;
                        } else {
                            Object ValueT = labelComponent4.y().get();
                            Intrinsics.checkNotNull(ValueT);
                            property3.set(-((Number)ValueT).doubleValue());
                            unit2 = Unit.INSTANCE;
                        }
                    }
                    object = labelComponent4;
                    if (object == null) {
                        unit = null;
                    } else {
                        ((TextLabel)object).setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                        unit = Unit.INSTANCE;
                    }
                    Property<Double> property4 = valueComponent.y();
                    Object ValueT = valueComponent.y().get();
                    Intrinsics.checkNotNull(ValueT);
                    property4.set(-((Number)ValueT).doubleValue());
                    valueComponent.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                    valueComponent.rotate(90.0);
                }
                doubleVector = textSize.flip();
            } else {
                doubleVector = textSize.subtract(new DoubleVector(0.0, 3.0));
            }
            DoubleVector textSize2 = doubleVector;
            object7 = this.myLines;
            bl26 = false;
            bl27 = false;
            Object $this$update_u24lambda_u2d19 = object7;
            boolean bl32 = false;
            ((SvgSvgElement)$this$update_u24lambda_u2d19).x().set(rotate ? 0.0 : 4.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d19).y().set(4.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d19).width().set(textSize2.getX() + 8.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d19).height().set(textSize2.getY());
            object7 = this.myContent;
            bl26 = false;
            bl27 = false;
            Object $this$update_u24lambda_u2d20 = object7;
            boolean bl33 = false;
            ((SvgSvgElement)$this$update_u24lambda_u2d20).width().set(textSize2.getX() + 8.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d20).height().set(textSize2.getY() + 8.0);
        }

        private static final DoubleRectangle update$getBBox(String text, TextLabel textLabel) {
            block3: {
                block2: {
                    if (textLabel == null) break block2;
                    CharSequence charSequence = text;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block3;
                }
                return null;
            }
            return textLabel.getRootGroup().getBBox();
        }
    }
}

