/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.DiscreteTransform;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.AbstractScale;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001 B5\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t\u00a2\u0006\u0002\u0010\u000bB\u0015\b\u0012\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/base/scale/DiscreteScale;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale;", "", "name", "", "domainValues", "", "mapper", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)V", "b", "Ljetbrains/datalore/plot/base/scale/DiscreteScale$MyBuilder;", "(Ljetbrains/datalore/plot/base/scale/DiscreteScale$MyBuilder;)V", "discreteTransform", "Ljetbrains/datalore/plot/base/DiscreteTransform;", "transform", "Ljetbrains/datalore/plot/base/Transform;", "getTransform", "()Ljetbrains/datalore/plot/base/Transform;", "getBreaksGenerator", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "getBreaksIntern", "", "getLabelsIntern", "hasDomainLimits", "", "isInDomainLimits", "v", "with", "Ljetbrains/datalore/plot/base/Scale$Builder;", "MyBuilder", "plot-base-portable"})
public final class DiscreteScale<T>
extends AbstractScale<Object, T> {
    @NotNull
    private final DiscreteTransform discreteTransform;

    @Override
    @NotNull
    public Transform getTransform() {
        return this.discreteTransform;
    }

    public DiscreteScale(@NotNull String name, @NotNull Collection<? extends Object> domainValues, @NotNull Function1<? super Double, ? extends T> mapper2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        super(name, mapper2, CollectionsKt.toList((Iterable)domainValues));
        this.discreteTransform = new DiscreteTransform(domainValues, CollectionsKt.emptyList());
        this.setMultiplicativeExpand(0.0);
        this.setAdditiveExpand(0.6);
    }

    private DiscreteScale(MyBuilder<T> b) {
        super((AbstractScale.AbstractBuilder)b);
        this.discreteTransform = new DiscreteTransform(b.getMyDomainValues$plot_base_portable(), b.getMyDomainLimits$plot_base_portable());
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        throw new IllegalStateException("No breaks generator for discrete scale '" + this.getName() + '\'');
    }

    @Override
    public boolean hasDomainLimits() {
        return this.discreteTransform.hasDomainLimits();
    }

    @Override
    public boolean isInDomainLimits(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.discreteTransform.isInDomain(v);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Object> getBreaksIntern() {
        List list2;
        if (!this.hasDomainLimits()) {
            list2 = super.getBreaksIntern();
        } else {
            void $this$filterTo$iv$iv;
            Set breaksSet = CollectionsKt.toSet((Iterable)super.getBreaksIntern());
            Iterable $this$filter$iv = this.discreteTransform.getDomainLimits();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!breaksSet.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getLabelsIntern() {
        List list2;
        List labels = super.getLabelsIntern();
        if (!this.hasDomainLimits() || labels.isEmpty()) {
            list2 = labels;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String string;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            List<Object> breaks = super.getBreaksIntern();
            Iterable $this$mapIndexed$iv = breaks;
            boolean $i$f$mapIndexed22 = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl2 = false;
                string = labels.get((int)(i % labels.size()));
                collection.add(string);
            }
            List breakLabels = (List)destination$iv$iv;
            Map labelByBreak = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)breaks, (Iterable)breakLabels));
            Iterable $i$f$mapIndexed22 = this.discreteTransform.getDomainLimits();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!labelByBreak.containsKey(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                Object it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                string = (String)MapsKt.getValue((Map)labelByBreak, it);
                collection.add(string);
            }
            list2 = (List)destination$iv$iv2;
        }
        return list2;
    }

    @Override
    @NotNull
    public Scale.Builder<T> with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ DiscreteScale(MyBuilder b, DefaultConstructorMarker $constructor_marker) {
        this(b);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u001cH\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/scale/DiscreteScale$MyBuilder;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Ljetbrains/datalore/plot/base/scale/DiscreteScale;", "(Ljetbrains/datalore/plot/base/scale/DiscreteScale;)V", "myDomainLimits", "", "getMyDomainLimits$plot_base_portable", "()Ljava/util/List;", "setMyDomainLimits$plot_base_portable", "(Ljava/util/List;)V", "myDomainValues", "", "getMyDomainValues$plot_base_portable", "()Ljava/util/Collection;", "breaksGenerator", "Ljetbrains/datalore/plot/base/Scale$Builder;", "v", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "build", "Ljetbrains/datalore/plot/base/Scale;", "continuousTransform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "limits", "domainValues", "lowerLimit", "", "upperLimit", "plot-base-portable"})
    private static final class MyBuilder<T>
    extends AbstractScale.AbstractBuilder<Object, T> {
        @NotNull
        private final Collection<Object> myDomainValues;
        @NotNull
        private List<? extends Object> myDomainLimits;

        public MyBuilder(@NotNull DiscreteScale<T> scale) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            super((AbstractScale)scale);
            this.myDomainValues = ((DiscreteScale)scale).discreteTransform.getDomainValues();
            this.myDomainLimits = ((DiscreteScale)scale).discreteTransform.getDomainLimits();
        }

        @NotNull
        public final Collection<Object> getMyDomainValues$plot_base_portable() {
            return this.myDomainValues;
        }

        @NotNull
        public final List<Object> getMyDomainLimits$plot_base_portable() {
            return this.myDomainLimits;
        }

        public final void setMyDomainLimits$plot_base_portable(@NotNull List<? extends Object> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.myDomainLimits = list2;
        }

        @Override
        @NotNull
        public Scale.Builder<T> breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            throw new IllegalStateException("Not applicable to scale with discrete domain");
        }

        @Override
        @NotNull
        public Scale.Builder<T> lowerLimit(double v) {
            throw new IllegalStateException("Not applicable to scale with discrete domain");
        }

        @Override
        @NotNull
        public Scale.Builder<T> upperLimit(double v) {
            throw new IllegalStateException("Not applicable to scale with discrete domain");
        }

        @Override
        @NotNull
        public Scale.Builder<T> limits(@NotNull List<? extends Object> domainValues) {
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            this.myDomainLimits = domainValues;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder<T> continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this;
        }

        @Override
        @NotNull
        public Scale<T> build() {
            return new DiscreteScale(this, null);
        }
    }
}

