/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.util.Comparator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlphaNumericComparator<T>
implements Comparator<T> {
    private Function<T, String> converter;
    private static final Pattern parts = Pattern.compile("(\\D*)(\\d*)");
    private static final int ALPHA_PART = 1;
    private static final int NUM_PART = 2;

    public AlphaNumericComparator(Function<T, String> converter) {
        this.converter = converter;
    }

    @Override
    public int compare(T o1, T o2) {
        Matcher m1 = parts.matcher(this.converter.apply(o1));
        Matcher m2 = parts.matcher(this.converter.apply(o2));
        while (m1.find() && m2.find()) {
            int lengthNumber2;
            int compareCharGroup = m1.group(1).compareTo(m2.group(1));
            if (compareCharGroup != 0) {
                return compareCharGroup;
            }
            String numberPart1 = m1.group(2);
            String numberPart2 = m2.group(2);
            if (numberPart1.isEmpty() || numberPart2.isEmpty()) {
                return this.compareOneEmptyPart(numberPart1, numberPart2);
            }
            String nonZeroNumberPart1 = this.trimLeadingZeroes(numberPart1);
            String nonZeroNumberPart2 = this.trimLeadingZeroes(numberPart2);
            int lengthNumber1 = nonZeroNumberPart1.length();
            if (lengthNumber1 != (lengthNumber2 = nonZeroNumberPart2.length())) {
                if (lengthNumber1 < lengthNumber2) {
                    return -1;
                }
                return 1;
            }
            int compareNumber = nonZeroNumberPart1.compareTo(nonZeroNumberPart2);
            if (compareNumber == 0) continue;
            return compareNumber;
        }
        if (m1.hitEnd() && m2.hitEnd()) {
            return 0;
        }
        if (m1.hitEnd()) {
            return -1;
        }
        return 1;
    }

    private int compareOneEmptyPart(String numberPart1, String numberPart2) {
        if (numberPart1.isEmpty()) {
            if (numberPart2.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (numberPart2.isEmpty()) {
            return 1;
        }
        throw new IllegalArgumentException("At least one of the parameters have to be empty");
    }

    private String trimLeadingZeroes(String numberPart) {
        int length = numberPart.length();
        for (int i = 0; i < length; ++i) {
            if (numberPart.charAt(i) == '0') continue;
            return numberPart.substring(i);
        }
        return "";
    }
}

