/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.report.processor.DescriptiveStatisticsFactory;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.ErrorMetric;
import org.apache.jmeter.visualizers.backend.WindowMode;

public class SamplerMetric {
    private static final int SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault((String)"backend_metrics_window", (int)100);
    private static final int LARGE_SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault((String)"backend_metrics_large_window", (int)5000);
    private static volatile WindowMode globalWindowMode = WindowMode.get();
    private DescriptiveStatistics okResponsesStats = DescriptiveStatisticsFactory.createDescriptiveStatistics((int)LARGE_SLIDING_WINDOW_SIZE);
    private DescriptiveStatistics koResponsesStats = DescriptiveStatisticsFactory.createDescriptiveStatistics((int)LARGE_SLIDING_WINDOW_SIZE);
    private DescriptiveStatistics allResponsesStats = DescriptiveStatisticsFactory.createDescriptiveStatistics((int)LARGE_SLIDING_WINDOW_SIZE);
    private List<DescriptiveStatistics> windowedStats = this.initWindowedStats();
    private DescriptiveStatistics pctResponseStats = DescriptiveStatisticsFactory.createDescriptiveStatistics((int)SLIDING_WINDOW_SIZE);
    private int successes;
    private int failures;
    private int hits;
    private Map<ErrorMetric, Integer> errors = new HashMap<ErrorMetric, Integer>();
    private long sentBytes;
    private long receivedBytes;

    public SamplerMetric() {
        if (globalWindowMode == WindowMode.FIXED) {
            for (DescriptiveStatistics stat : this.windowedStats) {
                stat.setWindowSize(SLIDING_WINDOW_SIZE);
            }
        }
    }

    @Deprecated
    public static void setDefaultWindowMode(WindowMode windowMode) {
        globalWindowMode = windowMode;
    }

    private List<DescriptiveStatistics> initWindowedStats() {
        return Arrays.asList(this.okResponsesStats, this.koResponsesStats, this.allResponsesStats);
    }

    public synchronized void add(SampleResult result) {
        this.add(result, false);
    }

    public synchronized void addCumulated(SampleResult result) {
        this.add(result, true);
    }

    private synchronized void add(SampleResult result, boolean isCumulated) {
        if (result.isSuccessful()) {
            this.successes += result.getSampleCount() - result.getErrorCount();
        } else {
            this.failures += result.getErrorCount();
            ErrorMetric error = new ErrorMetric(result);
            this.errors.put(error, this.errors.getOrDefault(error, 0) + result.getErrorCount());
        }
        long time = result.getTime();
        this.allResponsesStats.addValue((double)time);
        this.pctResponseStats.addValue((double)time);
        if (result.isSuccessful()) {
            this.okResponsesStats.addValue((double)time);
        } else {
            this.koResponsesStats.addValue((double)time);
        }
        this.addHits(result, isCumulated);
        this.addNetworkData(result, isCumulated);
    }

    private void addNetworkData(SampleResult result, boolean isCumulated) {
        if (isCumulated && TransactionController.isFromTransactionController((SampleResult)result) && result.getSubResults().length == 0) {
            return;
        }
        this.sentBytes += result.getSentBytes();
        this.receivedBytes += result.getBytesAsLong();
    }

    private void addHits(SampleResult result, boolean isCumulated) {
        SampleResult[] subResults = result.getSubResults();
        if (isCumulated && TransactionController.isFromTransactionController((SampleResult)result) && subResults.length == 0) {
            return;
        }
        if (!TransactionController.isFromTransactionController((SampleResult)result) || subResults.length <= 0) {
            this.hits += result.getSampleCount();
        }
        for (SampleResult subResult : subResults) {
            this.addHits(subResult, isCumulated);
        }
    }

    public synchronized void resetForTimeInterval() {
        switch (globalWindowMode) {
            case FIXED: {
                break;
            }
            case TIMED: {
                for (DescriptiveStatistics stat : this.windowedStats) {
                    stat.clear();
                }
                break;
            }
        }
        this.errors.clear();
        this.successes = 0;
        this.failures = 0;
        this.hits = 0;
        this.sentBytes = 0L;
        this.receivedBytes = 0L;
    }

    public int getTotal() {
        return this.successes + this.failures;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getFailures() {
        return this.failures;
    }

    public double getOkMaxTime() {
        return this.okResponsesStats.getMax();
    }

    public double getOkMinTime() {
        return this.okResponsesStats.getMin();
    }

    public double getOkMean() {
        return this.okResponsesStats.getMean();
    }

    public double getOkPercentile(double percentile) {
        return this.okResponsesStats.getPercentile(percentile);
    }

    public double getKoMaxTime() {
        return this.koResponsesStats.getMax();
    }

    public double getKoMinTime() {
        return this.koResponsesStats.getMin();
    }

    public double getKoMean() {
        return this.koResponsesStats.getMean();
    }

    public double getKoPercentile(double percentile) {
        return this.koResponsesStats.getPercentile(percentile);
    }

    public double getAllMaxTime() {
        return this.allResponsesStats.getMax();
    }

    public double getAllMinTime() {
        return this.allResponsesStats.getMin();
    }

    public double getAllMean() {
        return this.allResponsesStats.getMean();
    }

    public double getAllPercentile(double percentile) {
        return this.pctResponseStats.getPercentile(percentile);
    }

    public int getHits() {
        return this.hits;
    }

    public Map<ErrorMetric, Integer> getErrors() {
        return this.errors;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }
}

