/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.JSyntaxSearchToolBar;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.gui.util.TextBoxDialoger;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestPanel;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SearchTextExtension;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.gui.ui.KerningOptimizer;
import org.apache.jorphan.reflect.Functor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SamplerResultTab
implements ResultRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplerResultTab.class);
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final String NL = "\n";
    public static final Color SERVER_ERROR_COLOR = Color.red;
    public static final Color CLIENT_ERROR_COLOR = Color.blue;
    public static final Color REDIRECT_COLOR = Color.green;
    protected static final String TEXT_COMMAND = "text";
    protected static final String REQUEST_VIEW_COMMAND = "change_request_view";
    private static final String STYLE_SERVER_ERROR = "ServerError";
    private static final String STYLE_CLIENT_ERROR = "ClientError";
    private static final String STYLE_REDIRECT = "Redirect";
    private static final int SIMPLE_VIEW_LIMIT = JMeterUtils.getPropDefault((String)"view.results.tree.simple_view_limit", (int)10000);
    private JTextPane stats;
    private JPanel resultsPane;
    protected JScrollPane resultsScrollPane;
    private JSyntaxTextArea headerData;
    protected JEditorPane results;
    private JLabel imageLabel;
    private RequestPanel requestPanel;
    protected JTabbedPane rightSide;
    private int lastSelectedTab;
    private Object userObject = null;
    private SampleResult sampleResult = null;
    private AssertionResult assertionResult = null;
    protected SearchTextExtension searchTextExtension;
    protected boolean activateSearchExtension = true;
    private Color backGround;
    private static final String[] COLUMNS_RESULT = new String[]{" ", " "};
    private static final String[] COLUMNS_HEADERS = new String[]{"view_results_table_headers_key", "view_results_table_headers_value"};
    private static final String[] COLUMNS_FIELDS = new String[]{"view_results_table_fields_key", "view_results_table_fields_value"};
    private final ObjectTableModel resultModel = new ObjectTableModel(COLUMNS_RESULT, RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private final ObjectTableModel resHeadersModel = new ObjectTableModel(COLUMNS_HEADERS, RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private final ObjectTableModel resFieldsModel = new ObjectTableModel(COLUMNS_FIELDS, RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private JTable tableResult = null;
    private JTable tableResHeaders = null;
    private JTable tableResFields = null;
    private JTabbedPane tabbedResult = null;
    private JScrollPane paneRaw = null;
    private JSplitPane paneParsed = null;
    private int lastResultTabIndex = 0;
    private static final TableCellRenderer[] RENDERERS_RESULT = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_HEADERS = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_FIELDS = new TableCellRenderer[]{null, null};

    protected SamplerResultTab() {
    }

    @Override
    public void clearData() {
        this.results.setText("");
        this.headerData.setInitialText("");
        this.requestPanel.clearData();
        this.stats.setText("");
        this.resultModel.clearData();
        this.resHeadersModel.clearData();
        this.resFieldsModel.clearData();
    }

    @Override
    public void init() {
        this.rightSide.addTab(JMeterUtils.getResString((String)"view_results_tab_sampler"), this.createResponseMetadataPanel());
        this.requestPanel = new RequestPanel();
        this.resultsPane = this.createResponseDataPanel();
    }

    @Override
    public void setupTabPane() {
        this.clearData();
        StyledDocument statsDoc = this.stats.getStyledDocument();
        try {
            if (this.userObject instanceof SampleResult) {
                this.sampleResult = (SampleResult)this.userObject;
                this.setupTabPaneForSampleResult();
                this.requestPanel.setSamplerResult(this.sampleResult);
                String samplerClass = this.sampleResult.getClass().getName();
                String typeResult = samplerClass.substring(1 + samplerClass.lastIndexOf(46));
                StringBuilder statsBuff = new StringBuilder(200);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_thread_name")).append(this.sampleResult.getThreadName()).append(NL);
                String startTime = this.dateFormat.format(Instant.ofEpochMilli(this.sampleResult.getStartTime()));
                statsBuff.append(JMeterUtils.getResString((String)"view_results_sample_start")).append(startTime).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_load_time")).append(this.sampleResult.getTime()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_connect_time")).append(this.sampleResult.getConnectTime()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_latency")).append(this.sampleResult.getLatency()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_size_in_bytes")).append(this.sampleResult.getBytesAsLong()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_sent_bytes")).append(this.sampleResult.getSentBytes()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_size_headers_in_bytes")).append(this.sampleResult.getHeadersSize()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_size_body_in_bytes")).append(this.sampleResult.getBodySizeAsLong()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_sample_count")).append(this.sampleResult.getSampleCount()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_error_count")).append(this.sampleResult.getErrorCount()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_datatype")).append(this.sampleResult.getDataType()).append(NL);
                statsDoc.insertString(statsDoc.getLength(), statsBuff.toString(), null);
                statsBuff.setLength(0);
                String responseCode = this.sampleResult.getResponseCode();
                int responseLevel = 0;
                if (responseCode != null) {
                    try {
                        responseLevel = Integer.parseInt(responseCode) / 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Style style = null;
                switch (responseLevel) {
                    case 3: {
                        style = statsDoc.getStyle(STYLE_REDIRECT);
                        break;
                    }
                    case 4: {
                        style = statsDoc.getStyle(STYLE_CLIENT_ERROR);
                        break;
                    }
                    case 5: {
                        style = statsDoc.getStyle(STYLE_SERVER_ERROR);
                        break;
                    }
                }
                statsBuff.append(JMeterUtils.getResString((String)"view_results_response_code")).append(responseCode).append(NL);
                statsDoc.insertString(statsDoc.getLength(), statsBuff.toString(), style);
                statsBuff.setLength(0);
                String responseMsgStr = this.sampleResult.getResponseMessage();
                statsBuff.append(JMeterUtils.getResString((String)"view_results_response_message")).append(responseMsgStr).append(NL);
                statsBuff.append(NL);
                statsBuff.append(NL);
                statsBuff.append(typeResult + " " + JMeterUtils.getResString((String)"view_results_fields")).append(NL);
                statsBuff.append("ContentType: ").append(this.sampleResult.getContentType()).append(NL);
                statsBuff.append("DataEncoding: ").append(this.sampleResult.getDataEncodingNoDefault()).append(NL);
                statsDoc.insertString(statsDoc.getLength(), statsBuff.toString(), null);
                statsBuff = null;
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_thread_name"), this.sampleResult.getThreadName()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_sample_start"), startTime));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_load_time"), this.sampleResult.getTime()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_connect_time"), this.sampleResult.getConnectTime()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_latency"), this.sampleResult.getLatency()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_size_in_bytes"), this.sampleResult.getBytesAsLong()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_sent_bytes"), this.sampleResult.getSentBytes()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_size_headers_in_bytes"), this.sampleResult.getHeadersSize()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_size_body_in_bytes"), this.sampleResult.getBodySizeAsLong()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_sample_count"), this.sampleResult.getSampleCount()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_error_count"), this.sampleResult.getErrorCount()));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_response_code"), responseCode));
                this.resultModel.addRow((Object)new RowResult(JMeterUtils.getParsedLabel((String)"view_results_response_message"), responseMsgStr));
                LinkedHashMap lhm = JMeterUtils.parseHeaders((String)this.sampleResult.getResponseHeaders());
                Set keySet = lhm.entrySet();
                for (Map.Entry entry : keySet) {
                    this.resHeadersModel.addRow((Object)new RowResult((String)entry.getKey(), entry.getValue()));
                }
                this.headerData.setInitialText(this.sampleResult.getResponseHeaders());
                this.resFieldsModel.addRow((Object)new RowResult("Type Result ", typeResult));
                this.resFieldsModel.addRow((Object)new RowResult("ContentType", this.sampleResult.getContentType()));
                this.resFieldsModel.addRow((Object)new RowResult("DataEncoding", this.sampleResult.getDataEncodingNoDefault()));
                if (this.activateSearchExtension) {
                    this.searchTextExtension.resetTextToFind();
                }
            } else if (this.userObject instanceof AssertionResult) {
                this.assertionResult = (AssertionResult)this.userObject;
                this.setupTabPaneForAssertionResult();
                StringBuilder statsBuff = new StringBuilder(100);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_assertion_error")).append(this.assertionResult.isError()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_assertion_failure")).append(this.assertionResult.isFailure()).append(NL);
                statsBuff.append(JMeterUtils.getResString((String)"view_results_assertion_failure_message")).append(this.assertionResult.getFailureMessage()).append(NL);
                statsDoc.insertString(statsDoc.getLength(), statsBuff.toString(), null);
            }
            this.stats.setCaretPosition(1);
        }
        catch (BadLocationException exc) {
            this.stats.setText(exc.getLocalizedMessage());
        }
    }

    private void setupTabPaneForSampleResult() {
        if (this.tabbedResult.getTabCount() < 2) {
            this.tabbedResult.insertTab(JMeterUtils.getResString((String)"view_results_table_result_tab_parsed"), null, this.paneParsed, null, 1);
            this.tabbedResult.setSelectedIndex(this.lastResultTabIndex);
        }
        this.rightSide.setTitleAt(0, JMeterUtils.getResString((String)"view_results_tab_sampler"));
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"view_results_tab_request")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"view_results_tab_request"), this.requestPanel.getPanel());
        }
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"view_results_tab_response")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"view_results_tab_response"), this.resultsPane);
        }
        if (this.lastSelectedTab < this.rightSide.getTabCount()) {
            this.rightSide.setSelectedIndex(this.lastSelectedTab);
        }
    }

    private void setupTabPaneForAssertionResult() {
        int responseTabIndex;
        if (this.tabbedResult.getTabCount() >= 2) {
            this.lastResultTabIndex = this.tabbedResult.getSelectedIndex();
            int parsedTabIndex = this.tabbedResult.indexOfTab(JMeterUtils.getResString((String)"view_results_table_result_tab_parsed"));
            if (parsedTabIndex >= 0) {
                this.tabbedResult.removeTabAt(parsedTabIndex);
            }
        }
        this.rightSide.setTitleAt(0, JMeterUtils.getResString((String)"view_results_tab_assertion"));
        int requestTabIndex = this.rightSide.indexOfTab(JMeterUtils.getResString((String)"view_results_tab_request"));
        if (requestTabIndex >= 0) {
            this.rightSide.removeTabAt(requestTabIndex);
        }
        if ((responseTabIndex = this.rightSide.indexOfTab(JMeterUtils.getResString((String)"view_results_tab_response"))) >= 0) {
            this.rightSide.removeTabAt(responseTabIndex);
        }
    }

    private Component createResponseMetadataPanel() {
        this.stats = new JTextPane();
        this.stats.setEditable(false);
        this.stats.setBackground(this.backGround);
        StyledDocument doc = (StyledDocument)this.stats.getDocument();
        Style style = doc.addStyle(STYLE_REDIRECT, null);
        StyleConstants.setForeground(style, REDIRECT_COLOR);
        style = doc.addStyle(STYLE_CLIENT_ERROR, null);
        StyleConstants.setForeground(style, CLIENT_ERROR_COLOR);
        style = doc.addStyle(STYLE_SERVER_ERROR, null);
        StyleConstants.setForeground(style, SERVER_ERROR_COLOR);
        this.paneRaw = GuiUtils.makeScrollPane((Component)this.stats);
        this.paneRaw.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tableResult = new JTable((TableModel)this.resultModel);
        JMeterUtils.applyHiDPI((JTable)this.tableResult);
        this.tableResult.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableResult.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableResult));
        this.setFirstColumnPreferredSize(this.tableResult);
        RendererUtils.applyRenderers((JTable)this.tableResult, (TableCellRenderer[])RENDERERS_RESULT);
        this.tableResHeaders = new JTable((TableModel)this.resHeadersModel);
        JMeterUtils.applyHiDPI((JTable)this.tableResHeaders);
        this.tableResHeaders.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableResHeaders.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableResHeaders));
        this.setFirstColumnPreferredSize(this.tableResHeaders);
        this.tableResHeaders.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableResHeaders, (TableCellRenderer[])RENDERERS_HEADERS);
        this.tableResFields = new JTable((TableModel)this.resFieldsModel);
        JMeterUtils.applyHiDPI((JTable)this.tableResFields);
        this.tableResFields.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableResFields.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableResFields));
        this.setFirstColumnPreferredSize(this.tableResFields);
        this.tableResFields.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableResFields, (TableCellRenderer[])RENDERERS_FIELDS);
        this.tabbedResult = new JTabbedPane(3);
        JSplitPane topSplit = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableResHeaders), GuiUtils.makeScrollPane((Component)this.tableResFields));
        topSplit.setOneTouchExpandable(true);
        topSplit.setResizeWeight(0.8);
        topSplit.setBorder(null);
        this.paneParsed = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableResult), topSplit);
        this.paneParsed.setOneTouchExpandable(true);
        this.paneParsed.setResizeWeight(0.4);
        this.paneParsed.setBorder(null);
        this.tabbedResult.addTab(JMeterUtils.getResString((String)"view_results_table_result_tab_raw"), this.paneRaw);
        this.tabbedResult.addTab(JMeterUtils.getResString((String)"view_results_table_result_tab_parsed"), this.paneParsed);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.tabbedResult);
        return panel;
    }

    private JPanel createResponseDataPanel() {
        this.results = new JEditorPane();
        this.results.setEditable(false);
        this.headerData = JSyntaxTextArea.getInstance((int)20, (int)80, (boolean)true);
        this.headerData.setEditable(false);
        this.headerData.setLineWrap(true);
        this.headerData.setWrapStyleWord(true);
        JPanel headersAndSearchPanel = new JPanel(new BorderLayout());
        headersAndSearchPanel.add((Component)new JSyntaxSearchToolBar(this.headerData).getToolBar(), "North");
        headersAndSearchPanel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.headerData), "Center");
        this.resultsScrollPane = GuiUtils.makeScrollPane((Component)this.results);
        this.imageLabel = new JLabel();
        JPanel resultAndSearchPanel = new JPanel(new BorderLayout());
        resultAndSearchPanel.add((Component)this.resultsScrollPane, "Center");
        if (this.activateSearchExtension) {
            this.searchTextExtension = new SearchTextExtension(new SearchTextExtension.JEditorPaneSearchProvider(this.results));
            resultAndSearchPanel.add((Component)this.searchTextExtension.getSearchToolBar(), "North");
        }
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab(JMeterUtils.getResString((String)"view_results_response_body"), new JScrollPane(resultAndSearchPanel));
        tabbedPane.addTab(JMeterUtils.getResString((String)"view_results_response_headers"), new JScrollPane(headersAndSearchPanel));
        JPanel gPanel = new JPanel(new GridLayout(1, 1));
        gPanel.add(tabbedPane);
        return gPanel;
    }

    private void showImage(Icon image) {
        this.imageLabel.setIcon(image);
        this.resultsScrollPane.setViewportView(this.imageLabel);
    }

    @Override
    public synchronized void setSamplerResult(Object sample) {
        this.userObject = sample;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public void setLastSelectedTab(int index) {
        this.lastSelectedTab = index;
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        byte[] responseBytes = sampleResult.getResponseData();
        if (responseBytes != null) {
            this.showImage(new ImageIcon(responseBytes));
        }
    }

    @Override
    public void setBackgroundColor(Color backGround) {
        this.backGround = backGround;
    }

    private void setFirstColumnPreferredSize(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMaxWidth(300);
        column.setPreferredWidth(180);
    }

    protected void setTextOptimized(String data) {
        Document document = this.results.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.results.setDocument(blank);
        try {
            data = ViewResultsFullVisualizer.wrapLongLines(data);
            document.insertString(0, data == null ? "" : data, null);
        }
        catch (BadLocationException ex) {
            LOGGER.error("Error inserting text", (Throwable)ex);
        }
        if (SIMPLE_VIEW_LIMIT >= 0 && document.getLength() > SIMPLE_VIEW_LIMIT) {
            this.results.setEditorKit(new NonWrappingPlainTextEditorKit(this.results.getEditorKit()));
        }
        KerningOptimizer.INSTANCE.configureKerning((JComponent)this.results, document.getLength());
        this.results.setDocument(document);
    }

    static class NonWrappingPlainTextEditorKit
    extends EditorKit {
        private final EditorKit delegate;

        NonWrappingPlainTextEditorKit(EditorKit delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getContentType() {
            return this.delegate.getContentType();
        }

        @Override
        public ViewFactory getViewFactory() {
            return new ViewFactory(){

                @Override
                public View create(Element elem) {
                    return new PlainView(elem);
                }
            };
        }

        @Override
        public Action[] getActions() {
            return this.delegate.getActions();
        }

        @Override
        public Caret createCaret() {
            return this.delegate.createCaret();
        }

        @Override
        public Document createDefaultDocument() {
            return this.delegate.createDefaultDocument();
        }

        @Override
        public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
            this.delegate.read(in, doc, pos);
        }

        @Override
        public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
            this.delegate.write(out, doc, pos, len);
        }

        @Override
        public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
            this.delegate.read(in, doc, pos);
        }

        @Override
        public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
            this.delegate.write(out, doc, pos, len);
        }
    }

    public static class RowResult {
        private String key;
        private Object value;

        public RowResult(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public synchronized String getKey() {
            return this.key;
        }

        public synchronized void setKey(String key) {
            this.key = key;
        }

        public synchronized Object getValue() {
            return this.value;
        }

        public synchronized void setValue(Object value) {
            this.value = value;
        }
    }
}

