/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.ui.cell.CellToggleButton;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditorToggleButton
extends AbstractCellEditor
implements TableCellEditor,
SwingConstants {
    private final JToggleButton toggleButton;
    private final Border editorBorder;

    public DarkTableCellEditorToggleButton(JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
        this.editorBorder = UIManager.getBorder("Table.booleanEditorBorder");
        toggleButton.setFocusable(false);
        toggleButton.setOpaque(true);
    }

    @Override
    public JToggleButton getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Boolean) {
            this.toggleButton.setSelected((Boolean)value);
        }
        if (this.toggleButton instanceof CellToggleButton) {
            ((CellToggleButton)((Object)this.toggleButton)).setHasFocus(true);
        }
        this.toggleButton.setBorder(this.editorBorder);
        return this.toggleButton;
    }

    public JToggleButton getToggleButton() {
        return this.toggleButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.toggleButton.isSelected();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }
}

