/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.delegate.TableCellEditorDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.TableConstants;
import com.github.weisj.darklaf.ui.table.renderer.DarkMultiCellEditor;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellEditorToggleButton;
import com.github.weisj.darklaf.ui.table.renderer.IconWrapper;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditorDelegate
extends TableCellEditorDelegate {
    private static final IconWrapper iconWrapper = new IconWrapper();
    private final JToggleButton editorCheckBox = new DarkCellRendererToggleButton.CellCheckBox(true);
    private final DarkTableCellEditorToggleButton checkBoxEditor = new DarkTableCellEditorToggleButton(this.editorCheckBox);
    private final JToggleButton editorRadioButton = new DarkCellRendererToggleButton.CellRadioButton(true);
    private final DarkTableCellEditorToggleButton radioButtonEditor = new DarkTableCellEditorToggleButton(this.editorRadioButton);
    private boolean isBooleanEditor;
    private TableCellEditor currentEditor;

    public DarkTableCellEditorDelegate() {
        super(new DarkMultiCellEditor());
    }

    public DarkTableCellEditorDelegate(TableCellEditor editor) {
        super(editor);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isBooleanEditor && this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        return super.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent == null) {
            return super.isCellEditable(null);
        }
        JTable table = (JTable)anEvent.getSource();
        if (anEvent instanceof KeyEvent && DarkTableUI.ignoreKeyCodeOnEdit((KeyEvent)anEvent, table)) {
            return false;
        }
        if (TableConstants.isBooleanRenderingEnabled(table) && anEvent instanceof MouseEvent && this.isMouseOverBooleanRenderer((MouseEvent)anEvent, table)) {
            return true;
        }
        return super.isCellEditable(anEvent);
    }

    private boolean isMouseOverBooleanRenderer(MouseEvent anEvent, JTable table) {
        Object value;
        Point p = anEvent.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (row >= 0 && row < table.getRowCount() && col >= 0 && col < table.getColumnCount() && TableConstants.useBooleanEditorForValue(value = table.getValueAt(row, col), table, col)) {
            Rectangle rect = table.getCellRect(row, col, false);
            p.x -= rect.x;
            p.y -= rect.y;
            JToggleButton editor = this.getBooleanEditor(table).getTableCellEditorComponent(table, true, false, row, col);
            editor.setBounds(rect);
            return editor.contains(p);
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.isBooleanEditor = TableConstants.useBooleanEditorForValue(value, table, column);
        this.currentEditor = this.isBooleanEditor ? this.getBooleanEditor(table) : this.getDelegate();
        Component editor = this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        editor = this.prepareEditorComponent(editor, table, value, isSelected, row, column);
        return editor;
    }

    protected Component prepareEditorComponent(Component editor, JTable table, Object value, boolean isSelected, int row, int column) {
        return DarkTableCellEditorDelegate.prepareEditor(editor, table, value, isSelected, row, column);
    }

    public static Component prepareEditor(Component editor, JTable table, Object value, boolean isSelected, int row, int column) {
        Component renderer = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, false, row, column);
        DarkTableCellEditorDelegate.setupEditorComponent(editor, value, renderer);
        Component comp = DarkTableCellEditorDelegate.applyRendererIcon(editor, renderer);
        CellUtil.setupTableBackground(comp, table, false, row);
        return comp;
    }

    protected static void setupEditorComponent(Component editorComponent, Object value, Component rendererComp) {
        int alignment;
        if (editorComponent instanceof JSpinner && (alignment = DarkTableCellEditorDelegate.getHorizontalAlignment(rendererComp)) >= 0) {
            ((JComponent)editorComponent).putClientProperty("JSpinner.cellEditorAlignment", alignment);
        }
        if (editorComponent instanceof JTextField && (alignment = DarkTableCellEditorDelegate.getHorizontalAlignment(rendererComp)) >= 0) {
            ((JTextField)editorComponent).setHorizontalAlignment(alignment);
        }
    }

    protected static int getHorizontalAlignment(Component rendererComp) {
        if (rendererComp instanceof JTextField) {
            return ((JTextField)rendererComp).getHorizontalAlignment();
        }
        if (rendererComp instanceof JLabel) {
            return ((JLabel)rendererComp).getHorizontalAlignment();
        }
        return -1;
    }

    protected static Component applyRendererIcon(Component editorComponent, Component rendererComponent) {
        Icon icon;
        Component comp = editorComponent;
        if (rendererComponent instanceof JLabel && comp instanceof JComponent && (icon = ((JLabel)rendererComponent).getIcon()) != null) {
            iconWrapper.init((JComponent)comp, icon, rendererComponent.getComponentOrientation());
            iconWrapper.setIconGap(((JLabel)rendererComponent).getIconTextGap() - 1);
            comp = iconWrapper;
        }
        return comp;
    }

    protected DarkTableCellEditorToggleButton getBooleanEditor(JTable table) {
        if (PropertyUtil.isPropertyEqual((JComponent)table, (String)"JTable.booleanRenderType", (Object)"radioButton")) {
            return this.radioButtonEditor;
        }
        return this.checkBoxEditor;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }
}

