/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DarkColorTableCellRendererEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private final JLabel label = new JLabel();
    private Color savedColor;

    public DarkColorTableCellRendererEditor() {
        this.label.setOpaque(true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof Color)) {
            this.cancelCellEditing();
            return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }
        this.changeColor((Color)value);
        SwingUtilities.invokeLater(() -> {
            Color color = JColorChooser.showDialog(table, "Color Chooser", this.savedColor);
            if (color == null) {
                this.cancelCellEditing();
            } else {
                this.changeColor(color);
            }
        });
        return this.label;
    }

    private void changeColor(Color color) {
        if (color != null) {
            this.savedColor = color;
            this.label.setBackground(color);
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.savedColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.changeColor((Color)value);
        return this.label;
    }
}

