/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.ScrollableTabSupport;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneHandler;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneLayout;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneScrollLayout;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyActionMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public abstract class DarkTabbedPaneUIBridge
extends TabbedPaneUI
implements SwingConstants {
    protected final Insets currentPadInsets = new Insets(0, 0, 0, 0);
    protected final Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    protected JTabbedPane tabPane;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected boolean tabsOverlapBorder;
    protected boolean tabsOpaque = true;
    protected boolean contentOpaque = true;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    protected Component visibleComponent;
    protected Vector<View> htmlViews;
    protected Hashtable<Integer, Integer> mnemonicToIndexMap;
    protected InputMap mnemonicInputMap;
    protected ScrollableTabSupport tabScroller;
    protected TabContainer tabContainer;
    protected int focusIndex;
    protected TabbedPaneHandler handler;
    protected int rolloverTabIndex;
    protected boolean isRunsDirty;
    protected boolean calculatedBaseline;
    protected Color selectedForeground;
    protected int baseline;

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("navigateNext"));
        map.put(new Actions("navigatePrevious"));
        map.put(new Actions("navigateRight"));
        map.put(new Actions("navigateLeft"));
        map.put(new Actions("navigateUp"));
        map.put(new Actions("navigateDown"));
        map.put(new Actions("navigatePageUp"));
        map.put(new Actions("navigatePageDown"));
        map.put(new Actions("requestFocus"));
        map.put(new Actions("requestFocusForVisibleComponent"));
        map.put(new Actions("setSelectedIndex"));
        map.put(new Actions("selectTabWithFocus"));
        map.put(new Actions("scrollTabsForwardAction"));
        map.put(new Actions("scrollTabsBackwardAction"));
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        this.calculatedBaseline = false;
        this.rolloverTabIndex = -1;
        this.focusIndex = -1;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this.tabPane = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, null);
        this.mnemonicToIndexMap = null;
        this.mnemonicInputMap = null;
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        this.tabPane.removeMouseMotionListener(this.getHandler());
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.tabPane.removeContainerListener(this.getHandler());
        if (this.htmlViews != null) {
            this.htmlViews.removeAllElements();
            this.htmlViews = null;
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected void uninstallDefaults() {
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabScroller = null;
        }
    }

    protected void uninstallTabContainer() {
        if (this.tabContainer == null) {
            return;
        }
        this.tabContainer.notifyTabbedPane = false;
        this.tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.remove(this.tabContainer);
        } else {
            this.tabPane.remove(this.tabContainer);
        }
        this.tabContainer = null;
    }

    @Override
    public abstract void paint(Graphics var1, JComponent var2);

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        int baseline = this.calculateBaselineIfNecessary();
        if (baseline != -1) {
            int placement = this.tabPane.getTabPlacement();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = this.getTabAreaInsets(placement);
            switch (placement) {
                case 1: 
                case 2: 
                case 4: {
                    return baseline += insets.top + tabAreaInsets.top;
                }
                case 3: {
                    baseline = height - insets.bottom - tabAreaInsets.bottom - this.maxTabHeight + baseline;
                    return baseline;
                }
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 2: 
            case 4: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected abstract void paintContentBorder(Graphics var1, int var2, int var3);

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (j == selectedIndex || !this.rects[j].intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        this.paintTab(g, tabPlacement, rects[tabIndex], tabIndex, iconRect, textRect);
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle tabRect, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean bl = isSelected = selectedIndex == tabIndex;
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String clippedTitle = title;
            if (!this.scrollableTabLayoutEnabled() && this.isHorizontalTabPlacement()) {
                clippedTitle = SwingUtilities2.clipStringIfNecessary(null, metrics, title, textRect.width);
            }
            this.paintText(g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintFocusIndicator(g, tabPlacement, tabRect, tabIndex, iconRect, textRect, isSelected);
    }

    protected abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    protected abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    protected Icon getIconForTab(int tabIndex) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex) ? this.tabPane.getDisabledIconAt(tabIndex) : this.tabPane.getIconAt(tabIndex);
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected abstract LayoutManager createLayoutManager();

    protected abstract void paintText(Graphics var1, int var2, Font var3, FontMetrics var4, int var5, String var6, Rectangle var7, boolean var8);

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            Shape oldClip = g.getClip();
            ((Graphics2D)g).clip(iconRect);
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
            g.setClip(oldClip);
        }
    }

    protected abstract void paintFocusIndicator(Graphics var1, int var2, Rectangle var3, int var4, Rectangle var5, Rectangle var6, boolean var7);

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null) {
            return this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        String propKey = isSelected ? "selectedLabelShift" : "labelShift";
        int nudge = DefaultLookup.getInt(this.tabPane, this, "TabbedPane." + propKey, 1);
        switch (tabPlacement) {
            case 2: {
                return nudge;
            }
            case 4: {
                return -nudge;
            }
        }
        return tabRect.width % 2;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = isSelected ? DefaultLookup.getInt(this.tabPane, this, "TabbedPane.selectedLabelShift", -1) : DefaultLookup.getInt(this.tabPane, this, "TabbedPane.labelShift", 1);
        switch (tabPlacement) {
            case 3: {
                return -nudge;
            }
            case 2: 
            case 4: {
                return tabRect.height % 2;
            }
        }
        return nudge;
    }

    protected void installTabContainer() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComponent = this.tabPane.getTabComponentAt(i);
            if (tabComponent == null) continue;
            if (this.tabContainer == null) {
                this.tabContainer = new TabContainer();
            }
            this.tabContainer.add(tabComponent);
        }
        if (this.tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.add(this.tabContainer);
        } else {
            this.tabPane.add(this.tabContainer);
        }
    }

    protected abstract void installComponents();

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        Object opaque = UIManager.get("TabbedPane.opaque");
        if (opaque == null) {
            opaque = Boolean.FALSE;
        }
        LookAndFeel.installProperty(this.tabPane, "opaque", opaque);
        if (this.tabInsets == null) {
            this.tabInsets = new Insets(0, 4, 1, 4);
        }
        if (this.selectedTabPadInsets == null) {
            this.selectedTabPadInsets = new Insets(2, 2, 2, 1);
        }
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(3, 2, 0, 2);
        }
        if (this.contentBorderInsets == null) {
            this.contentBorderInsets = new Insets(2, 2, 3, 3);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        this.tabPane.addMouseMotionListener(this.getHandler());
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.tabPane.addContainerListener(this.getHandler());
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLVector();
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        LazyActionMap.installLazyActionMap(this.tabPane, DarkTabbedPaneUIBridge.class, "TabbedPane.actionMap");
        this.updateMnemonics();
    }

    protected TabbedPaneHandler getHandler() {
        if (this.handler == null) {
            this.handler = new TabbedPaneHandler(this);
        }
        return this.handler;
    }

    protected Vector<View> createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.focusInputMap");
        }
        return null;
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, DarkUIUtil.getFocusAcceleratorKeyMask()), "setSelectedIndex");
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 0x2000 | DarkUIUtil.getFocusAcceleratorKeyMask()), "setSelectedIndex");
        this.mnemonicToIndexMap.put(mnemonic, index);
    }

    protected void setRolloverTab(int x, int y) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, x, y, false));
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    protected void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected int tabForCoordinate(JTabbedPane pane, int x, int y, boolean validateIfNecessary) {
        if (validateIfNecessary) {
            this.ensureCurrentLayout();
        }
        if (this.isRunsDirty) {
            return -1;
        }
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            if (!viewRect.contains(p)) {
                return -1;
            }
        }
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    protected int calculateBaselineIfNecessary() {
        if (!this.calculatedBaseline) {
            this.calculatedBaseline = true;
            this.baseline = -1;
            if (this.tabPane.getTabCount() > 0) {
                this.calculateBaseline();
            }
        }
        return this.baseline;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    protected void setRolloverTab(int index) {
        this.rolloverTabIndex = index;
    }

    protected int getBaseline(int tab) {
        if (this.tabPane.getTabComponentAt(tab) != null) {
            int offset = this.getBaselineOffset();
            if (offset != 0) {
                return -1;
            }
            Component c = this.tabPane.getTabComponentAt(tab);
            Dimension pref = c.getPreferredSize();
            Insets tabInsets = this.getTabInsets(this.tabPane.getTabPlacement(), tab);
            int cellHeight = this.maxTabHeight - tabInsets.top - tabInsets.bottom;
            return c.getBaseline(pref.width, pref.height) + (cellHeight - pref.height) / 2 + tabInsets.top;
        }
        View view = this.getTextViewForTab(tab);
        if (view != null) {
            int viewHeight = (int)view.getPreferredSpan(1);
            int baseline = BasicHTML.getHTMLBaseline(view, (int)view.getPreferredSpan(0), viewHeight);
            if (baseline >= 0) {
                return this.maxTabHeight / 2 - viewHeight / 2 + baseline + this.getBaselineOffset();
            }
            return -1;
        }
        FontMetrics metrics = this.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int fontBaseline = metrics.getAscent();
        return this.maxTabHeight / 2 - fontHeight / 2 + fontBaseline + this.getBaselineOffset();
    }

    protected int getBaselineOffset() {
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                if (this.tabPane.getTabCount() > 1) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (this.tabPane.getTabCount() > 1) {
                    return -1;
                }
                return 1;
            }
        }
        return this.maxTabHeight % 2;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this.tabForCoordinate(pane, x, y, true);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    protected void calculateBaseline() {
        int tabCount = this.tabPane.getTabCount();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.maxTabHeight = this.calculateMaxTabHeight(tabPlacement);
        this.baseline = this.getBaseline(0);
        if (this.isHorizontalTabPlacement()) {
            for (int i = 1; i < tabCount; ++i) {
                if (this.getBaseline(i) == this.baseline) continue;
                this.baseline = -1;
                break;
            }
        } else {
            FontMetrics fontMetrics = this.getFontMetrics();
            int fontHeight = fontMetrics.getHeight();
            int height = this.calculateTabHeight(tabPlacement, 0, fontHeight);
            for (int i = 1; i < tabCount; ++i) {
                int newHeight = this.calculateTabHeight(tabPlacement, i, fontHeight);
                if (height == newHeight) continue;
                this.baseline = -1;
                break;
            }
        }
    }

    protected boolean isHorizontalTabPlacement() {
        return this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this.rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this.rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this.rects = tempRectArray;
            for (int rectIndex = rectArrayLen; rectIndex < tabCount; ++rectIndex) {
                this.rects[rectIndex] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this.tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this.tabRuns, 0, newArray, 0, this.runCount);
        this.tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        for (int i = 0; i < this.runCount; ++i) {
            int first = this.tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex < first || tabIndex > last) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this.runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this.runCount - 1 ? 0 : run + 1;
        if (this.tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        Component c = this.tabPane.getTabComponentAt(tabIndex);
        if (c != null) {
            height = c.getPreferredSize().height;
        } else {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        return height += tabInsets.top + tabInsets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
        }
        return result;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += SwingUtilities2.stringWidth(this.tabPane, metrics, title);
            }
        }
        return width;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        DarkTabbedPaneUIBridge.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, tabPlacement);
        return this.currentPadInsets;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        DarkTabbedPaneUIBridge.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, tabPlacement);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentBorderInsets;
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int current = DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true) ? this.tabPane.getSelectedIndex() : this.getFocusIndex();
        int tabCount = this.tabPane.getTabCount();
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        if (tabCount <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 2: 
            case 4: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break block0;
                    }
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break block0;
                    }
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this.runCount < 2) {
            return;
        }
        Rectangle r = this.rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2 + offset, r.y + r.height / 2);
                break;
            }
            default: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2, r.y + r.height / 2 + offset);
            }
        }
        if (newIndex != -1) {
            while (!this.tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this.navigateTo(newIndex);
        }
    }

    protected void navigateTo(int index) {
        if (DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true)) {
            this.tabPane.setSelectedIndex(index);
        } else {
            this.setFocusIndex(index, true);
        }
    }

    protected void validateFocusIndex() {
        if (this.focusIndex >= this.tabPane.getTabCount()) {
            this.setFocusIndex(this.tabPane.getSelectedIndex(), false);
        }
    }

    void setFocusIndex(int index, boolean repaint) {
        if (repaint && !this.isRunsDirty) {
            this.repaintTab(this.focusIndex);
            this.focusIndex = index;
            this.repaintTab(this.focusIndex);
        } else {
            this.focusIndex = index;
        }
    }

    protected void repaintTab(int index) {
        if (!this.isRunsDirty && index >= 0 && index < this.tabPane.getTabCount()) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, index));
        }
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    protected int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    protected int getFocusIndex() {
        return this.focusIndex;
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                offset = forward ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (run == this.runCount - 1 ? (forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (forward ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this.tabPane.getTabCount() - 1;
        return Math.max(tabIndex, 0);
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this.tabRuns[this.getNextTabRun(currentRun)]) {
            return this.tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this.tabRuns[currentRun]) {
            int previous = this.tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this.runCount - 1;
        return Math.max(runIndex, 0);
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this.runCount;
    }

    boolean requestFocusForVisibleComponent() {
        return SwingUtilities2.tabbedPaneChangeFocusTo(this.getVisibleComponent());
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane && this.visibleComponent.isVisible()) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected class TabContainer
    extends JPanel
    implements UIResource {
        protected boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component comp) {
            int index = DarkTabbedPaneUIBridge.this.tabPane.indexOfTabComponent(comp);
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                DarkTabbedPaneUIBridge.this.tabPane.setTabComponentAt(index, null);
            }
        }

        @Override
        public void doLayout() {
            if (DarkTabbedPaneUIBridge.this.scrollableTabLayoutEnabled()) {
                DarkTabbedPaneUIBridge.this.tabScroller.tabPanel.repaint();
            } else {
                DarkTabbedPaneUIBridge.this.tabPane.repaint(this.getBounds());
            }
        }

        protected void removeUnusedTabComponents() {
            for (Component c : this.getComponents()) {
                int index;
                if (c instanceof UIResource || (index = DarkTabbedPaneUIBridge.this.tabPane.indexOfTabComponent(c)) != -1) continue;
                super.remove(c);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return true;
        }
    }

    protected static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int focusIndex;
            String key = this.getName();
            JTabbedPane pane = (JTabbedPane)e.getSource();
            DarkTabbedPaneUIBridge ui = DarkUIUtil.getUIOfType(pane.getUI(), DarkTabbedPaneUIBridge.class);
            if (ui == null) {
                return;
            }
            if (Objects.equals(key, NEXT)) {
                ui.navigateSelectedTab(12);
            } else if (Objects.equals(key, PREVIOUS)) {
                ui.navigateSelectedTab(13);
            } else if (Objects.equals(key, RIGHT)) {
                ui.navigateSelectedTab(3);
            } else if (Objects.equals(key, LEFT)) {
                ui.navigateSelectedTab(7);
            } else if (Objects.equals(key, UP)) {
                ui.navigateSelectedTab(1);
            } else if (Objects.equals(key, DOWN)) {
                ui.navigateSelectedTab(5);
            } else if (Objects.equals(key, PAGE_UP)) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(7);
                } else {
                    ui.navigateSelectedTab(1);
                }
            } else if (Objects.equals(key, PAGE_DOWN)) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(3);
                } else {
                    ui.navigateSelectedTab(5);
                }
            } else if (Objects.equals(key, REQUEST_FOCUS)) {
                pane.requestFocusInWindow();
            } else if (Objects.equals(key, REQUEST_FOCUS_FOR_VISIBLE)) {
                ui.requestFocusForVisibleComponent();
            } else if (Objects.equals(key, SET_SELECTED)) {
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = ui.mnemonicToIndexMap.get(mnemonic)) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            } else if (Objects.equals(key, SELECT_FOCUSED) && (focusIndex = ui.getFocusIndex()) != -1) {
                pane.setSelectedIndex(focusIndex);
            }
        }
    }
}

