/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.delegate.ScrollLayoutManagerDelegate;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarUtil;
import com.github.weisj.darklaf.ui.scrollpane.ViewPropertyChangeListener;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class DarkScrollPaneUI
extends BasicScrollPaneUI {
    private final MouseWheelListener verticalMouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled() || e.getModifiersEx() == 0 || !this.horizontalScrollBarEnabled()) {
            return;
        }
        JScrollBar scrollbar = this.scrollpane.getHorizontalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private final MouseWheelListener horizontalMouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled() || e.isShiftDown() || !this.verticalScrollBarEnabled()) {
            return;
        }
        JScrollBar scrollbar = this.scrollpane.getVerticalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private final MouseWheelListener mouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled()) {
            return;
        }
        JScrollBar scrollbar = e.isShiftDown() ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private ViewPropertyChangeListener viewPropertyChangeListener;
    private ScrollPaneLayout oldLayout;

    public static ComponentUI createUI(JComponent c) {
        return new DarkScrollPaneUI();
    }

    private boolean horizontalScrollBarEnabled() {
        JScrollBar sb = this.scrollpane.getHorizontalScrollBar();
        if (sb == null) {
            return false;
        }
        return sb.isVisible();
    }

    private boolean verticalScrollBarEnabled() {
        JScrollBar sb = this.scrollpane.getVerticalScrollBar();
        if (sb == null) {
            return false;
        }
        return sb.isVisible();
    }

    protected Color getViewBackground() {
        Component view = this.getViewportView();
        return view != null ? view.getBackground() : null;
    }

    protected Component getViewportView() {
        JViewport viewport = this.scrollpane.getViewport();
        return viewport != null ? viewport.getView() : null;
    }

    @Override
    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        this.getViewPropertyChangeListener().install();
        this.scrollpane.addPropertyChangeListener(this.getPropertyChangeListener());
        this.scrollpane.getVerticalScrollBar().addMouseWheelListener(this.verticalMouseWheelListener);
        this.scrollpane.getHorizontalScrollBar().addMouseWheelListener(this.horizontalMouseWheelListener);
    }

    protected ViewPropertyChangeListener getViewPropertyChangeListener() {
        if (this.viewPropertyChangeListener == null) {
            this.viewPropertyChangeListener = this.createViewPropertyChangeListener();
        }
        return this.viewPropertyChangeListener;
    }

    protected ViewPropertyChangeListener createViewPropertyChangeListener() {
        return new ViewPropertyChangeListener(this.scrollpane, e -> {
            if ("background".equals(e.getPropertyName())) {
                this.updateScrollBarBackground();
            }
        });
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        return this::scrollPanePropertyChange;
    }

    protected void scrollPanePropertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.scrollpane) {
            String propertyName = e.getPropertyName();
            if ("verticalScrollBar".equals(propertyName)) {
                Object old = e.getOldValue();
                Object newVal = e.getNewValue();
                if (old instanceof JScrollBar) {
                    ((JScrollBar)old).removeMouseWheelListener(this.verticalMouseWheelListener);
                }
                if (newVal instanceof JScrollBar) {
                    ((JScrollBar)newVal).addMouseWheelListener(this.verticalMouseWheelListener);
                    PropertyUtil.installBackground((Component)((Component)newVal), (Color)this.getViewBackground());
                }
            } else if ("horizontalScrollBar".equals(propertyName)) {
                Object old = e.getOldValue();
                Object newVal = e.getNewValue();
                if (old instanceof JScrollBar) {
                    ((JScrollBar)old).removeMouseWheelListener(this.horizontalMouseWheelListener);
                }
                if (newVal instanceof JScrollBar) {
                    ((JScrollBar)newVal).addMouseWheelListener(this.horizontalMouseWheelListener);
                    PropertyUtil.installBackground((Component)((Component)newVal), (Color)this.getViewBackground());
                }
            }
        }
    }

    protected void updateScrollBarBackground() {
        Color bg = this.getViewBackground();
        PropertyUtil.installBackground((Component)this.scrollpane.getVerticalScrollBar(), (Color)bg);
        PropertyUtil.installBackground((Component)this.scrollpane.getHorizontalScrollBar(), (Color)bg);
    }

    @Override
    public void installUI(JComponent x) {
        super.installUI(x);
        this.oldLayout = (ScrollPaneLayout)x.getLayout();
        while (this.oldLayout instanceof ScrollLayoutManagerDelegate) {
            this.oldLayout = ((ScrollLayoutManagerDelegate)this.oldLayout).getDelegate();
        }
        if (this.oldLayout != null) {
            x.setLayout(new ScrollLayoutManagerDelegate(this.oldLayout){

                @Override
                public void layoutContainer(Container parent) {
                    Insets barInsets;
                    JScrollBar hsb;
                    super.layoutContainer(parent);
                    JScrollBar vsb = DarkScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (vsb == null) {
                        vsb = DarkScrollPaneUI.this.scrollpane.createHorizontalScrollBar();
                        DarkScrollPaneUI.this.scrollpane.setHorizontalScrollBar(vsb);
                    }
                    if ((hsb = DarkScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) == null) {
                        hsb = DarkScrollPaneUI.this.scrollpane.createHorizontalScrollBar();
                        DarkScrollPaneUI.this.scrollpane.setHorizontalScrollBar(hsb);
                    }
                    Component lowerRight = DarkScrollPaneUI.this.scrollpane.getCorner("LOWER_RIGHT_CORNER");
                    Component lowerLeft = DarkScrollPaneUI.this.scrollpane.getCorner("LOWER_LEFT_CORNER");
                    Rectangle vertBounds = vsb.getBounds();
                    Rectangle horBounds = hsb.getBounds();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        if (lowerRight == null && hsb.isVisible()) {
                            vertBounds.height += horBounds.height;
                        }
                    } else if (lowerLeft == null && hsb.isVisible()) {
                        vertBounds.height += horBounds.height;
                    }
                    if ((barInsets = UIManager.getInsets("ScrollPane.barInsets")) != null) {
                        vertBounds.height -= barInsets.top + barInsets.bottom;
                        vertBounds.y += barInsets.top;
                        horBounds.width -= barInsets.left + barInsets.right;
                        horBounds.x += barInsets.left;
                    }
                    vsb.setBounds(vertBounds);
                    hsb.setBounds(horBounds);
                }
            });
        }
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        this.updateScrollBarBackground();
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        this.getViewPropertyChangeListener().uninstall();
        this.scrollpane.addPropertyChangeListener(this.getPropertyChangeListener());
        this.scrollpane.getVerticalScrollBar().removeMouseWheelListener(this.verticalMouseWheelListener);
        this.scrollpane.getHorizontalScrollBar().removeMouseWheelListener(this.horizontalMouseWheelListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setLayout(this.oldLayout);
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return this.mouseWheelListener;
    }
}

