/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class DarkComboPopup
extends BasicComboPopup {
    private final AdjustmentListener adjustmentListener = e -> {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.list);
        MouseEvent ev = new MouseEvent(this.list, 503, 0L, 0, p.x, p.y, 1, false, 0);
        for (MouseMotionListener ml : this.list.getMouseMotionListeners()) {
            if (ml == null) continue;
            ml.mouseMoved(ev);
        }
    };
    private final int borderSize;
    private double lastEvent;
    private boolean visible = false;
    private OverlayScrollPane overlayScrollPane;

    public DarkComboPopup(JComboBox<Object> combo, int borderSize) {
        super(combo);
        this.borderSize = borderSize;
    }

    @Override
    protected JList<Object> createList() {
        JList<Object> list = super.createList();
        list.putClientProperty("JList..isComboList", true);
        return list;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (this.list.getModel().getSize() != 0) {
            int height = this.list.getUI().getCellBounds(this.list, (int)0, (int)0).height;
            this.overlayScrollPane.getVerticalScrollBar().setUnitIncrement(height);
        }
        this.visible = true;
        this.overlayScrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        this.lastEvent = System.currentTimeMillis();
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuCanceled();
    }

    @Override
    protected JScrollPane createScroller() {
        this.overlayScrollPane = new OverlayScrollPane(this.list, 20, 30);
        this.overlayScrollPane.getVerticalScrollBar().putClientProperty("JComponent.small", Boolean.TRUE);
        return this.overlayScrollPane.getScrollPane();
    }

    @Override
    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setOpaque(false);
        this.add(this.overlayScrollPane);
        this.setFocusable(false);
    }

    @Override
    public void show() {
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
    }

    protected void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    protected Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(this.borderSize, this.comboBox.getBounds().height - this.borderSize, popupSize.width - 2 * this.borderSize, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    @Override
    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds = DarkUIUtil.getScreenBounds(this.comboBox, null);
        Point pos = this.comboBox.getLocationOnScreen();
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (pos.y + py + ph > screenBounds.y + screenBounds.height) {
            if (pos.y - ph - this.borderSize >= screenBounds.y) {
                rect.y = -ph + this.borderSize;
            } else {
                rect.y = screenBounds.y + Math.max(0, (screenBounds.height - ph) / 2) - pos.y;
                rect.height = Math.min(screenBounds.height, ph);
            }
        }
        return rect;
    }

    @Override
    protected void togglePopup() {
        if (this.comboBox.getItemCount() == 0) {
            return;
        }
        if (this.visible) {
            this.visible = false;
            this.hide();
        } else if (this.lastEvent == 0.0 || (double)System.currentTimeMillis() - this.lastEvent > 250.0) {
            this.visible = true;
            SwingUtilities.invokeLater(this::show);
        }
    }

    protected void reset() {
        this.lastEvent = 0.0;
        if (this.visible) {
            this.hide();
        }
        this.visible = false;
    }
}

