/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.combobox.ComboBoxConstants;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkComboBoxBorder
implements Border,
UIResource {
    protected final DarkComboBoxUI ui;
    protected Insets boxPadding;
    protected Insets cellPadding;
    protected final int borderSize;
    protected final int arcSize;
    protected final Color focusBorderColor;
    protected final Color borderColor;
    protected final Color inactiveBorderColor;

    public DarkComboBoxBorder(DarkComboBoxUI ui) {
        this.ui = ui;
        this.arcSize = UIManager.getInt("ComboBox.arc");
        this.boxPadding = UIManager.getInsets("ComboBox.insets");
        this.borderSize = UIManager.getInt("ComboBox.borderThickness");
        this.focusBorderColor = UIManager.getColor("ComboBox.focusBorderColor");
        this.borderColor = UIManager.getColor("ComboBox.activeBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ComboBox.inactiveBorderColor");
        this.cellPadding = UIManager.getInsets("ComboBox.cellEditorInsets");
        if (this.boxPadding == null) {
            this.boxPadding = new Insets(0, 0, 0, 0);
        }
        if (this.cellPadding == null) {
            this.cellPadding = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        JComboBox<?> comboBox = this.ui.getComboBox();
        AbstractButton arrowButton = this.ui.getArrowButton();
        if (comboBox == null || arrowButton == null) {
            return;
        }
        boolean isTableCellEditor = ComboBoxConstants.isTableCellEditor(comboBox);
        boolean isTreeCellEditor = ComboBoxConstants.isTreeCellEditor(comboBox);
        boolean isCellEditor = isTableCellEditor || isTreeCellEditor;
        int bSize = !isCellEditor ? this.borderSize : 0;
        int editBSize = !isCellEditor ? this.borderSize + 1 : 0;
        this.ui.checkFocus();
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        Color borderColor = this.getBorderColor(c);
        if (!isCellEditor) {
            if (this.ui.getHasFocus()) {
                PaintUtil.paintFocusBorder(g, width, height, this.arcSize, this.borderSize);
                g.setColor(this.focusBorderColor);
            } else {
                g.setColor(borderColor);
            }
            PaintUtil.paintLineBorder(g, bSize, bSize, width - 2 * bSize, height - 2 * bSize, this.arcSize);
        } else {
            this.paintCellBorder(c, width, height, isTableCellEditor, g, borderColor);
        }
        if (comboBox.isEditable()) {
            Rectangle arrowBounds = arrowButton.getBounds();
            boolean leftToRight = comboBox.getComponentOrientation().isLeftToRight();
            int off = leftToRight ? arrowBounds.x : arrowBounds.x + arrowBounds.width - 1;
            g.setColor(borderColor);
            g.fillRect(off, editBSize, 1, height - 2 * editBSize);
        }
        g.translate(-x, -y);
    }

    protected void paintCellBorder(Component c, int width, int height, boolean isTableCellEditor, Graphics2D g, Color borderColor) {
        g.setColor(borderColor);
        Container parent = c.getParent();
        if (isTableCellEditor && parent instanceof JTable) {
            JTable table = (JTable)parent;
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect((Graphics)g, 0, 0, width, height, 1);
        }
    }

    protected Color getBorderColor(Component c) {
        return c.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (ComboBoxConstants.isTreeOrTableCellEditor(c)) {
            return CellUtil.adjustEditorInsets(new InsetsUIResource(this.cellPadding.top, this.cellPadding.left, this.cellPadding.bottom, this.cellPadding.right), c);
        }
        if (c.getComponentOrientation().isLeftToRight()) {
            return new InsetsUIResource(this.boxPadding.top, this.boxPadding.left, this.boxPadding.bottom, this.borderSize);
        }
        return new InsetsUIResource(this.boxPadding.top, this.borderSize, this.boxPadding.bottom, this.boxPadding.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

