/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.components.tree.LabeledTreeNode;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.ui.cell.CellRenderer;
import com.github.weisj.darklaf.ui.cell.CellToggleButton;
import com.github.weisj.darklaf.ui.cell.DarkCellBorderUIResource;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRendererDelegate;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DarkCellRendererToggleButton<T extends JToggleButton>
implements TableCellRenderer,
TreeCellRenderer,
SwingConstants {
    private final T toggleButton;
    private final Border border = new DarkCellBorderUIResource();

    public DarkCellRendererToggleButton(T toggleButton) {
        this.toggleButton = toggleButton;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean focus, int row, int column) {
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        }
        ((CellToggleButton)this.toggleButton).setHasFocus(focus);
        ((JComponent)this.toggleButton).setBorder(this.border);
        return this.toggleButton;
    }

    public T getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        } else {
            this.setValue(value);
            if (value instanceof LabeledTreeNode) {
                ((AbstractButton)this.toggleButton).setText(((LabeledTreeNode)value).getLabel());
            }
        }
        ((CellToggleButton)this.toggleButton).setHasFocus(false);
        ((AbstractButton)this.toggleButton).setHorizontalAlignment(tree.getComponentOrientation().isLeftToRight() ? 2 : 4);
        return this.toggleButton;
    }

    protected void setValue(Object value) {
        ((AbstractButton)this.toggleButton).setSelected(Boolean.TRUE.equals(DarkTreeCellRendererDelegate.unwrapValue(value)));
    }

    public T getButton() {
        return this.toggleButton;
    }

    public static class CellTristateButton
    extends TristateCheckBox
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellTristateButton(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
            this.putClientProperty("JToggleButton.iconBaselineOffset", 0);
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellRadioButton
    extends JRadioButton
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellRadioButton(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
            this.putClientProperty("JToggleButton.iconBaselineOffset", 0);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellCheckBox
    extends JCheckBox
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellCheckBox(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
            this.putClientProperty("JToggleButton.iconBaselineOffset", 0);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }
}

