/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.filetree;

import com.github.weisj.darklaf.components.filetree.FileNode;
import com.github.weisj.darklaf.components.filetree.FileTreeModel;
import com.github.weisj.darklaf.util.StreamUtil;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeNode;

public class FileTreeNode
implements TreeNode,
Comparable<FileTreeNode> {
    protected final FileTreeNode parent;
    protected final FileTreeModel model;
    protected final FileNode fileNode;
    protected AtomicInteger taskCount = new AtomicInteger();
    protected AtomicReference<List<FileTreeNode>> children;
    protected WatchKey watchKey;

    public FileTreeNode(FileTreeNode parent, FileNode fileNode, FileTreeModel model) {
        if (fileNode == null) {
            throw new IllegalArgumentException("File node is null");
        }
        this.model = model;
        this.fileNode = fileNode;
        this.parent = parent;
        this.children = new AtomicReference();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTreeNode that = (FileTreeNode)o;
        return Objects.equals(this.fileNode, that.fileNode);
    }

    public int hashCode() {
        return this.fileNode.hashCode();
    }

    public FileNode getFile() {
        return this.fileNode;
    }

    private int addSorted(List<FileTreeNode> nodes, FileTreeNode node) {
        int index = Collections.binarySearch(nodes, node);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        nodes.add(index, node);
        this.model.register(node);
        return index;
    }

    private int remove(List<FileTreeNode> nodes, FileTreeNode node) {
        int index = nodes.indexOf(node);
        if (index >= 0) {
            nodes.remove(node);
            this.model.unregister(node);
        }
        return index;
    }

    public void reload() {
        this.reload(Integer.MAX_VALUE);
    }

    protected void reload(int depth) {
        if (depth < 0) {
            return;
        }
        if (this.children.get() == null) {
            return;
        }
        List<FileTreeNode> fileList = this.children.get();
        this.doInBackground(pub -> this.traverseChildren(s -> Stream.concat(s.map(this::toNode), fileList.stream()).map(n -> {
            if (n.fileNode.notExists()) {
                return ReloadOp.remove(n, this.remove(fileList, (FileTreeNode)n));
            }
            if (this.model.showHiddenFiles) {
                if (!fileList.contains(n)) {
                    return ReloadOp.add(n, this.addSorted(fileList, (FileTreeNode)n));
                }
            } else {
                if (n.fileNode.isHidden()) {
                    return ReloadOp.remove(n, this.remove(fileList, (FileTreeNode)n));
                }
                if (!fileList.contains(n)) {
                    return ReloadOp.add(n, this.addSorted(fileList, (FileTreeNode)n));
                }
            }
            return null;
        }).forEach((Consumer<ReloadOp>)pub)), chunk -> {
            for (ReloadOp op : chunk) {
                if (op == null || op.index < 0) continue;
                switch (op.type) {
                    case ADD: {
                        this.model.nodesWereInserted(this, new int[]{op.index});
                        break;
                    }
                    case REMOVE: {
                        this.model.nodesWereRemoved(this, new int[]{op.index}, new Object[]{op.node});
                    }
                }
            }
        }, () -> {
            this.fileNode.invalidate();
            if (depth > 0) {
                fileList.forEach(n -> n.reload(depth - 1));
            }
        });
    }

    private List<FileTreeNode> getChildren() {
        return this.children.updateAndGet(list -> {
            if (list != null) {
                return list;
            }
            List fileList = Collections.synchronizedList(new ArrayList());
            this.doInBackground(pub -> this.traverseChildren(s -> s.filter(p -> this.model.showHiddenFiles || !p.isHidden()).map(this::toNode).sorted().map(n -> this.addSorted(fileList, (FileTreeNode)n)).forEach((Consumer<Integer>)pub)), chunks -> {
                int[] indices = chunks.stream().mapToInt(Integer::intValue).toArray();
                this.model.nodesWereInserted(this, indices);
            }, () -> this.model.nodeChanged(this));
            return fileList;
        });
    }

    public String toString() {
        return this.fileNode.toString();
    }

    protected FileTreeNode toNode(FileNode fileNode) {
        return this.model.createNode(this, fileNode);
    }

    protected void traverseChildren(Consumer<Stream<FileNode>> consumer) {
        if (this.fileNode.isDirectory()) {
            try (Stream<FileNode> files = this.fileNode.list(this.model);){
                consumer.accept(files.filter(FileNode::isReadable));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected <T> void doInBackground(Consumer<Consumer<T>> task, Consumer<List<T>> processor) {
        this.doInBackground(task, processor, () -> {});
    }

    protected <T> void doInBackground(final Consumer<Consumer<T>> task, final Consumer<List<T>> processor, final Runnable doneTask) {
        this.taskCount.getAndIncrement();
        SwingWorker worker = new SwingWorker<Void, T>(){

            @Override
            public Void doInBackground() {
                task.accept(xva$0 -> this.publish(xva$0));
                return null;
            }

            @Override
            protected void process(List<T> chunks) {
                processor.accept(chunks);
            }

            @Override
            protected void done() {
                doneTask.run();
                FileTreeNode.this.taskCount.getAndDecrement();
            }
        };
        worker.execute();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(node)) {
            return -1;
        }
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.fileNode.isDirectory();
    }

    @Override
    public boolean isLeaf() {
        if (!this.fileNode.isDirectory()) {
            return true;
        }
        if (this.children.get() != null && !this.isBusy()) {
            return this.children.get().size() == 0;
        }
        return this.fileNode.isEmpty(this.model.showHiddenFiles);
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        return Collections.enumeration((Collection)this.children.get());
    }

    public boolean isNodeChild(TreeNode aNode) {
        if (aNode == null) {
            return false;
        }
        return aNode.getParent() == this;
    }

    @Override
    public int compareTo(FileTreeNode o) {
        boolean oDir;
        if (o == null) {
            return -1;
        }
        boolean thisDir = this.fileNode.isDirectory();
        if (thisDir == (oDir = this.fileNode.isDirectory())) {
            return this.fileNode.compareTo(o.fileNode);
        }
        return thisDir ? -1 : 1;
    }

    public boolean isBusy() {
        return this.taskCount.get() > 0;
    }

    private static class ReloadOp {
        private final Type type;
        private final FileTreeNode node;
        private final int index;

        private ReloadOp(Type type, FileTreeNode node, int index) {
            this.type = type;
            this.node = node;
            this.index = index;
        }

        private static ReloadOp add(FileTreeNode n, int index) {
            return new ReloadOp(Type.ADD, n, index);
        }

        private static ReloadOp remove(FileTreeNode n, int index) {
            return new ReloadOp(Type.REMOVE, n, index);
        }

        private static enum Type {
            ADD,
            REMOVE;

        }
    }

    public static class RootNode
    extends FileTreeNode {
        private final List<FileNode> rootPaths;

        public RootNode(FileTreeModel model, List<FileNode> rootPaths) {
            super(null, new FileNode(null, null), model);
            this.rootPaths = rootPaths != null ? rootPaths : Collections.emptyList();
            this.init();
        }

        protected Stream<FileNode> createInitialDirectories() {
            return this.rootPaths.size() > 0 ? this.rootPaths.stream() : StreamUtil.iterableAsStream(FileSystems.getDefault().getRootDirectories()).map(FileNode::fromPath);
        }

        protected void init() {
            ArrayList nodes = new ArrayList();
            this.createInitialDirectories().forEach(p -> {
                FileTreeNode node = this.model.createNode(this, (FileNode)p);
                this.model.register(node);
                nodes.add(node);
            });
            this.children.set(nodes);
        }

        @Override
        protected void reload(int depth) {
            if (depth < 0) {
                return;
            }
            List nodes = (List)this.children.get();
            this.createInitialDirectories().forEach(p -> {
                FileTreeNode node = this.model.createNode(this, (FileNode)p);
                if (!nodes.contains(node)) {
                    this.model.register(node);
                    nodes.add(node);
                }
            });
            nodes.removeIf(n -> {
                if (n.fileNode.notExists()) {
                    this.model.unregister((FileTreeNode)n);
                    return true;
                }
                return false;
            });
            if (depth > 0) {
                ((List)this.children.get()).forEach(n -> n.reload(depth - 1));
            }
            this.fileNode.invalidate();
        }

        @Override
        public boolean isLeaf() {
            return ((List)this.children.get()).size() == 0;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }
    }
}

