/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.color.PopupColorChooser;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.SolidColorIcon;
import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class QuickColorChooser
extends JPanel {
    private final SolidColorIcon icon;
    private final JCheckBox checkBox;
    private final JLabel colorLabel;
    private final BiConsumer<Boolean, Color> onStatusChange;

    public QuickColorChooser(String title, Color color, Consumer<Color> onColorChange) {
        this(title, color, (b, c) -> onColorChange.accept((Color)c), false);
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange, boolean showCheckBox) {
        this.setLayout(new BoxLayout(this, 0));
        if (showCheckBox) {
            this.checkBox = new JCheckBox();
            this.checkBox.addActionListener(e -> onStatusChange.accept(this.isSelected(), this.getColor()));
            this.add(this.checkBox);
        } else {
            this.checkBox = null;
        }
        this.icon = new SolidColorIcon(color);
        this.colorLabel = new JLabel((Icon)this.icon, 2);
        this.onStatusChange = onStatusChange;
        QuickColorChooser.attachToComponent(this.colorLabel, this::onColorChange, () -> ((SolidColorIcon)this.icon).getColor());
        this.add(this.colorLabel);
        this.add(new JLabel(title, EmptyIcon.create((int)2, (int)2), 2));
    }

    private void onColorChange(Color c) {
        this.onStatusChange.accept(this.isSelected(), c);
        this.icon.setColor(c);
        this.colorLabel.repaint();
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange) {
        this(title, color, onStatusChange, true);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier) {
        QuickColorChooser.attachToComponent(component, onStatusChange, supplier, Boolean.TRUE::booleanValue);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier, Supplier<Boolean> activationCheck) {
        AtomicBoolean isShowing = new AtomicBoolean(false);
        component.addMouseListener(e -> {
            if (!component.isEnabled() || isShowing.get() || !((Boolean)activationCheck.get()).booleanValue()) {
                return;
            }
            isShowing.set(true);
            PopupColorChooser.showColorChooser(component, (Color)supplier.get(), c -> {
                if (c != null) {
                    onStatusChange.accept((Color)c);
                }
            }, event -> SwingUtilities.invokeLater(() -> isShowing.set(false)));
        });
    }

    public boolean isSelected() {
        return this.checkBox != null && this.checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        if (this.checkBox != null) {
            this.checkBox.setSelected(selected);
        }
    }

    public Color getColor() {
        return this.icon.getColor();
    }

    public void setColor(Color color) {
        this.onColorChange(color);
    }
}

