/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class MarginBorderWrapper
extends CompoundBorder {
    public MarginBorderWrapper(Border border) {
        super(border, new BasicBorders.MarginBorder());
    }

    public static void installBorder(JComponent c) {
        Border border = c.getBorder();
        if (!(border instanceof MarginBorderWrapper)) {
            c.setBorder(MarginBorderWrapper.wrapBorder(border));
        }
    }

    private static MarginBorderWrapper wrapBorder(Border border) {
        if (border instanceof UIResource) {
            return new UIBorder(border);
        }
        return new MarginBorderWrapper(border);
    }

    public static void uninstallBorder(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof MarginBorderWrapper) {
            c.setBorder(((MarginBorderWrapper)border).getOutsideBorder());
        }
    }

    public static Border getBorder(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof MarginBorderWrapper) {
            border = ((MarginBorderWrapper)border).getOutsideBorder();
        }
        return border;
    }

    public static class UIBorder
    extends MarginBorderWrapper
    implements UIResource {
        public UIBorder(Border border) {
            super(border);
        }
    }
}

