/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.task.FontDefaultsInitTask;
import com.github.weisj.darklaf.task.IdeaDefaultsInitTask;
import com.github.weisj.darklaf.task.InputDefaultsInitTask;
import com.github.weisj.darklaf.task.PlatformDefaultsInitTask;
import com.github.weisj.darklaf.task.RemoveUnusedInitTask;
import com.github.weisj.darklaf.task.ResourceBundleInitTask;
import com.github.weisj.darklaf.task.StyleSheetInitTask;
import com.github.weisj.darklaf.task.SystemDefaultsInitTask;
import com.github.weisj.darklaf.task.ThemeDefaultsInitTask;
import com.github.weisj.darklaf.task.UserInitTask;
import com.github.weisj.darklaf.task.UtilityDefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.laf.ThemedLookAndFeel;
import com.github.weisj.darklaf.ui.DarkPopupFactory;
import com.github.weisj.darklaf.ui.popupmenu.MouseGrabberUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DarkLaf
extends ThemedLookAndFeel {
    public static final String SYSTEM_PROPERTY_PREFIX = "darklaf.";
    public static final String ALLOW_NATIVE_CODE_FLAG = "darklaf.allowNativeCode";
    private static final Logger LOGGER = LogUtil.getLogger(DarkLaf.class);
    private static final DefaultsInitTask[] INIT_TASKS = new DefaultsInitTask[]{new RemoveUnusedInitTask(), new ThemeDefaultsInitTask(), new InputDefaultsInitTask(), new IdeaDefaultsInitTask(), new FontDefaultsInitTask(), new StyleSheetInitTask(), new ResourceBundleInitTask(), new SystemDefaultsInitTask(), new PlatformDefaultsInitTask(), new UserInitTask(), new UtilityDefaultsInitTask()};
    private final LookAndFeel base = this.getBase();
    private boolean isInitialized;
    private Theme theme;

    private LookAndFeel getBase() {
        LookAndFeel baseLaf;
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            baseLaf = new MetalLookAndFeel();
        } else {
            String systemLafClassName = UIManager.getSystemLookAndFeelClassName();
            LookAndFeel currentLaf = UIManager.getLookAndFeel();
            if (currentLaf != null && systemLafClassName.equals(currentLaf.getClass().getName())) {
                baseLaf = this.currentOrFallback(currentLaf);
            } else {
                try {
                    UIManager.setLookAndFeel(systemLafClassName);
                    baseLaf = this.currentOrFallback(UIManager.getLookAndFeel());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                    throw new IllegalStateException("Could not load base LaF class." + e.getMessage());
                }
            }
        }
        return baseLaf;
    }

    private LookAndFeel currentOrFallback(LookAndFeel currentLaf) {
        if (currentLaf != null) {
            return currentLaf;
        }
        return new MetalLookAndFeel();
    }

    public void initialize() {
        this.base.initialize();
        PopupFactory.setSharedInstance(new DarkPopupFactory());
        this.setupDecorations();
        this.isInitialized = true;
        SwingUtilities.invokeLater(LafManager::notifyThemeInstalled);
    }

    private void setupDecorations() {
        DecorationsHandler.getSharedInstance().initialize();
    }

    public void uninitialize() {
        this.base.uninitialize();
        MouseGrabberUtil.uninstallMouseGrabber();
        this.isInitialized = false;
        PopupFactory.setSharedInstance(new PopupFactory());
    }

    public UIDefaults getDefaults() {
        UIDefaults defaults = this.base.getDefaults();
        Theme currentTheme = this.getTheme();
        if (this.isInitialized && !LafManager.getTheme().equals(currentTheme)) {
            LafManager.setTheme(currentTheme);
        }
        for (DefaultsInitTask task : INIT_TASKS) {
            if (task.onlyDuringInstallation() && !this.isInitialized) continue;
            task.run(currentTheme, defaults);
        }
        return defaults;
    }

    public LayoutStyle getLayoutStyle() {
        return this.base.getLayoutStyle();
    }

    public void provideErrorFeedback(Component component) {
        this.base.provideErrorFeedback(component);
    }

    public Icon getDisabledIcon(JComponent component, Icon icon) {
        return this.base.getDisabledIcon(component, icon);
    }

    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        return this.base.getDisabledSelectedIcon(component, icon);
    }

    protected void setTheme(Theme theme) {
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme != null ? this.theme : LafManager.getTheme();
    }

    public String getName() {
        return "Darklaf";
    }

    public String getID() {
        return this.getName();
    }

    public String getDescription() {
        return "A themeable Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return true;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return false;
    }
}

