/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjpSampler
extends HTTPSamplerBase
implements Interruptible {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggerFactory.getLogger(AjpSampler.class);
    private static final char NEWLINE = '\n';
    private static final String COLON_SPACE = ": ";
    private static final String[] HEADER_TRANS_ARRAY = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    static final int AJP_HEADER_BASE = 40960;
    static final int MAX_SEND_SIZE = 8184;
    private transient Socket channel = null;
    private transient Socket activeChannel = null;
    private int lastPort = -1;
    private String lastHost = null;
    private String localName = null;
    private String localAddress = null;
    private final byte[] inbuf = new byte[8192];
    private final byte[] outbuf = new byte[8192];
    private final transient ByteArrayOutputStream responseData = new ByteArrayOutputStream();
    private int inpos = 0;
    private int outpos = 0;
    private transient String stringBody = null;
    private transient InputStream body = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean frd, int fd) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setSampleLabel(url.toExternalForm());
        res.sampleStart();
        try {
            this.setupConnection(url, method, res);
            this.activeChannel = this.channel;
            this.execute(method, res);
            res.sampleEnd();
            res.setResponseData(this.responseData.toByteArray());
            HTTPSampleResult hTTPSampleResult = res;
            return hTTPSampleResult;
        }
        catch (IOException iex) {
            res.sampleEnd();
            this.lastPort = -1;
            this.channel = null;
            HTTPSampleResult hTTPSampleResult = this.errorResult(iex, res);
            return hTTPSampleResult;
        }
        finally {
            this.activeChannel = null;
            JOrphanUtils.closeQuietly((Closeable)this.body);
            this.body = null;
        }
    }

    @Override
    public void threadFinished() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iex) {
                log.debug("Error closing channel", (Throwable)iex);
            }
        }
        this.channel = null;
        JOrphanUtils.closeQuietly((Closeable)this.body);
        this.body = null;
        this.stringBody = null;
    }

    private void setupConnection(URL url, String method, HTTPSampleResult res) throws IOException {
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0 || port == url.getDefaultPort()) {
            port = 8009;
        }
        String scheme = url.getProtocol();
        if (this.channel == null || !host.equals(this.lastHost) || port != this.lastPort) {
            if (this.channel != null) {
                this.channel.close();
            }
            this.channel = new Socket(host, port);
            int timeout = JMeterUtils.getPropDefault((String)"httpclient.timeout", (int)0);
            if (timeout > 0) {
                this.channel.setSoTimeout(timeout);
            }
            this.localAddress = this.channel.getLocalAddress().getHostAddress();
            this.localName = this.channel.getLocalAddress().getHostName();
            this.lastHost = host;
            this.lastPort = port;
        }
        res.setURL(url);
        res.setHTTPMethod(method);
        this.outpos = 4;
        this.setByte((byte)2);
        if (method.equals("POST")) {
            this.setByte((byte)4);
        } else {
            this.setByte((byte)2);
        }
        if (JMeterUtils.getPropDefault((String)"httpclient.version", (String)"1.1").equals("1.0")) {
            this.setString("HTTP/1.0");
        } else {
            this.setString("HTTP/1.1");
        }
        this.setString(url.getPath());
        this.setString(this.localAddress);
        this.setString(this.localName);
        this.setString(host);
        this.setInt(url.getDefaultPort());
        this.setByte("https".equalsIgnoreCase(scheme) ? (byte)1 : 0);
        this.setInt(this.getHeaderSize(method, url));
        String hdr = this.setConnectionHeaders(url, host, method);
        res.setRequestHeaders(hdr);
        res.setCookies(this.setConnectionCookies(url, this.getCookieManager()));
        String query = url.getQuery();
        if (query != null) {
            this.setByte((byte)5);
            this.setString(query);
        }
        this.setByte((byte)-1);
    }

    private int getHeaderSize(String method, URL url) {
        String authHeader;
        HeaderManager headers = this.getHeaderManager();
        CookieManager cookies = this.getCookieManager();
        AuthManager auth = this.getAuthManager();
        int hsz = 1;
        if (method.equals("POST")) {
            HTTPFileArg[] hfa = this.getHTTPFiles();
            hsz = hfa.length > 0 ? (hsz += 3) : (hsz += 2);
        }
        if (headers != null) {
            hsz += headers.size();
        }
        if (cookies != null) {
            hsz += cookies.getCookieCount();
        }
        if (auth != null && (authHeader = auth.getAuthHeaderForURL(url)) != null) {
            ++hsz;
        }
        return hsz;
    }

    private String setConnectionHeaders(URL url, String host, String method) throws IOException {
        String authHeader;
        HeaderManager headers = this.getHeaderManager();
        AuthManager auth = this.getAuthManager();
        StringBuilder hbuf = new StringBuilder();
        hbuf.append("Host").append(COLON_SPACE).append(host).append('\n');
        this.setInt(40971);
        this.setString(host);
        if (headers != null) {
            for (JMeterProperty jMeterProperty : headers.getHeaders()) {
                Header header = (Header)jMeterProperty.getObjectValue();
                String n = header.getName();
                String v = header.getValue();
                hbuf.append(n).append(COLON_SPACE).append(v).append('\n');
                int hc = this.translateHeader(n);
                if (hc > 0) {
                    this.setInt(hc + 40960);
                } else {
                    this.setString(n);
                }
                this.setString(v);
            }
        }
        if (method.equals("POST")) {
            int cl = -1;
            HTTPFileArg[] hfa = this.getHTTPFiles();
            if (hfa.length > 0) {
                HTTPFileArg fa = hfa[0];
                String fn = fa.getPath();
                File input = new File(fn);
                cl = (int)input.length();
                if (this.body != null) {
                    JOrphanUtils.closeQuietly((Closeable)this.body);
                    this.body = null;
                }
                this.body = new BufferedInputStream(new FileInputStream(input));
                this.setString("Content-Disposition");
                this.setString("form-data; name=\"" + this.encode(fa.getParamName()) + "\"; filename=\"" + this.encode(fn) + "\"");
                String mt = fa.getMimeType();
                hbuf.append("Content-Type").append(COLON_SPACE).append(mt).append('\n');
                this.setInt(40967);
                this.setString(mt);
            } else {
                hbuf.append("Content-Type").append(COLON_SPACE).append("application/x-www-form-urlencoded").append('\n');
                this.setInt(40967);
                this.setString("application/x-www-form-urlencoded");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (JMeterProperty arg : this.getArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append('&');
                    }
                    sb.append(arg.getStringValue());
                }
                this.stringBody = sb.toString();
                byte[] sbody = this.stringBody.getBytes();
                cl = sbody.length;
                this.body = new ByteArrayInputStream(sbody);
            }
            hbuf.append("Content-Length").append(COLON_SPACE).append(String.valueOf(cl)).append('\n');
            this.setInt(40968);
            this.setString(String.valueOf(cl));
        }
        if (auth != null && (authHeader = auth.getAuthHeaderForURL(url)) != null) {
            this.setInt(40965);
            this.setString(authHeader);
            hbuf.append("Authorization").append(COLON_SPACE).append(authHeader).append('\n');
        }
        return hbuf.toString();
    }

    private String encode(String value) {
        char[] chars;
        StringBuilder newValue = new StringBuilder();
        for (char c : chars = value.toCharArray()) {
            if (c == '\\') {
                newValue.append("\\\\");
                continue;
            }
            newValue.append(c);
        }
        return newValue.toString();
    }

    private String setConnectionCookies(URL url, CookieManager cookies) {
        String cookieHeader = null;
        if (cookies != null) {
            cookieHeader = cookies.getCookieHeaderForURL(url);
            for (JMeterProperty jMeterProperty : cookies.getCookies()) {
                Cookie cookie = (Cookie)jMeterProperty.getObjectValue();
                this.setInt(40969);
                this.setString(cookie.getName() + "=" + cookie.getValue());
            }
        }
        return cookieHeader;
    }

    private int translateHeader(String n) {
        for (int i = 0; i < HEADER_TRANS_ARRAY.length; ++i) {
            if (!HEADER_TRANS_ARRAY[i].equalsIgnoreCase(n)) continue;
            return i + 1;
        }
        return -1;
    }

    private void setByte(byte b) {
        this.outbuf[this.outpos++] = b;
    }

    private void setInt(int n) {
        this.outbuf[this.outpos++] = (byte)(n >> 8 & 0xFF);
        this.outbuf[this.outpos++] = (byte)(n & 0xFF);
    }

    private void setString(String s) {
        if (s == null) {
            this.setInt(65535);
        } else {
            int len = s.length();
            this.setInt(len);
            for (int i = 0; i < len; ++i) {
                this.setByte((byte)s.charAt(i));
            }
            this.setByte((byte)0);
        }
    }

    private void send() throws IOException {
        OutputStream os = this.channel.getOutputStream();
        int len = this.outpos;
        this.outpos = 0;
        this.setInt(4660);
        this.setInt(len - 4);
        os.write(this.outbuf, 0, len);
    }

    private void execute(String method, HTTPSampleResult res) throws IOException {
        this.send();
        if (method.equals("POST")) {
            res.setQueryString(this.stringBody);
            this.sendPostBody();
        }
        this.handshake(res);
    }

    private void handshake(HTTPSampleResult res) throws IOException {
        this.responseData.reset();
        int msg = this.getMessage();
        while (msg != 5) {
            if (msg == 3) {
                int len = this.getInt();
                this.responseData.write(this.inbuf, this.inpos, len);
            } else if (msg == 4) {
                this.parseHeaders(res);
            } else if (msg == 6) {
                this.setNextBodyChunk();
                this.send();
            }
            msg = this.getMessage();
        }
    }

    private void sendPostBody() throws IOException {
        this.setNextBodyChunk();
        this.send();
    }

    private void setNextBodyChunk() throws IOException {
        int nr = 0;
        if (this.body != null) {
            int len = this.body.available();
            if (len < 0) {
                len = 0;
            } else if (len > 8184) {
                len = 8184;
            }
            this.outpos = 4;
            if (len > 0) {
                nr = this.body.read(this.outbuf, this.outpos + 2, len);
            }
        } else {
            this.outpos = 4;
        }
        this.setInt(nr);
        this.outpos += nr;
    }

    private void parseHeaders(HTTPSampleResult res) throws IOException {
        int status = this.getInt();
        res.setResponseCode(Integer.toString(status));
        res.setSuccessful(200 <= status && status <= 399);
        String msg = this.getString();
        res.setResponseMessage(msg);
        int nh = this.getInt();
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1").append(status).append(" ").append(msg).append('\n');
        for (int i = 0; i < nh; ++i) {
            CookieManager cookies;
            String name;
            int thn = this.peekInt();
            if ((thn & 0xFF00) == 40960) {
                name = HEADER_TRANS_ARRAY[(thn & 0xFF) - 1];
                this.getInt();
            } else {
                name = this.getString();
            }
            String value = this.getString();
            if ("Content-Type".equalsIgnoreCase(name)) {
                res.setContentType(value);
                res.setEncodingAndType(value);
            } else if ("set-cookie".equalsIgnoreCase(name) && (cookies = this.getCookieManager()) != null) {
                cookies.addCookieFromHeader(value, res.getURL());
            }
            sb.append(name).append(COLON_SPACE).append(value).append('\n');
        }
        res.setResponseHeaders(sb.toString());
    }

    private int getMessage() throws IOException {
        int len;
        InputStream is = this.channel.getInputStream();
        this.inpos = 0;
        int nr = is.read(this.inbuf, this.inpos, 4);
        if (nr != 4) {
            this.channel.close();
            this.channel = null;
            throw new IOException("Connection Closed: " + nr);
        }
        this.getInt();
        int cpos = this.inpos;
        for (int toRead = len = this.getInt(); toRead > 0; toRead -= nr) {
            nr = is.read(this.inbuf, cpos, toRead);
            cpos += nr;
        }
        return this.getByte();
    }

    private byte getByte() {
        return this.inbuf[this.inpos++];
    }

    private int getInt() {
        int res = this.inbuf[this.inpos++] << 8 & 0xFF00;
        return res += this.inbuf[this.inpos++] & 0xFF;
    }

    private int peekInt() {
        int res = this.inbuf[this.inpos] << 8 & 0xFF00;
        return res += this.inbuf[this.inpos + 1] & 0xFF;
    }

    private String getString() throws IOException {
        int len = this.getInt();
        String s = new String(this.inbuf, this.inpos, len, "iso-8859-1");
        this.inpos += len + 1;
        return s;
    }

    public boolean interrupt() {
        Socket chan = this.activeChannel;
        if (chan != null) {
            this.activeChannel = null;
            try {
                chan.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return chan != null;
    }
}

