/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import java.util.Comparator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProviderLoader {
    private static final Logger log = LoggerFactory.getLogger(SecurityProviderLoader.class);
    private static final Pattern CONFIGURATION_REGEX = Pattern.compile("^(?<classname>[^:]+)(:(?<position>\\d+)(:(?<config>.+))?)?$");

    private SecurityProviderLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static void addSecurityProvider(Properties properties) {
        properties.keySet().stream().filter(key -> key.toString().matches("security\\.provider(\\.\\d+)?")).sorted(Comparator.comparing(String::valueOf)).forEach(key -> SecurityProviderLoader.addSecurityProvider(properties.get(key).toString()));
    }

    public static void addSecurityProvider(String securityProviderConfig) {
        Matcher matcher = CONFIGURATION_REGEX.matcher(securityProviderConfig);
        if (matcher.matches()) {
            String classname = matcher.group("classname");
            int position = Integer.parseInt(StringUtils.defaultString((String)matcher.group("position"), (String)"0"));
            String config = matcher.group("config");
            try {
                Class<Provider> providerClass = Class.forName(classname);
                Provider provider = null;
                if (config != null) {
                    provider = SecurityProviderLoader.tryConstructorWithString(providerClass, config);
                }
                if (provider == null) {
                    provider = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                int installedPosition = Security.insertProviderAt(provider, position);
                log.info("Security Provider {} ({}) is installed at position {}", new Object[]{provider.getClass().getSimpleName(), provider.getName(), installedPosition});
            }
            catch (Exception exception) {
                String message = String.format("Security Provider '%s' could not be installed.", classname);
                log.error(message, (Throwable)exception);
                System.err.print(message);
                System.err.println(" - see the log for more information.");
            }
        }
    }

    private static Provider tryConstructorWithString(Class<Provider> providerClass, String config) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Constructor<Provider> constructor = providerClass.getConstructor(String.class);
            return constructor.newInstance(config);
        }
        catch (NoSuchMethodException e) {
            log.warn("Security Provider {} has no constructor with a single String argument - try to use default constructor.", providerClass);
            return null;
        }
    }
}

