/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;

public class CollapseExpandTreeBranch
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeNode[] selectedNodes;
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        JTree jTree = GuiPackage.getInstance().getMainFrame().getTree();
        for (JMeterTreeNode currentNode : selectedNodes = treeListener.getSelectedNodes()) {
            if (currentNode.isLeaf()) continue;
            Object[] nodes = GuiPackage.getInstance().getTreeModel().getPathToRoot(currentNode);
            TreePath path = new TreePath(nodes);
            boolean collapse = "collapse".equals(e.getActionCommand());
            this.expandCollapseNode(jTree, path, collapse);
        }
    }

    private void expandCollapseNode(JTree jTree, TreePath parent, boolean collapse) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.isLeaf()) {
            return;
        }
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            TreePath path = parent.pathByAddingChild(child);
            this.expandCollapseNode(jTree, path, collapse);
        }
        if (collapse) {
            jTree.collapsePath(parent);
        } else {
            jTree.expandPath(parent);
        }
    }

    static {
        commands.add("collapse");
        commands.add("expand");
    }
}

