/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class PropertyUtil {
    public static void installSystemProperty(String key, String value) {
        String current = System.getProperty(key);
        if (current == null) {
            System.setProperty(key, value);
        }
    }

    public static void installBackground(Component component, Color color) {
        if (component == null || color == null) {
            return;
        }
        component.setBackground(PropertyUtil.chooseColor(component.getBackground(), color));
    }

    public static void installForeground(Component component, Color color) {
        if (component == null || color == null) {
            return;
        }
        component.setForeground(PropertyUtil.chooseColor(component.getForeground(), color));
    }

    public static void installBorder(JComponent component, Border border) {
        if (component == null) {
            return;
        }
        Border b = component.getBorder();
        if (b == null || b instanceof UIResource) {
            component.setBorder(border);
        }
    }

    public static void installFont(Component component, Font font) {
        if (component == null) {
            return;
        }
        Font f = component.getFont();
        if (f == null || f instanceof UIResource) {
            component.setFont(font);
        }
    }

    public static void uninstallProperty(JComponent c, String key) {
        PropertyUtil.installProperty(c, key, null);
    }

    public static void installProperty(JComponent c, String key, Object value) {
        if (c == null) {
            return;
        }
        Object current = c.getClientProperty(key);
        if (current == null || current instanceof UIResource) {
            c.putClientProperty(key, value);
        }
    }

    public static void installBooleanProperty(JComponent c, String key, String valueKey) {
        PropertyUtil.installProperty(c, key, UIManager.getBoolean(valueKey));
    }

    public static boolean getBooleanProperty(Component c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(Component c, String property, boolean defaultValue) {
        return c instanceof JComponent && PropertyUtil.getBooleanProperty((JComponent)c, property, defaultValue);
    }

    public static boolean getBooleanProperty(JComponent c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(JComponent c, String property, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        Object obj = c.getClientProperty(property);
        if (!defaultValue) {
            return Boolean.TRUE.equals(obj);
        }
        return !Boolean.FALSE.equals(obj);
    }

    public static <T> boolean isPropertyEqual(Component c, String property, T checkValue) {
        return c instanceof JComponent && PropertyUtil.isPropertyEqual((JComponent)c, property, checkValue);
    }

    public static <T> boolean isPropertyEqual(JComponent c, String property, T checkValue) {
        if (c == null) {
            return false;
        }
        Object obj = c.getClientProperty(property);
        return Objects.equals(checkValue, obj);
    }

    public static <T> T getObject(Component c, String key, Class<T> type, T defaultValue) {
        if (!(c instanceof JComponent)) {
            return defaultValue;
        }
        return PropertyUtil.getObject((JComponent)c, key, type, defaultValue);
    }

    public static <T> T getObject(JComponent c, String key, Class<T> type, T defaultValue) {
        Object obj = c.getClientProperty(key);
        if (type.isInstance(obj)) {
            return type.cast(obj);
        }
        return defaultValue;
    }

    public static Object getObject(Component c, String key) {
        return PropertyUtil.getObject(c, key, Object.class, null);
    }

    public static Color getColor(JComponent c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, key, Color.class, defaultValue);
    }

    public static Color getColor(Component c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, key, Color.class, defaultValue);
    }

    public static String getString(JComponent c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, key, String.class, defaultValue);
    }

    public static String getString(Component c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, key, String.class, defaultValue);
    }

    public static <T> T getObject(Component c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, key, type, null);
    }

    public static <T> T getObject(JComponent c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, key, type, null);
    }

    public static Color getColor(JComponent c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static Color getColor(Component c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static String getString(JComponent c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static String getString(Component c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static Integer getInteger(JComponent c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }

    public static Integer getInteger(JComponent c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }

    public static <T> List<T> getList(UIDefaults defaults, String key, Class<T> type) {
        Object obj = defaults.get(key);
        if (!(obj instanceof List)) {
            return Collections.emptyList();
        }
        List list = (List)obj;
        return PropertyUtil.asTypedList(list, type);
    }

    public static <T> List<T> asTypedList(List<?> list, Class<T> type) {
        return list.stream().filter(Objects::nonNull).filter(t -> type.isAssignableFrom(t.getClass())).map(type::cast).collect(Collectors.toList());
    }

    public static Color chooseColor(Color currentColor, Color newColor) {
        if (ColorUtil.canOverwriteColor(currentColor)) {
            return newColor;
        }
        return currentColor;
    }

    public static Integer getMnemonic(UIDefaults defaults, String key, Locale l) {
        return PropertyUtil.parseMnemonic(defaults.get(key, l));
    }

    public static Integer getMnemonic(String key, Locale l) {
        return PropertyUtil.parseMnemonic(UIManager.get(key, l));
    }

    private static Integer parseMnemonic(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return -1;
    }
}

