/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.ui.cell.CellRenderer;
import com.github.weisj.darklaf.ui.table.header.DarkTableHeaderRendererPane;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import sun.awt.SunToolkit;

public final class DarkUIUtil {
    private static final int CELL_SEARCH_DEPTH = 3;
    public static final IconLoader ICON_LOADER = IconLoader.get(IconLoader.class);
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();

    public static Border getUnwrappedBorder(JComponent c) {
        Border b = c.getBorder();
        while (b instanceof CompoundBorder) {
            b = ((CompoundBorder)b).getOutsideBorder();
        }
        return b;
    }

    public static Rectangle applyInsets(Rectangle rect, Insets insets) {
        if (insets != null && rect != null) {
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.right + insets.left;
            rect.height -= insets.bottom + insets.top;
        }
        return rect;
    }

    public static Insets invert(Insets ins) {
        return DarkUIUtil.scale(ins, -1);
    }

    public static Insets scale(Insets ins, int factor) {
        if (ins == null) {
            return null;
        }
        ins.left *= factor;
        ins.right *= factor;
        ins.top *= factor;
        ins.bottom *= factor;
        return ins;
    }

    public static Insets addInsets(Insets ins1, Insets ins2, boolean createNew) {
        if (createNew) {
            return DarkUIUtil.addInsets(DarkUIUtil.addInsets(new Insets(0, 0, 0, 0), ins1), ins2);
        }
        return DarkUIUtil.addInsets(ins1, ins2);
    }

    public static Insets addInsets(Insets ins1, int extra) {
        ins1.left += extra;
        ins1.right += extra;
        ins1.top += extra;
        ins1.bottom += extra;
        return ins1;
    }

    public static Insets addInsets(Insets ins1, int extra, boolean createNew) {
        if (createNew) {
            return DarkUIUtil.addInsets(DarkUIUtil.addInsets(new Insets(0, 0, 0, 0), ins1), extra);
        }
        return DarkUIUtil.addInsets(ins1, extra);
    }

    public static Insets addInsets(Insets ins1, Insets ins2) {
        if (ins2 == null) {
            return ins1;
        }
        if (ins1 != null) {
            ins1.left += ins2.left;
            ins1.right += ins2.right;
            ins1.top += ins2.top;
            ins1.bottom += ins2.bottom;
            return ins1;
        }
        return null;
    }

    public static Dimension addInsets(Dimension dim, Insets ins) {
        if (dim == null || ins == null) {
            return dim;
        }
        dim.width += ins.left + ins.right;
        dim.height += ins.top + ins.bottom;
        return dim;
    }

    public static void removeInsets(Rectangle rectangle, Insets insets) {
        if (insets != null && rectangle != null) {
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
        }
    }

    public static void repaint(Component component) {
        if (component != null && component.isVisible()) {
            component.repaint();
        }
    }

    public static void repaint(JComponent component, Rectangle bounds) {
        DarkUIUtil.repaint(component, bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    public static void repaint(JComponent component, Rectangle bounds, boolean immediately) {
        DarkUIUtil.repaint(component, bounds.x, bounds.y, bounds.width, bounds.height, immediately);
    }

    public static void repaint(JComponent component, int x, int y, int width, int height, boolean immediately) {
        if (component != null && component.isVisible()) {
            if (immediately) {
                component.paintImmediately(x, y, width, height);
            } else {
                component.repaint(x, y, width, height);
            }
        }
    }

    public static <T extends Component> void repaintChild(T component, Function<T, JComponent> func, Rectangle bounds) {
        DarkUIUtil.repaintChild(component, func, bounds, false);
    }

    public static <T extends Component> void repaintChild(T component, Function<T, JComponent> func, Rectangle bounds, boolean immediately) {
        if (component != null) {
            JComponent c = func.apply(component);
            Rectangle r = SwingUtilities.convertRectangle(component, bounds, c);
            r = r.intersection(new Rectangle(0, 0, c.getWidth(), c.getHeight()));
            DarkUIUtil.repaint(c, r, immediately);
        }
    }

    public static boolean hasFocus(Component c) {
        return DarkUIUtil.hasFocus(c, null);
    }

    public static boolean hasFocus(Component c, FocusEvent e) {
        Component focusParent = (Component)PropertyUtil.getObject((Component)c, (String)"focusParent", Component.class);
        return DarkUIUtil.hasFocusImpl(c, focusParent, e);
    }

    public static boolean hasFocusImpl(Component c, Component focusParent, FocusEvent e) {
        if (c == null) {
            return false;
        }
        if (c.hasFocus() || focusParent != null && focusParent.hasFocus()) {
            return true;
        }
        Component owner = null;
        if (e != null) {
            owner = e.getOppositeComponent();
        }
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        return owner != null && DarkUIUtil.isDescendingFrom(owner, c, focusParent);
    }

    private static boolean isDescendingFrom(Component a, Component b1, Component b2) {
        if (a == b1 || a == b2) {
            return true;
        }
        for (Container p = a.getParent(); p != null; p = p.getParent()) {
            if (p != b1 && p != b2) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFocus(Window w) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        return SwingUtilities.getWindowAncestor(owner) == w;
    }

    public static Container getUnwrappedParent(Component comp) {
        if (comp == null) {
            return null;
        }
        return SwingUtilities.getUnwrappedParent(comp);
    }

    public static Component unwrapComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (!(component.getParent() instanceof JLayer) && !(component.getParent() instanceof JViewport)) {
            return component;
        }
        Container parent = component.getParent();
        while (parent instanceof JLayer || parent instanceof JViewport) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static int getFocusAcceleratorKeyMask() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    public static <T> T getUIOfType(ComponentUI ui, Class<T> klass) {
        if (klass.isAssignableFrom(ui.getClass())) {
            return klass.cast(ui);
        }
        return null;
    }

    public static void doNotCancelPopupSetup(JComponent component) {
        component.putClientProperty("doNotCancelPopup", "doNotCancelPopup");
        component.putClientProperty("doNotCancelOnScroll", Boolean.TRUE);
    }

    public static boolean isInCell(Component c) {
        if (DarkUIUtil.getParentOfType(DarkTableHeaderRendererPane.class, c, 3) != null) {
            return false;
        }
        return DarkUIUtil.getParentOfType(c, 3, CellRendererPane.class, CellEditor.class, TableCellRenderer.class, TableCellEditor.class, TreeCellRenderer.class, TreeCellEditor.class, ListCellRenderer.class, CellRenderer.class) != null;
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        return DarkUIUtil.getParentOfType(cls, c, Integer.MAX_VALUE);
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c, int searchDepth) {
        int depth = 0;
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (cls.isAssignableFrom(eachParent.getClass())) {
                return cls.cast(eachParent);
            }
            if (depth >= searchDepth) break;
            ++depth;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T getParentOfType(Component c, Class<? extends T> ... classes) {
        return DarkUIUtil.getParentOfType(c, Integer.MAX_VALUE, classes);
    }

    @SafeVarargs
    public static <T> T getParentOfType(Component c, int searchDepth, Class<? extends T> ... classes) {
        int depth = 0;
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isAssignableFrom(eachParent.getClass())) continue;
                return clazz.cast(eachParent);
            }
            if (depth >= searchDepth) break;
            ++depth;
        }
        return null;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    public static boolean isTooltipShowing(JComponent component) {
        AbstractAction hideTipAction = (AbstractAction)component.getActionMap().get("hideTip");
        return hideTipAction.isEnabled();
    }

    public static MenuElement findEnabledChild(MenuElement[] e, MenuElement elem, boolean forward) {
        for (int i = 0; i < e.length; ++i) {
            if (e[i] != elem) continue;
            return DarkUIUtil.findEnabledChild(e, i, forward);
        }
        return null;
    }

    public static MenuElement findEnabledChild(MenuElement[] e, int fromIndex, boolean forward) {
        MenuElement result;
        if (forward) {
            result = DarkUIUtil.nextEnabledChild(e, fromIndex + 1, e.length - 1);
            if (result == null) {
                result = DarkUIUtil.nextEnabledChild(e, 0, fromIndex - 1);
            }
        } else {
            result = DarkUIUtil.previousEnabledChild(e, fromIndex - 1, 0);
            if (result == null) {
                result = DarkUIUtil.previousEnabledChild(e, e.length - 1, fromIndex + 1);
            }
        }
        return result;
    }

    private static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i >= toIndex; --i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    public static boolean isOverText(MouseEvent e, int index, JList<?> list) {
        Rectangle bounds = list.getCellBounds(index, index);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(index), index, false, false);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isOverText(JLabel label, Rectangle bounds, Point p) {
        textRect.setBounds(0, 0, 0, 0);
        iconRect.setBounds(0, 0, 0, 0);
        SwingUtilities.layoutCompoundLabel(label, label.getFontMetrics(label.getFont()), label.getText(), label.getIcon(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), bounds, iconRect, textRect, label.getIconTextGap());
        return textRect.contains(p);
    }

    public static boolean isOverText(MouseEvent e, int row, int column, JTable table) {
        Rectangle bounds = table.getCellRect(row, column, false);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiersEx() & 0x80) != 0;
    }

    public static void rotateRectangle(Rectangle rect) {
        int tmp = rect.x;
        rect.x = rect.y;
        rect.y = tmp;
        tmp = rect.width;
        rect.width = rect.height;
        rect.height = tmp;
    }

    public static void rotatePoint(Point p) {
        int tmp = p.x;
        p.x = p.y;
        p.y = tmp;
    }

    public static Insets getBorderInsets(JComponent comp) {
        Border border = comp.getBorder();
        if (border == null) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        return border.getBorderInsets(comp);
    }

    public static Point adjustForOrientation(Point p, int w, Component c) {
        if (!c.getComponentOrientation().isLeftToRight()) {
            p.x = c.getWidth() - p.x - w;
        }
        return p;
    }

    public static Rectangle getScreenBounds(JComponent target, Point p) {
        if (p == null) {
            return DarkUIUtil.getScreenBounds(target, target.getLocationOnScreen());
        }
        return DarkUIUtil.getScreenBounds(target, p.x, p.y);
    }

    public static Rectangle getScreenBounds(JComponent target, int x, int y) {
        return DarkUIUtil.getScreenBounds(target, x, y, true);
    }

    public static Rectangle getScreenBounds(JComponent target, int x, int y, boolean subtractInsets) {
        GraphicsConfiguration gc;
        GraphicsConfiguration graphicsConfiguration = gc = target != null ? target.getGraphicsConfiguration() : null;
        if (gc == null) {
            gc = DarkUIUtil.getGraphicsConfigurationForLocation(x, y);
        }
        if (gc == null) {
            return new Rectangle();
        }
        Rectangle sBounds = gc.getBounds();
        if (subtractInsets) {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            sBounds.x += screenInsets.left;
            sBounds.y += screenInsets.top;
            sBounds.width -= screenInsets.left + screenInsets.right;
            sBounds.height -= screenInsets.top + screenInsets.bottom;
        }
        return sBounds;
    }

    public static GraphicsConfiguration getGraphicsConfigurationForLocation(int x, int y) {
        GraphicsDevice[] devices;
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = env.getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle rect = config.getBounds();
            if (!rect.contains(x, y)) continue;
            return config;
        }
        return null;
    }

    public static int setAltGraphMask(int modifier) {
        return modifier | 0x2000;
    }

    public static boolean isScaleChanged(PropertyChangeEvent ev) {
        return DarkUIUtil.isScaleChanged(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
    }

    public static boolean isScaleChanged(String name, Object oldValue, Object newValue) {
        if (oldValue != newValue && "graphicsConfiguration".equals(name)) {
            GraphicsConfiguration newGC = (GraphicsConfiguration)oldValue;
            GraphicsConfiguration oldGC = (GraphicsConfiguration)newValue;
            AffineTransform newTx = newGC != null ? newGC.getDefaultTransform() : null;
            AffineTransform oldTx = oldGC != null ? oldGC.getDefaultTransform() : null;
            return !Objects.equals(newTx, oldTx);
        }
        return false;
    }

    public static boolean isUndecorated(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        return false;
    }

    public static Container getParentMatching(Container parent, Predicate<Container> test) {
        Container p;
        for (p = parent; p != null && !test.test(p); p = p.getParent()) {
        }
        return p;
    }

    public static Container getParentBeforeMatching(Container parent, Predicate<Container> test) {
        Container p = parent;
        Container prev = null;
        while (p != null && !test.test(p)) {
            prev = p;
            p = prev.getParent();
        }
        return prev;
    }

    public static Container getOpaqueParent(Container parent) {
        return DarkUIUtil.getParentMatching(parent, Component::isOpaque);
    }

    public static boolean supportsTransparency(Window window) {
        Optional<GraphicsDevice> gd = Optional.ofNullable(window).map(Component::getGraphicsConfiguration).map(GraphicsConfiguration::getDevice);
        return gd.map(d -> d.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)).orElse(false);
    }

    public static Dimension getPreferredSize(JComponent component) {
        if (component == null) {
            return new Dimension(0, 0);
        }
        LayoutManager layoutManager = component.getLayout();
        Dimension size = null;
        if (layoutManager != null) {
            size = layoutManager.preferredLayoutSize(component);
        }
        return size != null ? size : component.getPreferredSize();
    }

    public static Dimension getMinimumSize(JComponent component) {
        if (component == null) {
            return new Dimension(0, 0);
        }
        LayoutManager layoutManager = component.getLayout();
        Dimension size = null;
        if (layoutManager != null) {
            size = layoutManager.minimumLayoutSize(component);
        }
        return size != null ? size : component.getMinimumSize();
    }

    public static <T> T nullableCast(Class<T> type, Object o) {
        if (type != null && type.isInstance(o)) {
            return type.cast(o);
        }
        return null;
    }

    public static boolean isDecorated(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        return false;
    }
}

