/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.DarkTextUI;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class DarkTextListener
implements FocusListener,
PropertyChangeListener {
    private final JTextComponent editor;
    private final DarkTextUI ui;

    public DarkTextListener(JTextComponent editor, DarkTextUI ui) {
        this.editor = editor;
        this.ui = ui;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Caret caret = this.editor.getCaret();
        if (caret instanceof DarkCaret) {
            ((DarkCaret)caret).setPaintSelectionHighlight(true);
        }
        this.editor.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Caret caret = this.editor.getCaret();
        JPopupMenu popupMenu = this.editor.getComponentPopupMenu();
        Component other = e.getOppositeComponent();
        MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        if (popupMenu != null && other != null && SwingUtilities.isDescendingFrom(popupMenu, other) || path != null && path.length > 0 && path[0] == popupMenu) {
            return;
        }
        if (caret instanceof DarkCaret) {
            ((DarkCaret)caret).setPaintSelectionHighlight(false);
        }
        this.editor.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("ancestor".equals(key) || "JComponent.listCellEditor".equals(key) || "JComponent.isTableEditor".equals(key) || "JComponent.isTreeEditor".equals(key)) {
            this.ui.updateMargins();
        } else if ("JTextComponent.roundedSelection".equals(key)) {
            boolean rounded = PropertyUtil.getBooleanProperty((JComponent)this.editor, (String)"JTextComponent.roundedSelection");
            this.ui.getDarkCaret().setRoundedSelectionEdges(rounded);
            this.editor.repaint();
        } else if ("JTextComponent.hasError".equals(key)) {
            this.editor.repaint();
        } else if ("JTextComponent.extendSelection".equals(key)) {
            boolean extendLines = PropertyUtil.getBooleanProperty((JComponent)this.editor, (String)"JTextComponent.extendSelection");
            this.ui.getDarkCaret().setLineExtendingEnabled(extendLines);
            this.editor.repaint();
        } else if ("border".equals(key)) {
            this.ui.installBorder();
        } else if ("enabled".equals(key) || "editable".equals(key)) {
            this.ui.updateBackground(this.editor);
        }
    }
}

